/*
 * Copyright 2008-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.griffon.runtime.groovy.i18n;

import griffon.core.i18n.GroovyAwareMessageSource;
import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import org.codehaus.griffon.runtime.core.i18n.MessageSourceDecorator;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

import static griffon.util.GriffonClassUtils.requireNonEmpty;

/**
 * @author Andres Almiray
 * @since 2.4.0
 */
public class DefaultGroovyAwareMessageSource extends MessageSourceDecorator implements GroovyAwareMessageSource {
    public DefaultGroovyAwareMessageSource(@Nonnull MessageSource delegate) {
        super(delegate);
    }

    @Nonnull
    @Override
    public String getAt(@Nonnull String key) throws NoSuchMessageException {
        return getDelegate().getMessage(key);
    }

    @Nonnull
    public String getAt(@Nonnull List<?> keyAndArgs) throws NoSuchMessageException {
        requireNonEmpty(keyAndArgs, "Argument 'keyAndArgs' must not be null");
        String key = String.valueOf(keyAndArgs.get(0));
        List<Object> args = new ArrayList<>();
        if (keyAndArgs.size() > 1) {
            args.addAll(keyAndArgs.subList(1, keyAndArgs.size()));
        }
        return getMessage(key, args);
    }
}
