/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.codehaus.gmavenplus.groovyworkarounds.DotGroovyFile;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovyStubSourcesMojo;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateStubsMojo
extends AbstractGroovyStubSourcesMojo {
    protected static final Version GROOVY_1_9_0_BETA1 = new Version(1, 9, 0, "beta-1");
    protected static final Version GROOVY_1_9_0_BETA3 = new Version(1, 9, 0, "beta-3");
    protected static final Version GROOVY_1_8_3 = new Version(1, 8, 3);
    protected String sourceEncoding;
    protected Set<String> scriptExtensions;
    protected String targetBytecode;
    protected boolean debug;
    protected boolean verbose;
    protected int warningLevel;
    protected int tolerance;

    protected synchronized void doStubGeneration(Set<File> stubSources, List classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        this.classWrangler = new ClassWrangler(classpath, this.getLog());
        if (stubSources == null || stubSources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for stub generation.  Skipping.");
            return;
        }
        if (this.groovyVersionSupportsAction()) {
            this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
            this.logPluginClasspath();
            if (this.getLog().isDebugEnabled()) {
                try {
                    this.getLog().debug((CharSequence)("Project compile classpath:\n" + this.project.getCompileClasspathElements()));
                }
                catch (DependencyResolutionRequiredException e) {
                    this.getLog().warn((CharSequence)"Unable to log project compile classpath", (Throwable)e);
                }
            }
        } else {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support stub generation.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping stub generation."));
            return;
        }
        Class compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class javaStubCompilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.tools.javac.JavaStubCompilationUnit");
        Class groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupCompilerConfiguration(outputDirectory, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object javaStubCompilationUnit = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(javaStubCompilationUnitClass, compilerConfigurationClass, groovyClassLoaderClass, File.class), compilerConfiguration, groovyClassLoader, outputDirectory);
        this.addGroovySources(stubSources, compilerConfigurationClass, javaStubCompilationUnitClass, compilerConfiguration, javaStubCompilationUnit);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "compile", new Class[0]), javaStubCompilationUnit, new Object[0]);
        this.getLog().info((CharSequence)("Generated " + this.getStubs().size() + " stub" + (this.getStubs().size() > 1 || this.getStubs().size() == 0 ? "s" : "") + "."));
    }

    protected Object setupCompilerConfiguration(File outputDirectory, Class compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, this.targetBytecode);
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
        options.put("stubDir", outputDirectory);
        options.put("keepStubs", Boolean.TRUE);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setJointCompilationOptions", Map.class), compilerConfiguration, options);
        return compilerConfiguration;
    }

    protected void addGroovySources(Set<File> stubSources, Class compilerConfigurationClass, Class javaStubCompilationUnitClass, Object compilerConfiguration, Object javaStubCompilationUnit) throws InvocationTargetException, IllegalAccessException {
        this.getLog().debug((CharSequence)"Adding Groovy to generate stubs for:");
        for (File source : stubSources) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("    " + source));
            }
            if (this.classWrangler.getGroovyVersion().compareTo(GROOVY_1_8_3) >= 0 && (this.classWrangler.getGroovyVersion().compareTo(GROOVY_1_9_0_BETA1) < 0 || this.classWrangler.getGroovyVersion().compareTo(GROOVY_1_9_0_BETA3) > 0)) {
                Set<String> extensions = this.scriptExtensions != null && !this.scriptExtensions.isEmpty() ? this.scriptExtensions : DotGroovyFile.defaultScriptExtensions();
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setScriptExtensions", Set.class), compilerConfiguration, extensions);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class), javaStubCompilationUnit, source);
                continue;
            }
            DotGroovyFile dotGroovyFile = new DotGroovyFile(source);
            Set<String> extensions = this.scriptExtensions != null && !this.scriptExtensions.isEmpty() ? this.scriptExtensions : DotGroovyFile.defaultScriptExtensions();
            dotGroovyFile.setScriptExtensions(extensions);
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class), javaStubCompilationUnit, dotGroovyFile);
        }
    }

    protected void resetStubModifiedDates(Set<File> stubs) {
        for (File stub : stubs) {
            boolean success = stub.setLastModified(0L);
            if (success) continue;
            this.getLog().warn((CharSequence)("Unable to set modified time on stub " + stub.getAbsolutePath() + "."));
        }
    }
}

