/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.execute;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Settings;
import org.codehaus.gmaven.common.ArtifactItem;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.plugin.ComponentMojoSupport;
import org.codehaus.gmaven.plugin.execute.GroovyMavenProjectAdapter;
import org.codehaus.gmaven.plugin.execute.Source;
import org.codehaus.gmaven.runtime.ScriptExecutor;
import org.codehaus.gmaven.runtime.loader.realm.RealmManager;
import org.codehaus.gmaven.runtime.support.util.ResourceLoaderImpl;
import org.codehaus.gmaven.runtime.util.Callable;
import org.codehaus.gmaven.runtime.util.ClassSource;
import org.codehaus.gmaven.runtime.util.MagicAttribute;
import org.codehaus.gmaven.runtime.util.ResourceLoader;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteMojo
extends ComponentMojoSupport {
    private List pluginArtifacts;
    private Source source;
    private ArtifactItem[] classpath;
    public static final String CLASSPATH_INCLUDE_ALL = "all";
    public static final String CLASSPATH_INCLUDE_RUNTIME = "runtime";
    public static final String CLASSPATH_INCLUDE_ARTIFACTS = "artifacts";
    public static final String CLASSPATH_INCLUDE_PLUGINS = "plugins";
    public static final String CLASSPATH_INCLUDE_NONE = "none";
    private String classpathIncludes = "all";
    private File[] scriptpath;
    private Map defaults;
    private Map properties;
    private boolean trapAssertionErrors;
    private boolean sanitizeErrors;
    private MavenSession session;
    private Settings settings;
    private RealmManager realmManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExecuteMojo() {
        super(ScriptExecutor.KEY);
    }

    protected Set getClasspathIncludes() {
        HashSet<String> includes = new HashSet<String>();
        String[] items = this.classpathIncludes.trim().split(",");
        for (int i = 0; i < items.length; ++i) {
            items[i] = items[i].trim().toLowerCase();
            if (CLASSPATH_INCLUDE_NONE.equals(items[i])) {
                return new HashSet();
            }
            includes.add(items[i]);
        }
        return includes;
    }

    protected List getProjectClasspathElements() throws DependencyResolutionRequiredException {
        Artifact artifact;
        Iterator i;
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        Set includes = this.getClasspathIncludes();
        if (includes.contains(CLASSPATH_INCLUDE_ALL) || includes.contains(CLASSPATH_INCLUDE_RUNTIME)) {
            i = this.project.getRuntimeClasspathElements().iterator();
            while (i.hasNext()) {
                String fileName = (String)i.next();
                try {
                    results.add(new File(fileName).getCanonicalPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Classpath element not found: " + fileName, e);
                }
            }
        }
        if (includes.contains(CLASSPATH_INCLUDE_ALL) || includes.contains(CLASSPATH_INCLUDE_ARTIFACTS)) {
            i = this.project.getArtifacts().iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                if (!artifact.getType().equals("jar") || artifact.getClassifier() != null) continue;
                try {
                    results.add(artifact.getFile().getCanonicalPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Maven artifact file not found: " + artifact, e);
                }
            }
        }
        if (includes.contains(CLASSPATH_INCLUDE_ALL) || includes.contains(CLASSPATH_INCLUDE_PLUGINS)) {
            i = this.pluginArtifacts.iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                if (!artifact.getType().equals("jar") || artifact.getClassifier() != null) continue;
                try {
                    results.add(artifact.getFile().getCanonicalPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Maven plugin-artifact file not found: " + artifact, e);
                }
            }
        }
        return new ArrayList(results);
    }

    protected ArtifactItem[] getUserClassspathElements() {
        return this.classpath;
    }

    protected void process(Component component) throws Exception {
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        ScriptExecutor executor = (ScriptExecutor)component;
        if (this.source.configuration.getChildCount() != 0) {
            throw new MojoExecutionException("Invalid value for 'source' parameter; contains nested elements");
        }
        ClassSource classSource = ClassSource.forValue((String)this.escapeAsNeeded(this.source.configuration.getValue()));
        this.log.debug("Class source: {}", (Object)classSource);
        ClassRealm realm = this.realmManager.createComponentRealm(this.provider(), this.createClassPath());
        MojoResourceLoader resourceLoader = new MojoResourceLoader((URLClassLoader)realm, classSource);
        Configuration context = this.createContext();
        this.log.debug("Executing '''{}''' w/context: {}", (Object)this.source, (Object)context);
        Object result = executor.execute(classSource, (ClassLoader)realm, (ResourceLoader)resourceLoader, context);
        this.log.debug("Result: {}", result);
        this.realmManager.releaseComponentRealm(realm);
    }

    protected String escapeAsNeeded(String string) {
        StringBuilder sb = new StringBuilder(string);
        int index = 0;
        while (index > -1) {
            int i = sb.indexOf("\\", index);
            if (i > -1) {
                String str = sb.substring(i, i + 2);
                if (!str.contains("\\\\")) {
                    sb.insert(i, "\\");
                } else {
                    sb.delete(i, i + 1);
                }
                index = i + 3;
                continue;
            }
            index = i;
        }
        return sb.toString();
    }

    private Configuration createContext() {
        Configuration context = new Configuration();
        Logger logger = LoggerFactory.getLogger((String)(this.project.getGroupId() + "." + this.project.getArtifactId() + ".ExecuteMojo"));
        context.set("log", (Object)logger);
        GroovyMavenProjectAdapter projectAdapter = new GroovyMavenProjectAdapter(this.project, this.session, this.properties, this.defaults);
        context.set("project", (Object)projectAdapter);
        context.set("pom", (Object)projectAdapter);
        context.set("session", (Object)this.session);
        context.set("settings", (Object)this.settings);
        context.set("ant", (Object)MagicAttribute.ANT_BUILDER);
        context.set("fail", (Object)new FailClosure());
        return context;
    }

    static {
        $assertionsDisabled = !ExecuteMojo.class.desiredAssertionStatus();
    }

    private class FailClosure
    implements Callable {
        private FailClosure() {
        }

        public Object call(Object[] args) throws Exception {
            if (args == null || args.length == 0) {
                throw new MojoExecutionException("Failed");
            }
            if (args.length == 1) {
                if (args[0] instanceof Throwable) {
                    Throwable cause = (Throwable)args[0];
                    throw new MojoExecutionException(cause.getMessage(), cause);
                }
                throw new MojoExecutionException(String.valueOf(args[0]));
            }
            if (args.length == 2) {
                if (args[1] instanceof Throwable) {
                    throw new MojoExecutionException(String.valueOf(args[0]), (Throwable)args[1]);
                }
                throw new Error("Invalid arguments to fail(Object, Throwable), second argument must be a Throwable");
            }
            throw new Error("Too many arguments for fail(), expected one of: fail(), fail(Object) or fail(Object, Throwable)");
        }
    }

    private class MojoResourceLoader
    extends ResourceLoaderImpl {
        private final ClassSource classSource;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MojoResourceLoader(URLClassLoader classLoader, ClassSource classSource) {
            super((ClassLoader)classLoader);
            if (!$assertionsDisabled && classSource == null) {
                throw new AssertionError();
            }
            this.classSource = classSource;
        }

        protected URL resolve(String className, ClassLoader classLoader) throws MalformedURLException {
            URL url;
            File file;
            if (!$assertionsDisabled && className == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && classLoader == null) {
                throw new AssertionError();
            }
            String resource = this.toResourceName(className);
            if (ExecuteMojo.this.scriptpath != null) {
                for (int i = 0; i < ExecuteMojo.this.scriptpath.length; ++i) {
                    if (!$assertionsDisabled && ExecuteMojo.this.scriptpath[i] == null) {
                        throw new AssertionError();
                    }
                    file = new File(ExecuteMojo.this.scriptpath[i], resource);
                    if (!file.exists()) continue;
                    return file.toURI().toURL();
                }
            }
            if ((url = classLoader.getResource(resource)) == null && resource.startsWith("/")) {
                String tmp = resource.substring(1, resource.length());
                url = classLoader.getResource(tmp);
            }
            if (url == null) {
                File script = this.classSource.file;
                if (script != null && (file = new File(script.getParentFile(), resource)).exists()) {
                    return file.toURI().toURL();
                }
            } else {
                return url;
            }
            return super.resolve(className, classLoader);
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$gmaven$plugin$execute$ExecuteMojo == null ? (class$org$codehaus$gmaven$plugin$execute$ExecuteMojo = ExecuteMojo.class$("org.codehaus.gmaven.plugin.execute.ExecuteMojo")) : class$org$codehaus$gmaven$plugin$execute$ExecuteMojo).desiredAssertionStatus();
        }
    }
}

