/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.adapter.impl;

import com.google.common.base.Preconditions;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ClassSource;
import org.codehaus.gmaven.adapter.ResourceLoader;
import org.codehaus.gmaven.adapter.ScriptExecutor;
import org.codehaus.gmaven.adapter.impl.GroovyRuntimeImpl;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutorImpl
implements ScriptExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final GroovyRuntimeImpl runtime;

    ScriptExecutorImpl(GroovyRuntimeImpl runtime) {
        this.runtime = (GroovyRuntimeImpl)Preconditions.checkNotNull((Object)runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object execute(ClassSource classSource, ClassLoader classLoader, ResourceLoader resourceLoader, Map<String, Object> context, @Nullable Map<String, Object> options) throws Exception {
        Preconditions.checkNotNull((Object)classSource);
        Preconditions.checkNotNull((Object)classLoader);
        Preconditions.checkNotNull((Object)resourceLoader);
        Preconditions.checkNotNull(context);
        this.log.trace("Execute; class-source: {}, class-loader: {}, resource-loader: {}, context: {}", new Object[]{classSource, classLoader, resourceLoader, context});
        GroovyClassLoader gcl = this.runtime.createGroovyClassLoader(classLoader, resourceLoader);
        CompilerConfiguration cc = new CompilerConfiguration();
        Binding binding = this.runtime.createBinding(context);
        GroovyShell shell = new GroovyShell((ClassLoader)gcl, binding, cc);
        if (options != null) {
            this.configureOptions(shell, options);
        }
        GroovyCodeSource codeSource = this.runtime.createGroovyCodeSource(classSource);
        try {
            Object object = shell.evaluate(codeSource);
            return object;
        }
        finally {
            gcl.clearCache();
        }
    }

    private void configureOptions(GroovyShell shell, Map<String, Object> options) {
    }
}

