/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime.receiver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.binding.file.runtime.receiver.FileSystemReceiver;
import org.fabric3.binding.file.runtime.receiver.ReceiverConfiguration;
import org.fabric3.binding.file.runtime.receiver.ReceiverManager;

public class ReceiverManagerImpl
implements ReceiverManager {
    private Map<String, FileSystemReceiver> receivers = new ConcurrentHashMap<String, FileSystemReceiver>();

    public void create(ReceiverConfiguration configuration) {
        String id = configuration.getId();
        if (this.receivers.containsKey(id)) {
            throw new AssertionError((Object)("Duplicate receiver: " + id));
        }
        FileSystemReceiver receiver = new FileSystemReceiver(configuration);
        receiver.start();
        this.receivers.put(id, receiver);
    }

    public void remove(String id) {
        FileSystemReceiver receiver = this.receivers.remove(id);
        if (receiver != null) {
            receiver.stop();
        }
    }
}

