/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.binding.file.api.ReferenceAdapter;
import org.fabric3.binding.file.provision.FileBindingTargetDefinition;
import org.fabric3.binding.file.runtime.DefaultReferenceAdapter;
import org.fabric3.binding.file.runtime.ReferenceAdaptorWrapper;
import org.fabric3.binding.file.runtime.sender.FileSystemInterceptor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class FileTargetWireAttacher
implements TargetWireAttacher<FileBindingTargetDefinition> {
    private static final ReferenceAdapter ADAPTER = new DefaultReferenceAdapter();
    private ClassLoaderRegistry registry;
    private File baseDir;
    private ComponentManager manager;

    public FileTargetWireAttacher(@Reference ClassLoaderRegistry registry, @Reference ComponentManager manager, @Reference HostInfo hostInfo) {
        this.registry = registry;
        this.manager = manager;
        this.baseDir = new File(hostInfo.getDataDir(), "outbox");
    }

    public void attach(PhysicalSourceDefinition source, FileBindingTargetDefinition target, Wire wire) throws WiringException {
        File location = this.resolve(target.getLocation());
        location.mkdirs();
        ReferenceAdapter adapter = this.getAdaptor(target);
        FileSystemInterceptor interceptor = new FileSystemInterceptor(location, adapter);
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, FileBindingTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(FileBindingTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ReferenceAdapter getAdaptor(FileBindingTargetDefinition source) throws WiringException {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new WiringException("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new WiringException("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ReferenceAdaptorWrapper((AtomicComponent)component);
        }
        URI uri = source.getClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(uri);
        if (loader == null) {
            throw new WiringException("ClassLoader not found: " + uri);
        }
        try {
            return (ReferenceAdapter)loader.loadClass(adapterClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WiringException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

