/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exolab.castor.mapping.AbstractFieldHandler;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.UnmarshalState;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.location.XPathLocation;
import org.exolab.castor.xml.util.XMLFieldDescriptors;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class XMLClassDescriptorImpl
extends Validator
implements XMLClassDescriptor {
    private static final short ALL = 0;
    private static final short CHOICE = 1;
    private static final short SEQUENCE = 2;
    private static final String NULL_CLASS_ERR = "The Class passed as an argument to the constructor of XMLClassDescriptorImpl may not be null.";
    private static final String WILDCARD = "*";
    private XMLFieldDescriptors _attributes = null;
    private XMLFieldDescriptor[] _attArray = null;
    private Class<?> _class = null;
    private int _containerCount = 0;
    private XMLFieldDescriptor _contentDescriptor = null;
    private TypeValidator _validator = null;
    private XMLFieldDescriptors _elements = null;
    private XMLFieldDescriptor[] _elemArray = null;
    private String _nsPrefix = null;
    private String _nsURI = null;
    private String _xmlName;
    private boolean _elementDefinition = false;
    private XMLClassDescriptor _extends;
    private FieldDescriptor _identity;
    private AccessMode _accessMode;
    private boolean _introspected = false;
    private short _compositor = 0;
    private List<XMLFieldDescriptor> _sequenceOfElements = new ArrayList<XMLFieldDescriptor>();
    private List<String> _substitutes = new LinkedList<String>();
    private Map<String, Object> _properties = new HashMap<String, Object>();
    private Set<String> _natures = new HashSet<String>();

    public XMLClassDescriptorImpl(Class<?> type) {
        this();
        if (type == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = type;
    }

    public XMLClassDescriptorImpl(Class<?> type, String xmlName) {
        this();
        if (type == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = type;
        this.setXMLName(xmlName);
    }

    protected XMLClassDescriptorImpl() {
        this._attributes = new XMLFieldDescriptors(5);
        this._elements = new XMLFieldDescriptors(7);
    }

    public void addFieldDescriptor(XMLFieldDescriptor descriptor) {
        this.addFieldDescriptor(descriptor, true);
    }

    public boolean contains(XMLFieldDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (this._attributes.contains(descriptor)) {
            return true;
        }
        if (this._elements.contains(descriptor)) {
            return true;
        }
        return descriptor.equals(this._contentDescriptor);
    }

    @Override
    public XMLFieldDescriptor[] getAttributeDescriptors() {
        return (XMLFieldDescriptor[])this.getAttributeArray().clone();
    }

    @Override
    public XMLFieldDescriptor getContentDescriptor() {
        return this._contentDescriptor;
    }

    @Override
    public XMLFieldDescriptor[] getElementDescriptors() {
        return (XMLFieldDescriptor[])this.getElementArray().clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkDescriptorForCorrectOrderWithinSequence(XMLFieldDescriptor elementDescriptor, UnmarshalState parentState, String xmlName) throws ValidationException {
        boolean anyNode;
        if (this._compositor != 2 || this._sequenceOfElements.size() <= 0) return;
        if (parentState.getExpectedIndex() == this._sequenceOfElements.size()) {
            throw new ValidationException("Element with name " + xmlName + " passed to type " + this.getXMLName() + " in incorrect order; It is not allowed to be the last element of this sequence!");
        }
        XMLFieldDescriptor expectedElementDescriptor = this._sequenceOfElements.get(parentState.getExpectedIndex());
        String expectedElementName = expectedElementDescriptor.getXMLName();
        String elementName = xmlName;
        boolean bl = anyNode = expectedElementDescriptor.getFieldName().equals("_anyObject") && expectedElementName == null;
        if (!anyNode && expectedElementDescriptor.getXMLName().equals("-error-if-this-is-used-")) {
            ArrayList<String> possibleNames = new ArrayList<String>();
            this.fillPossibleNames(possibleNames, expectedElementDescriptor);
            if (!possibleNames.contains(elementName)) {
                if (expectedElementDescriptor.isRequired()) throw new ValidationException("Element with name " + elementName + " passed to type " + this.getXMLName() + " in incorrect order; expected element has to be member of the expected choice.");
                parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
                this.checkDescriptorForCorrectOrderWithinSequence(elementDescriptor, parentState, xmlName);
                return;
            } else {
                parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
            }
            return;
        }
        if (expectedElementDescriptor.isMultivalued() && !parentState.isWithinMultivaluedElement()) {
            parentState.setWithinMultivaluedElement(true);
        }
        if (!anyNode && !expectedElementName.equals(elementName)) {
            List<String> substitutes = expectedElementDescriptor.getSubstitutes();
            if (substitutes != null && !substitutes.isEmpty() && substitutes.contains(elementName)) {
                if (parentState.isWithinMultivaluedElement()) return;
                parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
                return;
            }
            if (expectedElementDescriptor.isMultivalued()) {
                parentState.setWithinMultivaluedElement(false);
                parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
                this.checkDescriptorForCorrectOrderWithinSequence(elementDescriptor, parentState, xmlName);
                return;
            }
            if (expectedElementDescriptor.isRequired()) {
                throw new ValidationException("Element with name " + elementName + " passed to type " + this.getXMLName() + " in incorrect order; expected element with name '" + expectedElementName + "' or any other optional element declared prior to it.");
            }
            parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
            this.checkDescriptorForCorrectOrderWithinSequence(elementDescriptor, parentState, xmlName);
            return;
        }
        if (parentState.isWithinMultivaluedElement()) return;
        parentState.setExpectedIndex(parentState.getExpectedIndex() + 1);
    }

    private void fillPossibleNames(List<String> possibleNames, XMLFieldDescriptor descriptor) {
        XMLFieldDescriptor[] descriptors = ((XMLClassDescriptor)descriptor.getClassDescriptor()).getElementDescriptors();
        if (descriptors.length == 0) {
            return;
        }
        for (XMLFieldDescriptor fieldDescriptor : descriptors) {
            if ("_items".equals(fieldDescriptor.getFieldName()) || "-error-if-this-is-used-".equals(fieldDescriptor.getXMLName())) {
                this.fillPossibleNames(possibleNames, fieldDescriptor);
                continue;
            }
            possibleNames.add(fieldDescriptor.getXMLName());
        }
    }

    @Override
    public XMLFieldDescriptor getFieldDescriptor(String name, String namespace, NodeType nodeType) {
        XMLClassDescriptor xcd;
        XMLFieldDescriptor desc;
        int i;
        int idx;
        boolean wild = nodeType == null || this._introspected;
        XMLFieldDescriptor result = null;
        XMLFieldDescriptor[] attributes = this._attArray;
        XMLFieldDescriptor[] elements = this._elemArray;
        String location = null;
        if (name != null && (idx = name.lastIndexOf(47)) >= 0) {
            location = name.substring(0, idx);
            name = name.substring(idx + 1);
        }
        if (wild || nodeType == NodeType.Element) {
            if (elements == null) {
                elements = this.getElementArray();
            }
            for (i = 0; i < elements.length; ++i) {
                desc = elements[i];
                if (desc == null || location != null && !location.equals(desc.getLocationPath())) continue;
                if (desc.matches(name)) {
                    if (!desc.matches(WILDCARD)) {
                        if (namespace == null || ResolveHelpers.namespaceEquals(namespace, desc.getNameSpaceURI())) {
                            return desc;
                        }
                    } else {
                        if (name.equals(desc.getXMLName())) {
                            return desc;
                        }
                        result = desc;
                    }
                }
                if (!desc.isContainer() || (xcd = (XMLClassDescriptor)desc.getClassDescriptor()) == this || xcd.getFieldDescriptor(name, namespace, NodeType.Element) == null) continue;
                result = desc;
                break;
            }
            if (result != null) {
                return result;
            }
        }
        if (wild || nodeType == NodeType.Attribute) {
            if (attributes == null) {
                attributes = this.getAttributeArray();
            }
            for (i = 0; i < attributes.length; ++i) {
                desc = attributes[i];
                if (desc == null || !desc.matches(name)) continue;
                return desc;
            }
        }
        if (nodeType == NodeType.Namespace) {
            if (attributes == null) {
                attributes = this.getAttributeArray();
            }
            for (i = 0; i < attributes.length; ++i) {
                if (attributes[i] == null || attributes[i].getNodeType() != NodeType.Namespace) continue;
                return attributes[i];
            }
        }
        if (nodeType == NodeType.Attribute) {
            if (elements == null) {
                elements = this.getElementArray();
            }
            for (i = 0; i < elements.length; ++i) {
                XMLFieldDescriptor temp;
                desc = elements[i];
                if (!desc.isContainer() || (xcd = (XMLClassDescriptor)desc.getClassDescriptor()) == this || (temp = xcd.getFieldDescriptor(name, namespace, NodeType.Attribute)) == null) continue;
                return desc;
            }
        }
        return null;
    }

    @Override
    public String getNameSpacePrefix() {
        return this._nsPrefix;
    }

    @Override
    public String getNameSpaceURI() {
        return this._nsURI;
    }

    @Override
    public TypeValidator getValidator() {
        if (this._validator != null) {
            return this._validator;
        }
        return this;
    }

    @Override
    public String getXMLName() {
        return this._xmlName;
    }

    public boolean isElementDefinition() {
        return this._elementDefinition;
    }

    public boolean hasContainerFields() {
        return this._containerCount > 0;
    }

    public boolean removeFieldDescriptor(XMLFieldDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        boolean removed = false;
        NodeType nodeType = descriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: 
            case 2: {
                if (!this._attributes.remove(descriptor)) break;
                removed = true;
                this._attArray = null;
                break;
            }
            case 3: {
                if (this._contentDescriptor != descriptor) break;
                this._contentDescriptor = null;
                removed = true;
                break;
            }
            default: {
                if (!this._elements.remove(descriptor)) break;
                this._elemArray = null;
                removed = true;
                if (!descriptor.isContainer()) break;
                --this._containerCount;
            }
        }
        return removed;
    }

    public void setCompositorAsAll() {
        this._compositor = 0;
    }

    public void setCompositorAsChoice() {
        this._compositor = 1;
    }

    public void setCompositorAsSequence() {
        this._compositor = (short)2;
    }

    public void setExtends(XMLClassDescriptor classDesc) {
        int i;
        FieldDescriptor[] fields = null;
        if (this._extends != null) {
            this.sortDescriptors();
            fields = this._extends.getFields();
            for (i = 0; i < fields.length; ++i) {
                this.removeFieldDescriptor((XMLFieldDescriptor)fields[i]);
            }
        }
        this._extends = classDesc;
        if (this._extends != null) {
            fields = classDesc.getFields();
            for (i = 0; i < fields.length; ++i) {
                this.addFieldDescriptor((XMLFieldDescriptor)fields[i], false);
            }
        }
    }

    public void setIdentity(XMLFieldDescriptor fieldDesc) {
        if (fieldDesc != null && !this._attributes.contains(fieldDesc) && !this._elements.contains(fieldDesc)) {
            this.addFieldDescriptor(fieldDesc);
        }
        this._identity = fieldDesc;
    }

    public void setNameSpacePrefix(String nsPrefix) {
        this._nsPrefix = nsPrefix;
    }

    public void setNameSpaceURI(String nsURI) {
        this._nsURI = nsURI;
    }

    public void setXMLName(String xmlName) {
        if (xmlName == null) {
            if (this._xmlName == null && this._class != null) {
                this._xmlName = this._class.getName();
            }
        } else {
            this._xmlName = xmlName;
        }
    }

    public void setElementDefinition(boolean elementDefinition) {
        this._elementDefinition = elementDefinition;
    }

    public void sortDescriptors() {
        XMLFieldDescriptor fieldDesc;
        int i;
        XMLFieldDescriptor[] descriptors = this.getAttributeArray();
        block8: for (i = 0; i < descriptors.length; ++i) {
            fieldDesc = descriptors[i];
            switch (fieldDesc.getNodeType().getType()) {
                case 1: {
                    this._elements.add(fieldDesc);
                    this._attributes.remove(fieldDesc);
                    this._attArray = null;
                    continue block8;
                }
                case 3: {
                    this._attributes.remove(fieldDesc);
                    this._attArray = null;
                    continue block8;
                }
            }
        }
        descriptors = this.getElementArray();
        block9: for (i = 0; i < descriptors.length; ++i) {
            fieldDesc = descriptors[i];
            switch (fieldDesc.getNodeType().getType()) {
                case 0: 
                case 2: {
                    this._attributes.add(fieldDesc);
                    this._elements.remove(fieldDesc);
                    this._elemArray = null;
                    continue block9;
                }
                case 3: {
                    this._elements.remove(fieldDesc);
                    this._elemArray = null;
                    continue block9;
                }
            }
        }
    }

    public String toString() {
        String str = super.toString() + "; descriptor for class: ";
        str = this._class != null ? str + this._class.getName() : str + "[null]";
        str = str + "; xml name: " + this._xmlName;
        return str;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        XMLFieldDescriptor desc;
        if (object == null) {
            throw new ValidationException("Cannot validate a null object.");
        }
        Class<?> a = this.getJavaClass();
        ClassLoader acl = a.getClassLoader();
        Class<?> b = object.getClass();
        ClassLoader bcl = b.getClassLoader();
        if (!this.getJavaClass().isAssignableFrom(object.getClass())) {
            String err = "The given object is not an instance of the class described by this ClassDecriptor.";
            throw new ValidationException(err);
        }
        XMLFieldDescriptor[] localElements = this.getElementArray();
        XMLFieldDescriptor[] localAttributes = this.getAttributeArray();
        if (this._extends != null) {
            if (this._extends instanceof XMLClassDescriptorImpl) {
                ((XMLClassDescriptorImpl)this._extends).validate(object, context);
            } else {
                TypeValidator baseValidator = this._extends.getValidator();
                if (baseValidator != null) {
                    baseValidator.validate(object, context);
                }
            }
            XMLFieldDescriptor[] inheritedElements = this._extends.getElementDescriptors();
            XMLFieldDescriptor[] allElements = localElements;
            localElements = new XMLFieldDescriptor[allElements.length - inheritedElements.length];
            int localIdx = 0;
            for (int i = 0; i < allElements.length; ++i) {
                desc = allElements[i];
                boolean isInherited = false;
                for (int idx = 0; idx < inheritedElements.length; ++idx) {
                    if (!inheritedElements[idx].equals(desc)) continue;
                    isInherited = true;
                    break;
                }
                if (isInherited) continue;
                localElements[localIdx] = desc;
                ++localIdx;
            }
            XMLFieldDescriptor[] inheritedAttributes = this._extends.getAttributeDescriptors();
            XMLFieldDescriptor[] allAttributes = localAttributes;
            localAttributes = new XMLFieldDescriptor[allAttributes.length - inheritedAttributes.length];
            localIdx = 0;
            for (int i = 0; i < allAttributes.length; ++i) {
                XMLFieldDescriptor desc2 = allAttributes[i];
                boolean isInherited = false;
                for (int idx = 0; idx < inheritedAttributes.length; ++idx) {
                    if (!inheritedAttributes[idx].equals(desc2)) continue;
                    isInherited = true;
                    break;
                }
                if (isInherited) continue;
                localAttributes[localIdx] = desc2;
                ++localIdx;
            }
        }
        switch (this._compositor) {
            case 1: {
                boolean found = false;
                boolean hasLocalDescs = localElements.length > 0;
                XMLFieldDescriptor fieldDesc = null;
                for (int i = 0; i < localElements.length; ++i) {
                    FieldHandler handler;
                    desc = localElements[i];
                    if (desc == null || (handler = desc.getHandler()).getValue(object) == null) continue;
                    if (desc.isMultivalued()) {
                        Object temp = handler.getValue(object);
                        if (Array.getLength(temp) == 0) {
                            temp = null;
                            continue;
                        }
                        temp = null;
                    }
                    if (found) {
                        String err = null;
                        if (desc.isContainer()) {
                            err = "The group '" + desc.getFieldName();
                            err = err + "' cannot exist at the same time that ";
                            err = fieldDesc.isContainer() ? err + "the group '" + fieldDesc.getFieldName() : err + "the element '" + fieldDesc.getXMLName();
                            err = err + "' also exists.";
                        } else {
                            err = "The element '" + desc.getXMLName();
                            err = err + "' cannot exist at the same time that ";
                            err = err + "element '" + fieldDesc.getXMLName() + "' also exists.";
                        }
                        throw new ValidationException(err);
                    }
                    found = true;
                    fieldDesc = desc;
                    FieldValidator fieldValidator = desc.getValidator();
                    if (fieldValidator == null) continue;
                    fieldValidator.validate(object, context);
                }
                if (!found && hasLocalDescs) {
                    StringBuffer buffer = new StringBuffer(40);
                    boolean existsOptionalElement = false;
                    buffer.append('(');
                    String sep = " | ";
                    for (int i = 0; i < localElements.length; ++i) {
                        XMLFieldDescriptor desc3 = localElements[i];
                        if (desc3 == null) continue;
                        FieldValidator fieldValidator = desc3.getValidator();
                        if (fieldValidator.getMinOccurs() == 0) {
                            existsOptionalElement = true;
                            break;
                        }
                        buffer.append(sep);
                        buffer.append(desc3.getXMLName());
                    }
                    buffer.append(')');
                    if (!existsOptionalElement) {
                        String err = "In the choice contained in <" + this.getXMLName() + ">, at least one of these elements must appear:\n" + buffer.toString();
                        throw new ValidationException(err);
                    }
                }
                for (int i = 0; i < localAttributes.length; ++i) {
                    this.validateField(object, context, localAttributes[i]);
                }
                if (this._contentDescriptor == null) break;
                this.validateField(object, context, this._contentDescriptor);
                break;
            }
            default: {
                int i;
                for (i = 0; i < localElements.length; ++i) {
                    XMLFieldDescriptor fieldDescriptor = localElements[i];
                    if (fieldDescriptor == null) continue;
                    this.validateField(object, context, fieldDescriptor);
                }
                for (i = 0; i < localAttributes.length; ++i) {
                    this.validateField(object, context, localAttributes[i]);
                }
                if (this._contentDescriptor == null) break;
                this.validateField(object, context, this._contentDescriptor);
            }
        }
    }

    private void validateField(Object object, ValidationContext context, XMLFieldDescriptor fieldDescriptor) throws ValidationException {
        FieldValidator fieldValidator = fieldDescriptor.getValidator();
        if (fieldValidator != null) {
            try {
                fieldValidator.validate(object, context);
            }
            catch (ValidationException e) {
                if (fieldDescriptor.getNodeType() == NodeType.Attribute || fieldDescriptor.getNodeType() == NodeType.Element) {
                    this.addLocationInformation(fieldDescriptor, e);
                }
                throw e;
            }
        }
    }

    private void addLocationInformation(XMLFieldDescriptor localElement, ValidationException e) {
        XPathLocation loc = (XPathLocation)e.getLocation();
        if (loc == null) {
            loc = new XPathLocation();
            e.setLocation(loc);
            if (localElement.getNodeType() == NodeType.Attribute) {
                loc.addAttribute(localElement.getXMLName());
            } else {
                loc.addChild(localElement.getXMLName());
            }
        }
    }

    @Override
    public Class<?> getJavaClass() {
        return this._class;
    }

    @Override
    public FieldDescriptor[] getFields() {
        int size = this._attributes.size();
        size += this._elements.size();
        if (this._contentDescriptor != null) {
            ++size;
        }
        FieldDescriptor[] fields = new XMLFieldDescriptor[size];
        this._attributes.toArray((XMLFieldDescriptor[])fields);
        this._elements.toArray((XMLFieldDescriptor[])fields, this._attributes.size());
        if (this._contentDescriptor != null) {
            fields[size - 1] = this._contentDescriptor;
        }
        return fields;
    }

    @Override
    public ClassDescriptor getExtends() {
        return this._extends;
    }

    @Override
    public FieldDescriptor getIdentity() {
        return this._identity;
    }

    public AccessMode getAccessMode() {
        return this._accessMode;
    }

    @Override
    public boolean canAccept(String name, String namespace, Object object) {
        Object tempObject;
        boolean result = false;
        boolean hasValue = false;
        XMLFieldDescriptor[] fields = null;
        int i = 0;
        XMLFieldDescriptor fieldDesc = this.getFieldDescriptor(name, namespace, NodeType.Element);
        if (fieldDesc == null) {
            fieldDesc = this.getFieldDescriptor(name, namespace, NodeType.Attribute);
        }
        if (fieldDesc == null) {
            return false;
        }
        if (fieldDesc.isMultivalued()) {
            int current;
            int newTotal;
            FieldValidator validator = fieldDesc.getValidator();
            result = validator != null ? (validator.getMaxOccurs() < 0 ? true : (newTotal = (current = Array.getLength(tempObject = fieldDesc.getHandler().getValue(object))) + 1) <= validator.getMaxOccurs()) : true;
        } else if (fieldDesc.isContainer()) {
            tempObject = fieldDesc.getHandler().getValue(object);
            result = tempObject == null ? true : ((XMLClassDescriptor)fieldDesc.getClassDescriptor()).canAccept(name, namespace, tempObject);
        } else {
            FieldHandler handler = fieldDesc.getHandler();
            boolean checkPrimitiveValue = true;
            if (handler instanceof AbstractFieldHandler) {
                hasValue = ((AbstractFieldHandler)handler).hasValue(object);
            } else {
                boolean bl = hasValue = handler.getValue(object) != null;
            }
            if (hasValue && checkPrimitiveValue && fieldDesc.getFieldType().isPrimitive() && XMLClassDescriptorImpl.isDefaultPrimitiveValue(handler.getValue(object))) {
                hasValue = false;
            }
            boolean bl = result = !hasValue;
        }
        if (result && this._compositor == 1 && fieldDesc.getNodeType() == NodeType.Element) {
            fields = this.getElementArray();
            for (i = 0; result && i < fields.length; ++i) {
                XMLFieldDescriptor desc = fields[i];
                if (desc == fieldDesc || object == null) continue;
                Object tempObj = desc.getHandler().getValue(object);
                boolean bl = hasValue = tempObj != null;
                if (!hasValue) continue;
                result = false;
                if (tempObj.getClass().isArray()) {
                    boolean bl2 = result = Array.getLength(tempObj) == 0;
                }
                if (!(tempObj instanceof Collection)) continue;
                result = ((Collection)tempObj).isEmpty();
            }
        }
        return result;
    }

    static boolean isPrimitive(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type == Boolean.class || type == Character.class) {
            return true;
        }
        return type.getSuperclass() == Number.class;
    }

    static boolean isDefaultPrimitiveValue(Object value) {
        block8: {
            if (value == null) {
                return false;
            }
            Class<?> type = value.getClass();
            if (type.isPrimitive()) {
                try {
                    return value.equals(type.newInstance());
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block8;
                }
                catch (InstantiationException instantiationException) {
                    break block8;
                }
            }
            if (type.getSuperclass() == Number.class) {
                return ((Number)value).intValue() == 0;
            }
            if (type == Boolean.class) {
                return value.equals(Boolean.FALSE);
            }
            if (type == Character.class) {
                return ((Character)value).charValue() == '\u0000';
            }
        }
        return false;
    }

    public void setJavaClass(Class<?> type) {
        this._class = type;
    }

    protected void setExtendsWithoutFlatten(XMLClassDescriptor classDesc) {
        this._extends = classDesc;
    }

    protected void setIntrospected(boolean introspected) {
        this._introspected = introspected;
    }

    private void addFieldDescriptor(XMLFieldDescriptor descriptor, boolean relink) {
        if (descriptor == null) {
            return;
        }
        boolean added = false;
        NodeType nodeType = descriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: 
            case 2: {
                added = this._attributes.add(descriptor);
                if (!added) break;
                this._attArray = null;
                break;
            }
            case 3: {
                this._contentDescriptor = descriptor;
                added = true;
                break;
            }
            default: {
                added = this._elements.add(descriptor);
                if (!added) break;
                this._elemArray = null;
                if (!descriptor.isContainer()) break;
                ++this._containerCount;
            }
        }
        if (added && relink) {
            descriptor.setContainingClassDescriptor(this);
        }
    }

    private XMLFieldDescriptor[] getAttributeArray() {
        XMLFieldDescriptor[] descriptors = this._attArray;
        if (descriptors == null) {
            descriptors = this._attributes.toArray();
            this._attArray = descriptors;
        }
        return descriptors;
    }

    private XMLFieldDescriptor[] getElementArray() {
        XMLFieldDescriptor[] descriptors = this._elemArray;
        if (descriptors == null) {
            descriptors = this._elements.toArray();
            this._elemArray = descriptors;
        }
        return descriptors;
    }

    protected void addSequenceElement(XMLFieldDescriptor element) {
        this._sequenceOfElements.add(element);
    }

    public List<String> getSubstitutes() {
        return this._substitutes;
    }

    public void setSubstitutes(List<String> substitutes) {
        this._substitutes = substitutes;
    }

    @Override
    public boolean isChoice() {
        return this._compositor == 1;
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public void addNature(String nature) {
        this._natures.add(nature);
    }

    public boolean hasNature(String nature) {
        return this._natures.contains(nature);
    }
}

