/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Vector;
import org.castor.core.util.Messages;
import org.exolab.castor.types.Duration;
import org.exolab.castor.types.Time;

public class Types {
    private static TypeInfo[] typeInfos = new TypeInfo[]{new TypeInfo("other", null, Object.class, false, null), new TypeInfo("string", null, String.class, true, null), new TypeInfo("integer", Integer.TYPE, Integer.class, true, new Integer(0)), new TypeInfo("int", Integer.TYPE, Integer.TYPE, true, new Integer(0)), new TypeInfo("long", Long.TYPE, Long.class, true, new Long(0L)), new TypeInfo("big-integer", null, BigInteger.class, true, BigInteger.valueOf(0L)), new TypeInfo("boolean", Boolean.TYPE, Boolean.class, true, Boolean.FALSE), new TypeInfo("double", Double.TYPE, Double.class, true, new Double(0.0)), new TypeInfo("float", Float.TYPE, Float.class, true, new Float(0.0f)), new TypeInfo("big-decimal", null, BigDecimal.class, true, new BigDecimal(0.0)), new TypeInfo("byte", Byte.TYPE, Byte.class, true, new Byte(0)), new TypeInfo("date", null, java.util.Date.class, true, null), new TypeInfo("timestamp", null, Timestamp.class, true, null), new TypeInfo("sqldate", null, Date.class, true, null), new TypeInfo("sqltime", null, java.sql.Time.class, true, null), new TypeInfo("short", Short.TYPE, Short.class, true, new Short(0)), new TypeInfo("char", Character.TYPE, Character.class, true, new Character('\u0000')), new TypeInfo("bytes", null, byte[].class, false, null), new TypeInfo("chars", null, char[].class, false, null), new TypeInfo("strings", null, String[].class, false, null), new TypeInfo("locale", null, Locale.class, true, null), new TypeInfo("stream", null, InputStream.class, true, null), new TypeInfo("clob", null, Types.getClobClass(), true, null), new TypeInfo("serializable", null, Serializable.class, false, null), new TypeInfo("[Lbyte;", null, byte[].class, false, null), new TypeInfo("[Lchar;", null, char[].class, false, null), new TypeInfo("[Ldouble;", null, double[].class, false, null), new TypeInfo("[Lfloat;", null, float[].class, false, null), new TypeInfo("[Lint;", null, int[].class, false, null), new TypeInfo("[Llong;", null, long[].class, false, null), new TypeInfo("[Lshort;", null, int[].class, false, null), new TypeInfo("[Lboolean;", null, int[].class, false, null), new TypeInfo("duration", null, Duration.class, false, new Duration(0L)), new TypeInfo("xml-date", null, org.exolab.castor.types.Date.class, false, new org.exolab.castor.types.Date(0L)), new TypeInfo("xml-time", null, Time.class, false, new Time(0L))};
    private static final Vector<Class<?>> ENUMS = new Vector();
    private static final Vector<Class<?>> CONVERTIBLE = new Vector();

    public static Class<?> typeFromName(ClassLoader loader, String typeName) throws ClassNotFoundException {
        for (TypeInfo typeInfo : typeInfos) {
            if (!typeName.equals(typeInfo.getShortName())) continue;
            return typeInfo.getPrimitive() != null ? typeInfo.getPrimitive() : typeInfo.getJavaType();
        }
        if (loader != null) {
            Class<?> aClass = Class.forName(typeName, false, loader);
            return aClass;
        }
        return Class.forName(typeName);
    }

    public static Object getDefault(Class<?> type) {
        for (TypeInfo typeInfo : typeInfos) {
            if (typeInfo.getPrimitive() != type && typeInfo.getJavaType() != type) continue;
            return typeInfo.getDefaultValue();
        }
        return null;
    }

    public static Class<?> typeFromPrimitive(Class<?> type) {
        if (type != null && type.isArray() && !type.getComponentType().isPrimitive()) {
            return Types.typeFromPrimitive(type.getComponentType());
        }
        for (TypeInfo typeInfo : typeInfos) {
            if (typeInfo.getPrimitive() != type) continue;
            return typeInfo.getJavaType();
        }
        return type;
    }

    public static boolean isSimpleType(Class<?> type) {
        for (TypeInfo typeInfo : typeInfos) {
            if (typeInfo.getJavaType() != type && typeInfo.getPrimitive() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveType(Class<?> type) {
        for (TypeInfo typeInfo : typeInfos) {
            if (typeInfo.getPrimitive() != type && (typeInfo.getJavaType() != type || typeInfo.getPrimitive() == null)) continue;
            return true;
        }
        return false;
    }

    public static void addEnumType(Class<?> type) {
        ENUMS.add(type);
    }

    public static boolean isEnumType(Class<?> type) {
        return ENUMS.contains(type);
    }

    public static void addConvertibleType(Class<?> type) {
        CONVERTIBLE.add(type);
    }

    public static boolean isConvertibleType(Class<?> type) {
        return CONVERTIBLE.contains(type);
    }

    public static Object newInstance(Class<?> type) throws IllegalStateException {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.schemaNotConstructable", (Object)type.getName(), (Object)except.getMessage()));
        }
        catch (InstantiationException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.schemaNotConstructable", (Object)type.getName(), (Object)except.getMessage()));
        }
    }

    public static Object newInstance(Class<?> type, Object[] args) throws IllegalStateException {
        if (args == null || args.length == 0) {
            return Types.newInstance(type);
        }
        try {
            Constructor<?> cons = Types.findConstructor(type, args);
            return cons.newInstance(args);
        }
        catch (NoSuchMethodException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.constructorNotFound", (Object)type.getName(), (Object)except.getMessage()));
        }
        catch (InvocationTargetException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.schemaNotConstructable", (Object)type.getName(), (Object)except.getMessage()));
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.schemaNotConstructable", (Object)type.getName(), (Object)except.getMessage()));
        }
        catch (InstantiationException except) {
            throw new IllegalStateException(Messages.format((String)"mapping.schemaNotConstructable", (Object)type.getName(), (Object)except.getMessage()));
        }
    }

    public static boolean isConstructable(Class<?> type) {
        return Types.isConstructable(type, false);
    }

    public static boolean isConstructable(Class<?> type, boolean allowAbstractOrInterface) {
        try {
            if ((type.getModifiers() & 1) == 0) {
                return false;
            }
            if (!allowAbstractOrInterface && (type.getModifiers() & 0x600) != 0) {
                return false;
            }
            if ((type.getConstructor(new Class[0]).getModifiers() & 1) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSerializable(Class<?> type) {
        return Serializable.class.isAssignableFrom(type);
    }

    public static boolean isImmutable(Class<?> type) {
        for (TypeInfo typeInfo : typeInfos) {
            if (typeInfo.getJavaType() != type && typeInfo.getPrimitive() != type) continue;
            return typeInfo.immutable;
        }
        return false;
    }

    public static boolean isCloneable(Class<?> type) {
        return Cloneable.class.isAssignableFrom(type);
    }

    private static Constructor<?> findConstructor(Class<?> type, Object[] args) throws NoSuchMethodException {
        Constructor<?>[] constructors = type.getConstructors();
        Constructor<?> cons = null;
        int rank = 0;
        for (int c = 0; c < constructors.length; ++c) {
            Class<?>[] paramTypes = constructors[c].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            int tmpRank = 0;
            boolean matches = true;
            for (int p = 0; p < paramTypes.length; ++p) {
                Class<?> pType;
                if (args[p] == null) {
                    if (!paramTypes[p].isPrimitive()) continue;
                    matches = false;
                    break;
                }
                if (paramTypes[p] == args[p].getClass()) {
                    ++tmpRank;
                    continue;
                }
                if (paramTypes[p].isAssignableFrom(args[p].getClass()) || paramTypes[p].isPrimitive() && (pType = Types.typeFromPrimitive(paramTypes[p])).isAssignableFrom(args[p].getClass())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            if (tmpRank == paramTypes.length) {
                return constructors[c];
            }
            if (cons != null && tmpRank <= rank) continue;
            cons = constructors[c];
            rank = tmpRank;
        }
        if (cons == null) {
            throw new NoSuchMethodException();
        }
        return cons;
    }

    private static final Class<?> getClobClass() {
        Class<?> type = null;
        try {
            type = Class.forName("java.sql.Clob");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return type;
    }

    static class TypeInfo {
        private final String shortName;
        private final Class<?> primitive;
        private final Class<?> javaType;
        private final boolean immutable;
        private final Object defaultValue;

        TypeInfo(String shortName, Class<?> primitive, Class<?> javaType, boolean immutable, Object defaultValue) {
            this.shortName = shortName;
            this.primitive = primitive;
            this.javaType = javaType;
            this.immutable = immutable;
            this.defaultValue = defaultValue;
        }

        Class<?> getJavaType() {
            return this.javaType;
        }

        String getShortName() {
            return this.shortName;
        }

        Class<?> getPrimitive() {
            return this.primitive;
        }

        boolean isImmutable() {
            return this.immutable;
        }

        Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

