/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.castor.core.util.Messages;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class ImportDescriptor
extends HandlerBase
implements Serializable {
    private static final long serialVersionUID = 197365948293655041L;
    private Hashtable _policies = new Hashtable();
    private boolean _insideRoot;

    public Enumeration listDNs() {
        return this._policies.keys();
    }

    public void addPolicy(String name, int policy) {
        this._policies.put(name, new Integer(policy));
    }

    public int getDirectPolicy(String name) {
        Integer policy = (Integer)this._policies.get(name);
        if (policy != null) {
            return policy;
        }
        return 0;
    }

    public int getPolicy(String name) {
        Integer policy = (Integer)this._policies.get(name);
        if (policy != null) {
            return policy;
        }
        DN dn = new DN(name);
        for (int i = 1; i < dn.size(); ++i) {
            name = dn.suffix(i);
            policy = (Integer)this._policies.get(name);
            if (policy == null) continue;
            return policy;
        }
        return 0;
    }

    public void produce(DocumentHandler docHandler) throws SAXException {
        AttributeListImpl attrList = new AttributeListImpl();
        docHandler.startElement("dsml", attrList);
        attrList = new AttributeListImpl();
        docHandler.startElement("import-policies", attrList);
        Enumeration enumeration = this.listDNs();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            int policy = this.getDirectPolicy(name);
            attrList = new AttributeListImpl();
            attrList.addAttribute("dn", "ID", name);
            if ((policy & 1) != 0) {
                attrList.addAttribute("delete-empty", null, "true");
            }
            if ((policy & 2) != 0) {
                attrList.addAttribute("replace-attr", null, "true");
            }
            if ((policy & 4) != 0) {
                attrList.addAttribute("refresh-only", null, "true");
            }
            if ((policy & 0x10) != 0) {
                attrList.addAttribute("update-only", null, "true");
            }
            if ((policy & 8) != 0) {
                attrList.addAttribute("new-attr-only", null, "true");
            }
            docHandler.startElement("import-policy", attrList);
            docHandler.endElement("import-policy");
        }
        docHandler.endElement("import-policies");
        docHandler.endElement("dsml");
    }

    @Override
    public void startElement(String tagName, AttributeList attr) throws SAXException {
        if (tagName.equals("dsml")) {
            if (this._insideRoot) {
                throw new SAXException(Messages.format((String)"dsml.elementNested", (Object)"dsml"));
            }
            this._insideRoot = true;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format((String)"dsml.expectingOpeningTag", (Object)"dsml", (Object)tagName));
            }
            if (!tagName.equals("import-policies")) {
                if (tagName.equals("import-policy")) {
                    String dn = attr.getValue("dn");
                    if (dn == null) {
                        throw new SAXException(Messages.format((String)"dsml.missingAttribute", (Object)"import-policy", (Object)"dn"));
                    }
                    int policy = 0;
                    if ("true".equals(attr.getValue("delete-empty"))) {
                        policy |= 1;
                    }
                    if ("true".equals(attr.getValue("refresh-only"))) {
                        policy |= 4;
                    }
                    if ("true".equals(attr.getValue("replace-attr"))) {
                        policy |= 2;
                    }
                    if ("true".equals(attr.getValue("new-attr-only"))) {
                        policy |= 8;
                    }
                    if ("true".equals(attr.getValue("update-only"))) {
                        policy |= 0x10;
                    }
                    this.addPolicy(dn, policy);
                } else {
                    throw new SAXException(Messages.format((String)"dsml.expectingOpeningTag", (Object)"import-policies", (Object)tagName));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String tagName) throws SAXException {
        if (tagName.equals("dsml")) {
            if (!this._insideRoot) throw new SAXException(Messages.format((String)"dsml.closingOutsideRoot", (Object)tagName));
            this._insideRoot = false;
            return;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format((String)"dsml.closingOutsideRoot", (Object)tagName));
            }
            if (tagName.equals("import-policies") || tagName.equals("import-policy")) return;
            throw new SAXException(Messages.format((String)"dsml.expectingClosingTag", (Object)"import-policies", (Object)tagName));
        }
    }

    static class DN {
        private String[] _names;

        DN(String name) {
            StringTokenizer token = new StringTokenizer(name, ", ");
            this._names = new String[token.countTokens()];
            int i = 0;
            while (token.hasMoreTokens()) {
                this._names[i] = token.nextToken();
                ++i;
            }
        }

        int size() {
            return this._names.length;
        }

        String suffix(int index) {
            StringBuffer name = new StringBuffer(this._names[index]);
            ++index;
            while (index < this._names.length) {
                name.append(',').append(this._names[index]);
                ++index;
            }
            return name.toString();
        }
    }

    static class Names {
        Names() {
        }

        static class Attribute {
            public static final String DN = "dn";
            public static final String DELETE_EMPTY = "delete-empty";
            public static final String REPLACE_ATTRIBUTE = "replace-attr";
            public static final String REFRESH_ONLY = "refresh-only";
            public static final String UPDATE_ONLY = "update-only";
            public static final String NEW_ATTRIBUTE_ONLY = "new-attr-only";

            Attribute() {
            }
        }

        static class Element {
            public static final String POLICIES = "import-policies";
            public static final String POLICY = "import-policy";

            Element() {
            }
        }
    }

    public static class Policy {
        public static final int DELETE_EMPTY = 1;
        public static final int REPLACE_ATTRIBUTE = 2;
        public static final int REFRESH_ONLY = 4;
        public static final int NEW_ATTRIBUTE_ONLY = 8;
        public static final int UPDATE_ONLY = 16;
        public static final int DEFAULT_POLICY = 0;
    }
}

