/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.types.BaseDescriptor;
import org.exolab.castor.types.DateTime;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLFieldHandler;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public class DateTimeDescriptor
extends BaseDescriptor {
    private static final String _xmlName = "dateTime";
    private static final XMLFieldDescriptorImpl _contentDescriptor = new XMLFieldDescriptorImpl(String.class, "content", "content", NodeType.Text);
    private static final FieldDescriptor[] _fields;

    public DateTimeDescriptor() {
        super(_xmlName, DateTime.class);
    }

    public XMLFieldDescriptor getContentDescriptor() {
        return _contentDescriptor;
    }

    public FieldDescriptor[] getFields() {
        return _fields;
    }

    static {
        _contentDescriptor.setHandler(new DateTimeDescriptor().new DateTimeFieldHandler());
        _fields = new FieldDescriptor[1];
        DateTimeDescriptor._fields[0] = _contentDescriptor;
    }

    class DateTimeFieldHandler
    extends XMLFieldHandler {
        public Object getValue(Object target) throws IllegalStateException {
            DateTime date = (DateTime)target;
            return date.toString();
        }

        public void setValue(Object target, Object value) throws IllegalStateException {
            if (!(target instanceof DateTime)) {
                String err = "DateTimeDescriptor#setValue: expected DateTime, received instead: " + target.getClass();
                throw new IllegalStateException(err);
            }
            DateTime dateTarget = (DateTime)target;
            if (value == null) {
                String err = "DateTimeDescriptor#setValue: null value.";
                throw new IllegalStateException(err);
            }
            try {
                DateTime temp = DateTime.parseDateTime(value.toString());
                dateTarget.setCentury(temp.getCentury());
                dateTarget.setYear(temp.getYear());
                dateTarget.setMonth(temp.getMonth());
                dateTarget.setDay(temp.getDay());
                dateTarget.setHour(temp.getHour());
                dateTarget.setMinute(temp.getMinute());
                dateTarget.setSecond(temp.getSeconds(), temp.getMilli());
                if (temp.isUTC()) {
                    dateTarget.setUTC();
                    dateTarget.setZone(temp.getZoneHour(), temp.getZoneMinute());
                    dateTarget.setZoneNegative(temp.isZoneNegative());
                }
            }
            catch (ParseException ex) {
                String err = "DateDescriptor#setValue: wrong value\n" + ex.getMessage();
                throw new IllegalStateException(err);
            }
        }

        public void resetValue(Object target) throws IllegalStateException {
        }

        public void checkValidity(Object object) throws ValidityException, IllegalStateException {
        }

        public Object newInstance(Object parent) throws IllegalStateException {
            return new DateTime();
        }
    }
}

