/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;

public abstract class AbstractMappingLoader2
implements MappingLoader {
    private ClassLoader _loader;
    private boolean _allowRedefinitions = false;
    private boolean _loaded = false;
    private List _descriptors = new Vector();
    private Map _descriptorsByClassname = new Hashtable();

    public AbstractMappingLoader2(ClassLoader loader) {
        this.setClassLoader(loader);
    }

    public final void clear() {
        this._allowRedefinitions = false;
        this._loaded = false;
        this._descriptors.clear();
        this._descriptorsByClassname.clear();
    }

    public final void setClassLoader(ClassLoader loader) {
        this._loader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    public final ClassLoader getClassLoader() {
        return this._loader;
    }

    public final void setAllowRedefinitions(boolean allow) {
        this._allowRedefinitions = allow;
    }

    public final boolean isAllowRedefinition() {
        return this._allowRedefinitions;
    }

    protected final void addDescriptor(ClassDescriptor descriptor) throws MappingException {
        String classname = descriptor.getJavaClass().getName();
        if (this._descriptorsByClassname.containsKey(classname)) {
            if (!this.isAllowRedefinition()) {
                throw new MappingException("mapping.duplicateDescriptors", classname);
            }
            for (ClassDescriptor d : this._descriptors) {
                if (!classname.equals(d.getJavaClass().getName())) continue;
                this._descriptors.remove(d);
            }
            this._descriptors.add(descriptor);
        } else {
            this._descriptors.add(descriptor);
        }
        this._descriptorsByClassname.put(classname, descriptor);
    }

    public final ClassDescriptor getDescriptor(String classname) {
        if (classname == null) {
            return null;
        }
        return (ClassDescriptor)this._descriptorsByClassname.get(classname);
    }

    public final Iterator descriptorIterator() {
        return this._descriptors.iterator();
    }

    public final List getDescriptors() {
        return this._descriptors;
    }

    protected final boolean loadMapping() {
        if (this._loaded) {
            return false;
        }
        this._loaded = true;
        return true;
    }
}

