/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.location.XPathLocation;

public class FieldValidator
extends Validator {
    private static final String ERROR_NAME = "-error-if-this-is-used-";
    private static final int DEFAULT_MIN = 0;
    private static final int DEFAULT_MAX = -1;
    private int _minOccurs = 0;
    private int _maxOccurs = -1;
    private XMLFieldDescriptor _descriptor = null;
    private TypeValidator _validator = null;

    public FieldValidator() {
    }

    public FieldValidator(TypeValidator validator) {
        this._validator = validator;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public TypeValidator getTypeValidator() {
        return this._validator;
    }

    public boolean hasTypeValidator() {
        return this._validator != null;
    }

    public void setMinOccurs(int minOccurs) {
        this._minOccurs = minOccurs < 0 ? 0 : minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this._maxOccurs = maxOccurs;
    }

    public void setDescriptor(XMLFieldDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    public void setValidator(TypeValidator validator) {
        this._validator = validator;
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (this._descriptor == null || object == null || context.isValidated(object)) {
            return;
        }
        if (this._descriptor.isTransient()) {
            return;
        }
        FieldHandler handler = this._descriptor.getHandler();
        if (handler == null) {
            return;
        }
        Object value = handler.getValue(object);
        if (value == null) {
            if (!this._descriptor.isRequired() || this._descriptor.isNillable()) {
                return;
            }
            if (this._descriptor.isRequired() && this._descriptor.getSchemaType() != null && this._descriptor.getSchemaType().equals("IDREF") && context.getInternalContext().getLenientIdValidation()) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.required.field.whose"), this._descriptor.getFieldName(), object.getClass().getName(), this._descriptor.getXMLName()));
            } else {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.required.field"), this._descriptor.getFieldName(), object.getClass().getName()));
            }
            throw new ValidationException(buff.toString());
        }
        if (this._descriptor.isReference()) {
            if (this._validator != null) {
                this._validator.validate(value, context);
            }
            return;
        }
        if (context != null) {
            if (context.isValidated(object)) {
                return;
            }
            context.addValidated(object);
        }
        Class<?> type = value.getClass();
        int size = 1;
        long occurence = -1L;
        try {
            if (type.isArray()) {
                if (type.getComponentType() != Byte.TYPE) {
                    size = Array.getLength(value);
                    if (this._validator != null) {
                        for (int i = 0; i < size; ++i) {
                            occurence = i + 1;
                            this._validator.validate(Array.get(value, i), context);
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            super.validate(Array.get(value, i), context);
                        }
                    }
                }
            } else if (value instanceof Enumeration) {
                size = 0;
                Enumeration enumeration = (Enumeration)value;
                while (enumeration.hasMoreElements()) {
                    ++size;
                    this.validateInstance(context, enumeration.nextElement());
                }
            } else if (value instanceof Vector) {
                Vector vector = (Vector)value;
                size = vector.size();
                for (int i = 0; i < size; ++i) {
                    occurence = i + 1;
                    this.validateInstance(context, vector.elementAt(i));
                }
            } else if (value instanceof List) {
                List list = (List)value;
                size = list.size();
                for (int i = 0; i < size; ++i) {
                    occurence = i + 1;
                    this.validateInstance(context, list.get(i));
                }
            } else {
                this.validateInstance(context, value);
            }
        }
        catch (ValidationException vx) {
            String err = MessageFormat.format(resourceBundle.getString("validatorField.error.exception"), this._descriptor.getFieldName(), object.getClass().getName());
            ValidationException validationException = new ValidationException(err, (Throwable)((Object)vx));
            this.addLocationInformation(this._descriptor, validationException, occurence);
            throw validationException;
        }
        if (size < this._minOccurs && (size != 0 || this._descriptor.isRequired())) {
            StringBuffer buff = new StringBuffer();
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.exception.min.occurs.whose"), this._minOccurs, this._descriptor.getFieldName(), object.getClass().getName(), this._descriptor.getXMLName()));
            } else {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.exception.min.occurs"), this._minOccurs, this._descriptor.getFieldName(), object.getClass().getName()));
            }
            throw new ValidationException(buff.toString());
        }
        if (this._maxOccurs >= 0 && size > this._maxOccurs) {
            StringBuffer buff = new StringBuffer();
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.exception.max.occurs.whose"), this._maxOccurs, this._descriptor.getFieldName(), object.getClass().getName(), this._descriptor.getXMLName()));
            } else {
                buff.append(MessageFormat.format(resourceBundle.getString("validatorField.error.exception.max.occurs"), this._maxOccurs, this._descriptor.getFieldName(), object.getClass().getName()));
            }
            throw new ValidationException(buff.toString());
        }
        if (context != null) {
            context.removeValidated(object);
        }
    }

    private void validateInstance(ValidationContext context, Object value) throws ValidationException {
        if (this._validator != null) {
            this._validator.validate(value, context);
        } else {
            super.validate(value, context);
        }
    }

    private void addLocationInformation(XMLFieldDescriptor fieldDescriptor, ValidationException e, long occurence) {
        XPathLocation loc = (XPathLocation)e.getLocation();
        if (loc == null) {
            loc = new XPathLocation();
            e.setLocation(loc);
            String xmlName = fieldDescriptor.getXMLName();
            if (occurence > 0L) {
                xmlName = xmlName + "[" + occurence + "]";
            }
            if (fieldDescriptor.getNodeType() == NodeType.Attribute) {
                loc.addAttribute(xmlName);
            } else {
                loc.addChild(xmlName);
            }
        }
    }
}

