/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.castor.core.util.Messages;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.ClonableFieldHandler;
import org.exolab.castor.mapping.ClonableFieldHandlerMarker;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ConfigurableFieldHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.mapping.handlers.EnumFieldHandler;
import org.exolab.castor.mapping.handlers.TransientFieldHandler;
import org.exolab.castor.mapping.loader.AbstractMappingLoader2;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldHandlerDef;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingLoader
extends AbstractMappingLoader2 {
    private static final String ADD_METHOD_PREFIX = "add";
    private static final String ENUM_METHOD_PREFIX = "enum";
    private static final String ITER_METHOD_PREFIX = "iterate";
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String CREATE_METHOD_PREFIX = "create";
    private static final String HAS_METHOD_PREFIX = "has";
    private static final String DELETE_METHOD_PREFIX = "delete";
    protected static final Class<?>[] EMPTY_ARGS = new Class[0];
    protected static final Class<?>[] STRING_ARG = new Class[]{String.class};
    protected static final String VALUE_OF = "valueOf";
    protected static final String NAME = "name";
    private InternalContext _internalContext;
    private final Map<String, FieldHandler> _fieldHandlers = new HashMap<String, FieldHandler>();

    protected AbstractMappingLoader(ClassLoader loader) {
        super(loader);
    }

    @Override
    public final String getSourceType() {
        return "CastorXmlMapping";
    }

    public abstract void loadMapping(MappingRoot var1, Object var2) throws MappingException;

    protected void createFieldHandlers(MappingRoot mapping) throws MappingException {
        Enumeration<? extends FieldHandlerDef> enumeration = mapping.enumerateFieldHandlerDef();
        while (enumeration.hasMoreElements()) {
            FieldHandlerDef def = enumeration.nextElement();
            String name = def.getName();
            if (this._fieldHandlers.containsKey(name)) {
                throw new MappingException(Messages.format((String)"mapping.dupFieldHandler", (Object)name));
            }
            Class<?> clazz = this.resolveType(def.getClazz());
            FieldHandler fieldHandler = null;
            try {
                if (!FieldHandler.class.isAssignableFrom(clazz)) {
                    throw new MappingException(Messages.format((String)"mapping.classNotFieldHandler", (Object)name, (Object)def.getClazz()));
                }
                fieldHandler = (FieldHandler)clazz.newInstance();
                this._fieldHandlers.put(name, fieldHandler);
            }
            catch (InstantiationException e) {
                throw new MappingException(e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException(e);
            }
            this.configureFieldHandler(def, fieldHandler);
        }
    }

    private void configureFieldHandler(FieldHandlerDef def, FieldHandler fieldHandler) throws MappingException {
        Properties params = new Properties();
        Enumeration<? extends Param> enumerateParam = def.enumerateParam();
        while (enumerateParam.hasMoreElements()) {
            Param par = enumerateParam.nextElement();
            params.put(par.getName(), par.getValue());
        }
        if (params.size() > 0) {
            if (!ConfigurableFieldHandler.class.isAssignableFrom(fieldHandler.getClass())) {
                throw new MappingException(Messages.format((String)"mapping.classNotConfigurableFieldHandler", (Object)def.getName(), (Object)def.getClazz()));
            }
            try {
                ((ConfigurableFieldHandler)fieldHandler).setConfiguration(params);
            }
            catch (ValidityException e) {
                throw new MappingException(Messages.format((String)"mapping.invalidFieldHandlerConfig", (Object)def.getName(), (Object)e.getMessage()), e);
            }
        }
    }

    protected final void createClassDescriptors(MappingRoot mapping) throws MappingException {
        Enumeration<? extends ClassMapping> enumeration = mapping.enumerateClassMapping();
        ArrayList<ClassMapping> retryList = new ArrayList<ClassMapping>();
        while (enumeration.hasMoreElements()) {
            ClassMapping clsMap = enumeration.nextElement();
            try {
                ClassDescriptor clsDesc = this.createClassDescriptor(clsMap);
                if (clsDesc == null) continue;
                this.addDescriptor(clsDesc);
            }
            catch (MappingException mx) {
                retryList.add(clsMap);
            }
        }
        for (ClassMapping classMapping : retryList) {
            ClassDescriptor clsDesc = this.createClassDescriptor(classMapping);
            if (clsDesc == null) continue;
            this.addDescriptor(clsDesc);
        }
        for (ClassDescriptor classDescriptor : this.getDescriptors()) {
            this.resolveRelations(classDescriptor);
        }
    }

    protected abstract ClassDescriptor createClassDescriptor(ClassMapping var1) throws MappingException;

    protected final ClassDescriptor getExtended(ClassMapping clsMap, Class<?> javaClass) throws MappingException {
        if (clsMap.getExtends() == null) {
            return null;
        }
        ClassMapping mapping = (ClassMapping)clsMap.getExtends();
        Class<?> type = this.resolveType(mapping.getName());
        ClassDescriptor result = this.getDescriptor(type.getName());
        if (result == null) {
            throw new MappingException("mapping.extendsMissing", mapping, javaClass.getName());
        }
        if (!result.getJavaClass().isAssignableFrom(javaClass)) {
            throw new MappingException("mapping.classDoesNotExtend", javaClass.getName(), result.getJavaClass().getName());
        }
        return result;
    }

    protected final ClassDescriptor getDepended(ClassMapping clsMap, Class<?> javaClass) throws MappingException {
        if (clsMap.getDepends() == null) {
            return null;
        }
        ClassMapping mapping = (ClassMapping)clsMap.getDepends();
        Class<?> type = this.resolveType(mapping.getName());
        ClassDescriptor result = this.getDescriptor(type.getName());
        if (result == null) {
            throw new MappingException("Depends not found: " + mapping + " " + javaClass.getName());
        }
        return result;
    }

    protected final void checkFieldNameDuplicates(FieldDescriptor[] fields, Class<?> cls) throws MappingException {
        for (int i = 0; i < fields.length - 1; ++i) {
            String fieldName = fields[i].getFieldName();
            for (int j = i + 1; j < fields.length; ++j) {
                if (!fieldName.equals(fields[j].getFieldName())) continue;
                throw new MappingException("The field " + fieldName + " appears twice in the descriptor for " + cls.getName());
            }
        }
    }

    protected abstract void resolveRelations(ClassDescriptor var1);

    protected final Class<?> resolveType(String typeName) throws MappingException {
        try {
            return Types.typeFromName(this.getClassLoader(), typeName);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("mapping.classNotFound", typeName);
        }
    }

    protected final FieldDescriptorImpl[] createFieldDescriptors(ClassMapping clsMap, Class<?> javaClass) throws MappingException {
        FieldMapping[] fldMap = null;
        if (clsMap.getClassChoice() != null) {
            fldMap = clsMap.getClassChoice().getFieldMapping();
        }
        if (fldMap == null || fldMap.length == 0) {
            return new FieldDescriptorImpl[0];
        }
        FieldDescriptorImpl[] fields = new FieldDescriptorImpl[fldMap.length];
        for (int i = 0; i < fldMap.length; ++i) {
            fields[i] = this.createFieldDesc(javaClass, fldMap[i]);
            fields[i].setIdentity(fldMap[i].getIdentity());
        }
        return fields;
    }

    protected final ClassMapping getOrigin(ClassMapping clsMap) {
        ClassMapping result = clsMap;
        while (result.getExtends() != null) {
            result = (ClassMapping)result.getExtends();
        }
        return result;
    }

    protected final FieldDescriptor[] divideFieldDescriptors(FieldDescriptor[] fields, String[] ids, FieldDescriptor[] identities) {
        ArrayList<FieldDescriptor> fieldList = new ArrayList<FieldDescriptor>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            int index = this.getIdColumnIndex(field, ids);
            if (index == -1) {
                fieldList.add(field);
                continue;
            }
            if (field instanceof FieldDescriptorImpl) {
                ((FieldDescriptorImpl)field).setRequired(true);
            }
            if (field.getHandler() instanceof FieldHandlerImpl) {
                ((FieldHandlerImpl)field.getHandler()).setRequired(true);
            }
            identities[index] = field;
        }
        FieldDescriptor[] result = new FieldDescriptor[fieldList.size()];
        return fieldList.toArray(result);
    }

    protected int getIdColumnIndex(FieldDescriptor field, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (!field.getFieldName().equals(ids[i])) continue;
            return i;
        }
        return -1;
    }

    protected FieldDescriptorImpl createFieldDesc(Class<?> javaClass, FieldMapping fieldMap) throws MappingException {
        boolean generalized;
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            fieldType = this.resolveType(fieldMap.getType());
        }
        CollectionHandler collectionHandler = null;
        if (fieldMap.getCollection() != null) {
            String colTypeName = fieldMap.getCollection().toString();
            Class<?> collectionType = CollectionHandlers.getCollectionType(colTypeName);
            collectionHandler = CollectionHandlers.getHandler(collectionType);
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, collectionHandler, fieldMap);
        ExtendedFieldHandler exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            handler = this.getFieldHandler(fieldMap);
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            collectionHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(collectionHandler);
        }
        if (generalized = exfHandler instanceof GeneralizedFieldHandler) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            FieldHandler custom = handler;
            TypeInfoReference typeInfoRef = new TypeInfoReference();
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                Method method;
                boolean isTypeSafeEnum = false;
                if (fieldType != null && !AbstractMappingLoader.isPrimitive(fieldType) && !this.hasPublicDefaultConstructor(fieldType) && (method = this.getStaticValueOfMethod(fieldType)) != null) {
                    handler = new EnumFieldHandler(fieldType, handler, method);
                    typeInfo.setImmutable(true);
                    isTypeSafeEnum = true;
                }
                if (!isTypeSafeEnum) {
                    typeInfo = typeInfoRef.typeInfo;
                }
            }
        }
        FieldDescriptorImpl fieldDesc = new FieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient());
        fieldDesc.setRequired(fieldMap.getRequired());
        fieldDesc.setCollection(fieldMap.getCollection());
        fieldDesc.setComparator(fieldMap.getComparator());
        fieldDesc.setCreateMethod(fieldMap.getCreateMethod());
        fieldDesc.setGetMethod(fieldMap.getGetMethod());
        fieldDesc.setSetMethod(fieldMap.getSetMethod());
        fieldDesc.setDirect(fieldMap.getDirect());
        fieldDesc.setLazy(fieldMap.isLazy());
        if (exfHandler != null) {
            exfHandler.setFieldDescriptor(fieldDesc);
        }
        return fieldDesc;
    }

    private FieldHandler<?> getFieldHandler(FieldMapping fieldMap) throws MappingException {
        FieldHandler handler = this._fieldHandlers.get(fieldMap.getHandler());
        if (handler != null) {
            if (!(handler instanceof ClonableFieldHandler) && !(handler instanceof ClonableFieldHandlerMarker)) {
                return handler;
            }
            String methodName = "copyFieldHandler";
            if (handler instanceof ClonableFieldHandler) {
                methodName = "copyInstance";
            }
            FieldHandler clonedHandler = handler;
            Class<?> classToClone = handler.getClass();
            try {
                Method method = classToClone.getMethod(methodName, null);
                clonedHandler = (FieldHandler)method.invoke((Object)handler, handler);
                return clonedHandler;
            }
            catch (Exception e) {
                String err = "The class '" + classToClone.getName() + "' must implement the ClonableFieldHandlerMarker interface.";
                throw new MappingException(err, e);
            }
        }
        Class<?> handlerClass = null;
        handlerClass = this.resolveType(fieldMap.getHandler());
        if (!FieldHandler.class.isAssignableFrom(handlerClass)) {
            String err = "The class '" + fieldMap.getHandler() + "' must implement " + FieldHandler.class.getName();
            throw new MappingException(err);
        }
        try {
            Constructor<?> constructor = handlerClass.getConstructor(new Class[0]);
            return (FieldHandler)constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
            throw new MappingException(err);
        }
    }

    private boolean hasPublicDefaultConstructor(Class<?> type) {
        try {
            Constructor<?> cons = type.getConstructor(EMPTY_ARGS);
            return Modifier.isPublic(cons.getModifiers());
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private Method getStaticValueOfMethod(Class<?> type) {
        try {
            Method method = type.getMethod(VALUE_OF, STRING_ARG);
            Class<?> returnType = method.getReturnType();
            if (returnType == null) {
                return null;
            }
            if (!type.isAssignableFrom(returnType)) {
                return null;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    protected final FieldHandler createFieldHandler(Class<?> javaClass, Class<?> fldType, FieldMapping fldMap, TypeInfoReference typeInfoRef) throws MappingException {
        Method method;
        if (fldMap.getTransient()) {
            return new TransientFieldHandler();
        }
        Class<?> collectionType = null;
        CollectionHandler collectionHandler = null;
        boolean colRequireGetSet = true;
        String fieldName = fldMap.getName();
        if (fldMap.getCollection() != null) {
            String colTypeName = fldMap.getCollection().toString();
            collectionType = CollectionHandlers.getCollectionType(colTypeName);
            collectionHandler = CollectionHandlers.getHandler(collectionType);
            colRequireGetSet = CollectionHandlers.isGetSetCollection(collectionType);
            if (collectionType == Object[].class) {
                if (fldType == null) {
                    String msg = "'type' is a required attribute for field that are array collections: " + fieldName;
                    throw new MappingException(msg);
                }
                Object obj = Array.newInstance(fldType, 0);
                collectionType = obj.getClass();
            }
        }
        FieldHandlerImpl handler = null;
        if (fldMap.getDirect()) {
            Field field = this.findField(javaClass, fieldName, collectionType == null ? fldType : collectionType);
            if (field == null) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fldType == null) {
                fldType = field.getType();
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, collectionHandler, fldMap);
            handler = new FieldHandlerImpl(field, typeInfoRef.typeInfo);
        } else if (fldMap.getGetMethod() == null && fldMap.getSetMethod() == null) {
            String methodName;
            if (fieldName == null) {
                throw new MappingException("mapping.missingFieldName", javaClass.getName());
            }
            ArrayList<Method> getSequence = new ArrayList<Method>();
            ArrayList<Method> setSequence = new ArrayList<Method>();
            Method getMethod = null;
            Method setMethod = null;
            try {
                int point;
                while ((point = fieldName.indexOf(46)) >= 0) {
                    String parentField = fieldName.substring(0, point);
                    String methodName2 = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(parentField);
                    Method method2 = javaClass.getMethod(methodName2, null);
                    if (AbstractMappingLoader.isAbstractOrStatic(method2)) {
                        throw new MappingException("mapping.accessorNotAccessible", methodName2, javaClass.getName());
                    }
                    getSequence.add(method2);
                    Class<?> nextClass = method2.getReturnType();
                    try {
                        methodName2 = SET_METHOD_PREFIX + AbstractMappingLoader.capitalize(parentField);
                        Class[] types = new Class[]{nextClass};
                        method2 = javaClass.getMethod(methodName2, types);
                        if (AbstractMappingLoader.isAbstractOrStatic(method2)) {
                            method2 = null;
                        }
                    }
                    catch (Exception ex) {
                        method2 = null;
                    }
                    setSequence.add(method2);
                    javaClass = nextClass;
                    fieldName = fieldName.substring(point + 1);
                }
                methodName = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                Class<?> returnType = collectionType == null ? fldType : collectionType;
                getMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, returnType, true);
                if (getMethod == null && (fldType == Boolean.class || fldType == Boolean.TYPE)) {
                    methodName = IS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                    getMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, returnType, true);
                }
            }
            catch (MappingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (getMethod == null) {
                String getAccessor = GET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                String isAccessor = IS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                throw new MappingException("mapping.accessorNotFound", getAccessor + "/" + isAccessor, collectionType == null ? fldType : collectionType, javaClass.getName());
            }
            if (fldType == null && collectionType == null) {
                fldType = getMethod.getReturnType();
            }
            if ((setMethod = AbstractMappingLoader.findAccessor(javaClass, methodName = SET_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName), collectionType == null ? fldType : collectionType, false)) == null && collectionType != null && colRequireGetSet) {
                throw new MappingException("mapping.accessorNotFound", methodName, collectionType == null ? fldType : collectionType, javaClass.getName());
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, collectionHandler, fldMap);
            fieldName = fldMap.getName();
            if (fieldName == null) {
                fieldName = getMethod == null ? setMethod.getName() : getMethod.getName();
            }
            Method[] getArray = null;
            Method[] setArray = null;
            if (getSequence.size() > 0) {
                getArray = new Method[getSequence.size()];
                getArray = getSequence.toArray(getArray);
                setArray = new Method[setSequence.size()];
                setArray = setSequence.toArray(setArray);
            }
            handler = new FieldHandlerImpl(fieldName, getArray, setArray, getMethod, setMethod, typeInfoRef.typeInfo);
            if (setMethod != null && setMethod.getName().startsWith(ADD_METHOD_PREFIX)) {
                handler.setAddMethod(setMethod);
            }
        } else {
            Method getMethod = null;
            Method setMethod = null;
            if (fldMap.getGetMethod() != null) {
                Class<Object> rtype = fldType;
                if (collectionType != null) {
                    String methodName = fldMap.getGetMethod();
                    rtype = methodName.startsWith(ENUM_METHOD_PREFIX) ? Enumeration.class : (methodName.startsWith(ITER_METHOD_PREFIX) ? Iterator.class : collectionType);
                }
                if ((getMethod = AbstractMappingLoader.findAccessor(javaClass, fldMap.getGetMethod(), rtype, true)) == null) {
                    throw new MappingException("mapping.accessorNotFound", fldMap.getGetMethod(), rtype, javaClass.getName());
                }
                if (fldType == null && collectionType == null) {
                    fldType = getMethod.getReturnType();
                }
            }
            if (fldMap.getSetMethod() != null) {
                String methodName = fldMap.getSetMethod();
                Class<?> type = fldType;
                if (collectionType != null && !methodName.startsWith(ADD_METHOD_PREFIX)) {
                    type = collectionType;
                }
                if (methodName.startsWith("%")) {
                    int index = 0;
                    String temp = methodName.substring(1);
                    try {
                        index = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException ex) {
                        throw new MappingException("mapping.invalidParameterIndex", temp);
                    }
                    if (index < 1 || index > 9) {
                        throw new MappingException("mapping.invalidParameterIndex", temp);
                    }
                } else {
                    setMethod = AbstractMappingLoader.findAccessor(javaClass, methodName, type, false);
                    if (setMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", methodName, type, javaClass.getName());
                    }
                    if (fldType == null) {
                        fldType = setMethod.getParameterTypes()[0];
                    }
                }
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fldType, collectionHandler, fldMap);
            fieldName = fldMap.getName();
            if (fieldName == null) {
                fieldName = getMethod == null ? setMethod.getName() : getMethod.getName();
            }
            handler = new FieldHandlerImpl(fieldName, null, null, getMethod, setMethod, typeInfoRef.typeInfo);
            if (setMethod != null && setMethod.getName().startsWith(ADD_METHOD_PREFIX)) {
                handler.setAddMethod(setMethod);
            }
        }
        String methodName = fldMap.getCreateMethod();
        if (methodName != null) {
            try {
                method = javaClass.getMethod(methodName, null);
                handler.setCreateMethod(method);
            }
            catch (Exception ex) {
                throw new MappingException("mapping.createMethodNotFound", methodName, javaClass.getName());
            }
        }
        if (fieldName != null && !Types.isSimpleType(fldType)) {
            try {
                methodName = CREATE_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                method = javaClass.getMethod(methodName, null);
                handler.setCreateMethod(method);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (fieldName != null) {
            try {
                Method hasMethod;
                methodName = fldMap.getHasMethod();
                if (methodName == null) {
                    methodName = HAS_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                }
                if (((hasMethod = javaClass.getMethod(methodName, null)).getModifiers() & 8) != 0) {
                    hasMethod = null;
                }
                Method deleteMethod = null;
                try {
                    methodName = DELETE_METHOD_PREFIX + AbstractMappingLoader.capitalize(fieldName);
                    deleteMethod = javaClass.getMethod(methodName, null);
                    if ((deleteMethod.getModifiers() & 8) != 0) {
                        deleteMethod = null;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                handler.setHasDeleteMethod(hasMethod, deleteMethod);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return handler;
    }

    private static boolean isAbstract(Class<?> cls) {
        return (cls.getModifiers() & 0x400) != 0;
    }

    private static boolean isAbstractOrStatic(Method method) {
        return (method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0;
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        return new TypeInfo(Types.typeFromPrimitive(fieldType), null, null, fieldMap.getRequired(), null, colHandler, false);
    }

    private final Field findField(Class<?> javaClass, String fieldName, Class<?> fieldType) throws MappingException {
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fieldType == null) {
                fieldType = Types.typeFromPrimitive(field.getType());
            } else {
                Class<?> ft2;
                Class<?> ft1 = Types.typeFromPrimitive(fieldType);
                if (ft1 != (ft2 = Types.typeFromPrimitive(field.getType())) && fieldType != Serializable.class) {
                    throw new MappingException("mapping.fieldTypeMismatch", field, fieldType.getName());
                }
            }
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static final Method findAccessor(Class<?> javaClass, String methodName, Class<?> fieldType, boolean getMethod) throws MappingException {
        try {
            Method method = null;
            if (getMethod) {
                method = javaClass.getMethod(methodName, new Class[0]);
                if (javaClass == MapItem.class) {
                    if (methodName.equals("getKey")) {
                        return method;
                    }
                    if (methodName.equals("getValue")) {
                        return method;
                    }
                }
                if (fieldType == null) {
                    fieldType = Types.typeFromPrimitive(method.getReturnType());
                } else {
                    fieldType = Types.typeFromPrimitive(fieldType);
                    Class<?> returnType = Types.typeFromPrimitive(method.getReturnType());
                    if (fieldType.isInterface() || (fieldType.getModifiers() & 0x400) != 0 || fieldType == Serializable.class ? !fieldType.isAssignableFrom(returnType) : !returnType.isAssignableFrom(fieldType)) {
                        throw new MappingException("mapping.accessorReturnTypeMismatch", method, fieldType.getName());
                    }
                }
            } else {
                Class<?> fieldTypePrimitive = null;
                if (fieldType != null) {
                    fieldTypePrimitive = Types.typeFromPrimitive(fieldType);
                    try {
                        method = javaClass.getMethod(methodName, fieldType);
                    }
                    catch (Exception ex) {
                        try {
                            method = javaClass.getMethod(methodName, fieldTypePrimitive);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
                if (method == null) {
                    Method[] methods = javaClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] paramTypes;
                        if (!methods[i].getName().equals(methodName) || (paramTypes = methods[i].getParameterTypes()).length != 1) continue;
                        Class<?> paramType = Types.typeFromPrimitive(paramTypes[0]);
                        if (fieldType == null) {
                            method = methods[i];
                            break;
                        }
                        if (paramType.isAssignableFrom(fieldTypePrimitive)) {
                            method = methods[i];
                            break;
                        }
                        if (!fieldType.isInterface() && !AbstractMappingLoader.isAbstract(fieldType) || !fieldTypePrimitive.isAssignableFrom(paramType)) continue;
                        method = methods[i];
                        break;
                    }
                    if (method == null) {
                        return null;
                    }
                }
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", methodName, javaClass.getName());
            }
            return method;
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static final String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    public static final String[] getIdentityColumnNames(String[] ids, ClassMapping clsMap) {
        String[] idNames = ids;
        if (ids == null || ids.length == 0) {
            ClassChoice classChoice = clsMap.getClassChoice();
            if (classChoice == null) {
                classChoice = new ClassChoice();
            }
            FieldMapping[] fieldMappings = classChoice.getFieldMapping();
            ArrayList<String> idNamesList = new ArrayList<String>();
            for (FieldMapping fieldMapping : fieldMappings) {
                if (!fieldMapping.getIdentity()) continue;
                idNamesList.add(fieldMapping.getName());
            }
            if (!idNamesList.isEmpty()) {
                idNames = new String[idNamesList.size()];
                idNames = idNamesList.toArray(idNames);
            }
        }
        return idNames;
    }

    protected static final boolean isPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == Boolean.class || type == Character.class) {
            return true;
        }
        return type.getSuperclass() == Number.class;
    }

    public void setInternalContext(InternalContext internalContext) {
        this._internalContext = internalContext;
    }

    public InternalContext getInternalContext() {
        return this._internalContext;
    }

    public class TypeInfoReference {
        public TypeInfo typeInfo = null;
    }
}

