/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util.resolvers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.util.resolvers.AbstractResolverPackageCommand;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class ByCDR
extends AbstractResolverPackageCommand {
    private static final Log LOG = LogFactory.getLog(ByCDR.class);
    private ArrayList _loadedPackages = new ArrayList();

    private Properties getProperties(URL url) throws IOException {
        Properties cdrList = new Properties();
        InputStream stream = url.openStream();
        cdrList.load(stream);
        stream.close();
        return cdrList;
    }

    protected Map internalResolve(String packageName, ClassLoader classLoader, Map properties) throws ResolverException {
        URL url;
        HashMap results = new HashMap();
        if (!this.isEmptyPackageName(packageName) && this._loadedPackages.contains(packageName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Package: " + packageName + " has already been loaded."));
            }
            return results;
        }
        if (!this.isEmptyPackageName(packageName)) {
            this._loadedPackages.add(packageName);
        }
        if ((url = classLoader.getResource(ResolveHelpers.getQualifiedFileName(".castor.cdr", packageName))) == null) {
            return results;
        }
        try {
            Properties cdrList = this.getProperties(url);
            Enumeration<Object> classes = cdrList.keys();
            while (classes.hasMoreElements()) {
                String clazzName = (String)classes.nextElement();
                String descriptorClassName = (String)cdrList.get(clazzName);
                try {
                    Class<?> descriptorClass = classLoader.loadClass(descriptorClassName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found descriptor: " + descriptorClass));
                    }
                    if (descriptorClass != null) {
                        results.put(clazzName, descriptorClass.newInstance());
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Loading of descriptor class: " + descriptorClassName + " for class: " + clazzName + " has failed - continue without"));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Ignored problem at loading of: " + descriptorClassName + " with exception: " + e));
                }
            }
        }
        catch (IOException iox) {
            String message = "Failed to load package: " + packageName + " with exception: " + iox;
            LOG.warn((Object)message);
            throw new ResolverException(message);
        }
        return results;
    }
}

