/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.math.BigDecimal;
import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;

public class Facet
extends Annotated {
    private static final long serialVersionUID = 7821829275720939922L;
    public static final String ENUMERATION = "enumeration";
    public static final String LENGTH = "length";
    public static final String PATTERN = "pattern";
    public static final String PRECISION = "precision";
    public static final String MAX_EXCLUSIVE = "maxExclusive";
    public static final String MAX_INCLUSIVE = "maxInclusive";
    public static final String MIN_EXCLUSIVE = "minExclusive";
    public static final String MIN_INCLUSIVE = "minInclusive";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MIN_LENGTH = "minLength";
    public static final String WHITESPACE = "whiteSpace";
    public static final String TOTALDIGITS = "totalDigits";
    public static final String FRACTIONDIGITS = "fractionDigits";
    public static final String WHITESPACE_PRESERVE = "preserve";
    public static final String WHITESPACE_REPLACE = "replace";
    public static final String WHITESPACE_COLLAPSE = "collapse";
    private static final String CLASSNAME = Facet.class.getName();
    private static final String NULL_ARGUMENT = "A null argument was passed to " + CLASSNAME + "#";
    private static final String ZERO_LENGTH_STRING = "A zero-length String was passed to " + CLASSNAME + "#";
    private final String _name;
    private final String _value;
    private SimpleType _owningType;

    public Facet(String name, String value) {
        if (name == null) {
            String err = NULL_ARGUMENT;
            err = err + "Facet: 'name' and 'value' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (name.length() == 0) {
            String err = ZERO_LENGTH_STRING;
            err = err + "Facet: 'name' and 'value' must not be zero-length.";
            throw new IllegalArgumentException(err);
        }
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isMultivalued() {
        return this._name.equals(ENUMERATION) || this._name.equals(PATTERN);
    }

    public int toInt() throws NumberFormatException {
        return Integer.parseInt(this._value);
    }

    public long toLong() throws NumberFormatException {
        return Long.parseLong(this._value);
    }

    public short toShort() throws NumberFormatException {
        return Short.parseShort(this._value);
    }

    public float toFloat() throws NumberFormatException {
        if (this._value.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (this._value.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.valueOf(this._value).floatValue();
    }

    public double toDouble() throws NumberFormatException {
        return Double.parseDouble(this._value);
    }

    public byte toByte() throws NumberFormatException {
        return Byte.parseByte(this._value);
    }

    public BigDecimal toBigDecimal() throws NumberFormatException {
        return new BigDecimal(this._value);
    }

    @Override
    public short getStructureType() {
        return 9;
    }

    @Override
    public void validate() throws ValidationException {
    }

    public boolean overridesBase(Facet baseFacet) {
        return this.getName().equals(baseFacet.getName());
    }

    public void checkConstraints(Enumeration localFacets, Enumeration baseFacets) throws SchemaException {
    }

    public void setOwningType(SimpleType owningType) {
        this._owningType = owningType;
    }

    public SimpleType getOwningType() {
        return this._owningType;
    }
}

