/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.RedefineSchema;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaLocation;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class RedefineUnmarshaller
extends ComponentReader {
    private ComponentReader _unmarshaller;
    private int _depth = 0;
    private Schema _schema;
    private Schema _importedSchema;
    private RedefineSchema _redefineSchema;

    public RedefineUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts, URIResolver uriResolver, Locator locator, SchemaUnmarshallerState state) throws XMLException {
        super(schemaContext);
        if (schema == null) {
            String err = "redefine must be used with an existing parent XML Schema.";
            throw new SchemaException(err);
        }
        this.setURIResolver(uriResolver);
        URILocation uri = null;
        String schemaLocation = atts.getValue("schemaLocation");
        this._schema = schema;
        if (schemaLocation == null) {
            this._redefineSchema = new RedefineSchema(schema);
            this._schema.addRedefineSchema(this._redefineSchema);
            return;
        }
        if (schemaLocation.indexOf("\\") != -1) {
            String err = "'" + schemaLocation + "' is not a valid URI as defined by IETF RFC 2396.";
            err = err + "The URI mustn't contain '\\'.";
            this.error(err);
        }
        try {
            String documentBase = locator.getSystemId();
            if (documentBase != null && !documentBase.endsWith("/")) {
                documentBase = documentBase.substring(0, documentBase.lastIndexOf(47) + 1);
            }
            if ((uri = this.getURIResolver().resolve(schemaLocation, documentBase)) != null) {
                schemaLocation = uri.getAbsoluteURI();
            }
        }
        catch (URIException urix) {
            throw new XMLException((Throwable)urix);
        }
        boolean addSchema = false;
        this._redefineSchema = schema.getRedefineSchema(schemaLocation);
        Schema importedSchema = null;
        boolean alreadyLoaded = false;
        if (this._redefineSchema == null) {
            if (uri instanceof SchemaLocation) {
                importedSchema = ((SchemaLocation)uri).getSchema();
                this._redefineSchema = new RedefineSchema(schema, importedSchema);
                schema.addRedefineSchema(this._redefineSchema);
                alreadyLoaded = true;
            } else {
                importedSchema = new Schema();
                addSchema = true;
            }
        } else {
            String tmpLocation = this._redefineSchema.getOriginalSchema().getSchemaLocation();
            alreadyLoaded = schemaLocation.equals(tmpLocation);
        }
        state.markAsProcessed(schemaLocation, importedSchema);
        if (alreadyLoaded) {
            return;
        }
        Parser parser = null;
        try {
            parser = this.getSchemaContext().getParser();
        }
        catch (RuntimeException rte) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for import");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(this.getSchemaContext(), state);
        schemaUnmarshaller.setURIResolver(this.getURIResolver());
        schemaUnmarshaller.setSchema(importedSchema);
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            InputSource source = new InputSource(uri.getReader());
            source.setSystemId(uri.getAbsoluteURI());
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SchemaException("Error reading import file '" + schemaLocation + "': " + ioe);
        }
        catch (SAXException sx) {
            throw new SchemaException(sx);
        }
        String namespace = importedSchema.getTargetNamespace();
        if (namespace != null) {
            if (!namespace.equals(schema.getTargetNamespace())) {
                String err = "The 'namespace' attribute in the <redefine> element must be the same of the targetNamespace of the global schema.\n" + namespace + " is different from:" + schema.getTargetNamespace();
                this.error(err);
            }
        } else {
            importedSchema.setTargetNamespace(schema.getTargetNamespace());
        }
        this._importedSchema = importedSchema;
        this._redefineSchema = new RedefineSchema(schema, this._importedSchema);
        if (addSchema) {
            importedSchema.setSchemaLocation(schemaLocation);
            this._schema.addRedefineSchema(this._redefineSchema);
        }
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this._unmarshaller != null) {
            try {
                this._unmarshaller.startElement(name, namespace, atts, nsDecls);
                ++this._depth;
                return;
            }
            catch (RuntimeException rtx) {
                this.error(rtx);
            }
        }
        if (name.equals("annotation")) {
            this._unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if (name.equals("attributeGroup")) {
            this._unmarshaller = new AttributeGroupUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (name.equals("complexType")) {
            this._unmarshaller = new ComplexTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (name.equals("simpleType")) {
            this._unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (name.equals("group")) {
            this._unmarshaller = new ModelGroupUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else {
            String err = "<" + name + "> elements cannot be used in a redefine.";
            this.error(err);
        }
        this._unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        Annotated group;
        String err;
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(name, namespace);
            --this._depth;
            return;
        }
        name = name.intern();
        if (this._unmarshaller != null) {
            if (!name.equals(this._unmarshaller.elementName())) {
                err = "error: missing end element for ";
                err = err + this._unmarshaller.elementName();
                this.error(err);
            }
        } else {
            String err2 = "error: missing start element for " + name;
            throw new SchemaException(err2);
        }
        this._unmarshaller.finish();
        if (name.equals("annotation")) {
            this._redefineSchema.addAnnotation((Annotation)this._unmarshaller.getObject());
        } else if (name.equals("attributeGroup")) {
            AttributeGroup original;
            if (this._redefineSchema.getSchemaLocation() == "") {
                err = "In a <redefine>, only annotations can be defined when no -schemaLocation- is specified.";
                this.error(err);
            }
            group = null;
            group = (AttributeGroupDecl)((AttributeGroupUnmarshaller)this._unmarshaller).getAttributeGroup();
            String structureName = ((AttributeGroupDecl)group).getName();
            if (structureName == null) {
                String err3 = "When redefining an AttributeGroup, the group must have a name.\n";
                this.error(err3);
            }
            if ((original = this._importedSchema.getAttributeGroup(structureName)) == null) {
                String err4 = "When redefining an AttributeGroup, the AttributeGroup must be present in the imported XML schema.\nAttributeGroup: " + structureName + " is not defined in XML Schema:" + this._importedSchema.getSchemaLocation();
                this.error(err4);
            }
            ((AttributeGroupDecl)group).setRedefined();
            this._redefineSchema.addAttributeGroup((AttributeGroupDecl)group);
        } else if (name.equals("complexType")) {
            XMLType baseType;
            ComplexType original;
            if (this._redefineSchema.getSchemaLocation() == "") {
                err = "In a <redefine>, only annotations can be defined when no -schemaLocation- is specified.";
                this.error(err);
            }
            ComplexType complexType = null;
            complexType = ((ComplexTypeUnmarshaller)this._unmarshaller).getComplexType();
            String structureName = complexType.getName();
            if (structureName == null) {
                String err5 = "When redefining a complexType, the complexType must have a name.\n";
                this.error(err5);
            }
            if ((original = this._importedSchema.getComplexType(structureName)) == null) {
                String err6 = "When redefining a complexType, the complexType must be present in the imported XML schema.\nComplexType: " + structureName + " is not defined in XML Schema:" + this._importedSchema.getSchemaLocation();
                this.error(err6);
            }
            if ((baseType = complexType.getBaseType()) == null || !baseType.getName().equals(structureName)) {
                String err7 = "When redefining a complexType, the complexType must use itself as the base type definition.\nComplexType: " + structureName + " uses:" + baseType + " as its base type.";
                this.error(err7);
            }
            complexType.setRedefined();
            this._redefineSchema.addComplexType(complexType);
            this.getResolver().addResolvable(complexType.getReferenceId(), complexType);
        } else if (name.equals("simpleType")) {
            XMLType baseType;
            SimpleType original;
            if (this._redefineSchema.getSchemaLocation() == "") {
                err = "In a <redefine>, only annotations can be defined when no -schemaLocation- is specified.";
                this.error(err);
            }
            SimpleType simpleType = null;
            simpleType = ((SimpleTypeUnmarshaller)this._unmarshaller).getSimpleType();
            String structureName = simpleType.getName();
            if (structureName == null) {
                String err8 = "When redefining a simpleType, the simpleType must have a name.\n";
                this.error(err8);
            }
            if ((original = this._importedSchema.getSimpleType(structureName, this._schema.getTargetNamespace())) == null) {
                String err9 = "When redefining a simpleType, the simpleType must be present in the imported XML schema.\nSimpleType: " + structureName + " is not defined in XML Schema:" + this._importedSchema.getSchemaLocation();
                this.error(err9);
            }
            if (!(baseType = simpleType.getBaseType()).getName().equals(structureName)) {
                String err10 = "When redefining a simpleType, the simpleType must use itself as the base type definition.\nSimpleType: " + structureName + " uses:" + baseType.getName() + " as its base type.";
                this.error(err10);
            }
            simpleType.setRedefined();
            this._redefineSchema.addSimpleType(simpleType);
            this.getResolver().addResolvable(simpleType.getReferenceId(), simpleType);
        } else if (name.equals("group")) {
            ModelGroup original;
            if (this._redefineSchema.getSchemaLocation() == "") {
                err = "In a <redefine>, only annotations can be defined when no -schemaLocation- is specified.";
                this.error(err);
            }
            group = null;
            group = ((ModelGroupUnmarshaller)this._unmarshaller).getGroup();
            String structureName = ((ModelGroup)group).getName();
            if (structureName == null) {
                String err11 = "When redefining a group, the group must have a name.\n";
                this.error(err11);
            }
            if ((original = this._importedSchema.getModelGroup(structureName)) == null) {
                String err12 = "When redefining a group, the group must be present in the imported XML schema.\nGroup: " + structureName + " is not defined in XML Schema:" + this._importedSchema.getSchemaLocation();
                this.error(err12);
            }
            ((ModelGroup)group).setRedefined();
            this._redefineSchema.addGroup((ModelGroup)group);
        } else {
            err = "In a <redefine>, only complexTypes|simpleTypes|groups or attributeGroups can be redefined.";
            this.error(err);
        }
        this._unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(ch, start, length);
        }
    }

    public String elementName() {
        return "redefine";
    }

    public Object getObject() {
        return this._redefineSchema;
    }
}

