/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaContextImpl;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaReader {
    private static final Log LOG = LogFactory.getLog(SchemaReader.class);
    private SchemaContext _schemaContext;
    private Parser _parser = null;
    private InputSource _source = null;
    private EntityResolver _resolver = null;
    private ErrorHandler _errorHandler = null;
    private URIResolver _uriResolver;
    private boolean _cacheIncludedSchemas = false;
    private Schema _schema = null;
    private boolean _validate = true;

    private void init() throws IOException {
        this._schemaContext = new SchemaContextImpl();
        Parser parser = this._schemaContext.getParser();
        if (parser == null) {
            String message = "fatal error: unable to create SAX parser.";
            LOG.warn((Object)message);
            throw new IOException(message);
        }
        this._parser = parser;
    }

    public SchemaReader(InputSource source) throws IOException {
        this.init();
        if (source == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this._source = source;
    }

    public SchemaReader(Reader reader, String filename) throws IOException {
        this.init();
        if (reader == null) {
            String err = "The argument 'reader' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._source = new InputSource(reader);
        if (filename == null) {
            filename = reader.toString();
        }
        this._source.setPublicId(filename);
    }

    public SchemaReader(String url) throws IOException {
        this.init();
        if (url == null) {
            String err = "The argument 'url' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._source = new InputSource(url);
    }

    public SchemaReader() {
    }

    public void setSchemaContext(SchemaContext schemaContext) {
        this._schemaContext = schemaContext;
        Parser p = this._schemaContext.getParser();
        if (p != null) {
            this._parser = p;
        }
    }

    public void setInputSource(InputSource inputSource) {
        if (inputSource == null) {
            String message = "InputSource must not be null";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        this._source = inputSource;
    }

    public Schema read() throws IOException {
        if (this._schema != null) {
            return this._schema;
        }
        if (this._parser == null) {
            String message = "Required Parser was not specified";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        if (this._source == null) {
            String message = "Required Source was not specified";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            String uri;
            SchemaUnmarshallerState state = new SchemaUnmarshallerState();
            state.cacheIncludedSchemas = this._cacheIncludedSchemas;
            schemaUnmarshaller = new SchemaUnmarshaller(this._schemaContext, state);
            if (this._uriResolver != null) {
                schemaUnmarshaller.setURIResolver(this._uriResolver);
            }
            if ((uri = this._source.getSystemId()) != null) {
                URIResolver resolver = schemaUnmarshaller.getURIResolver();
                try {
                    URILocation location = resolver.resolve(uri, null);
                    if (location != null) {
                        uri = location.toString();
                    }
                }
                catch (URIException except) {
                    throw new NestedIOException((Exception)((Object)except));
                }
                state.markAsProcessed(uri, schemaUnmarshaller.getSchema());
            }
            Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
            this._parser.setDocumentHandler(handler);
            if (this._errorHandler == null) {
                this._parser.setErrorHandler(handler);
            } else {
                this._parser.setErrorHandler(this._errorHandler);
            }
            if (this._resolver != null) {
                this._parser.setEntityResolver(this._resolver);
            }
            this._parser.parse(this._source);
        }
        catch (XMLException ex) {
            this.handleException(ex);
        }
        catch (SAXException sx) {
            this.handleException(sx);
        }
        this._schema = schemaUnmarshaller.getSchema();
        if (this._validate) {
            try {
                this._schema.validate();
            }
            catch (ValidationException vx) {
                throw new NestedIOException((Exception)((Object)vx));
            }
        }
        return this._schema;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setCacheIncludedSchemas(boolean cache) {
        this._cacheIncludedSchemas = cache;
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._resolver = resolver;
    }

    public void setURIResolver(URIResolver uriresolver) {
        this._uriResolver = uriresolver;
    }

    private void handleException(XMLException xmlException) throws IOException {
        throw new NestedIOException((Exception)((Object)xmlException));
    }

    private void handleException(SAXException sx) throws IOException {
        Exception except = sx.getException();
        if (except == null) {
            except = sx;
        } else {
            if (except instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)except;
                String filename = spe.getSystemId();
                if (filename == null) {
                    filename = spe.getPublicId();
                }
                if (filename == null) {
                    filename = "<filename unavailable>";
                }
                String err = spe.getMessage();
                err = err + "; " + filename + " [ line: " + spe.getLineNumber();
                err = err + ", column: " + spe.getColumnNumber() + ']';
                throw new NestedIOException(err, except);
            }
            if (except instanceof XMLException) {
                this.handleException((XMLException)((Object)except));
            }
        }
        throw new NestedIOException(except);
    }
}

