/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetList;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.simpletypes.UrType;

public class SimpleTypeDefinition {
    private String _name = null;
    private String _id = null;
    private String _final = null;
    private Schema _schema = null;
    private SimpleType _baseType = null;
    private String _baseTypeName = null;
    private Annotation _annotation = null;
    private FacetList _facets = null;

    public SimpleTypeDefinition(Schema schema, String name, String id) {
        this._schema = schema;
        this._name = name;
        this._id = id;
        this._facets = new FacetList();
    }

    public void addFacet(Facet facet) {
        this._facets.add(facet);
    }

    void copyInto(SimpleType simpleType) {
        simpleType.setName(this._name);
        simpleType.setSchema(this._schema);
        simpleType.setId(this._id);
        simpleType.setFinal(this._final);
        Enumeration enumeration = this._facets.enumerate();
        while (enumeration.hasMoreElements()) {
            simpleType.addFacet((Facet)enumeration.nextElement());
        }
        if (this._annotation != null) {
            simpleType.addAnnotation(this._annotation);
        }
    }

    public SimpleType createSimpleType() {
        SimpleType simpleType = null;
        simpleType = this._baseType != null ? this._schema.createSimpleType(this._name, this._baseType) : (this._baseTypeName != null ? this._schema.createSimpleType(this._name, this._baseTypeName, "restriction") : new UrType());
        simpleType.setId(this._id);
        simpleType.setFinal(this._final);
        Enumeration enumeration = this._facets.enumerate();
        while (enumeration.hasMoreElements()) {
            simpleType.addFacet((Facet)enumeration.nextElement());
        }
        if (this._annotation != null) {
            simpleType.addAnnotation(this._annotation);
        }
        return simpleType;
    }

    Schema getSchema() {
        return this._schema;
    }

    void setAnnotation(Annotation annotation) {
        this._annotation = annotation;
    }

    public void setBaseType(SimpleType baseType) {
        this._baseType = baseType;
        this._baseTypeName = null;
    }

    void setBaseTypeName(String baseTypeName) {
        this._baseTypeName = baseTypeName;
        this._baseType = null;
    }

    public void setFinal(String finalValue) {
        this._final = finalValue;
    }
}

