/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xmlctf.xmldiff.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.xmlctf.xmldiff.xml.XMLContentHandler;
import org.castor.xmlctf.xmldiff.xml.nodes.Root;
import org.castor.xmlctf.xmldiff.xml.nodes.XMLNode;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.util.XMLParserUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLFileReader {
    private static final Log LOG = LogFactory.getLog(XMLFileReader.class);
    private final File _file;
    private final String _location;
    private XMLReader _parser;

    public XMLFileReader(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("You must give a non-null fliename");
        }
        this._file = new File(filename);
        if (!this._file.exists()) {
            throw new IllegalArgumentException("File '" + filename + "' does not exist");
        }
        this._location = this.getUrlFromFile();
        SAXParser saxParser = XMLParserUtils.getSAXParser((boolean)false, (boolean)true);
        try {
            this._parser = saxParser.getXMLReader();
        }
        catch (SAXException sx) {
            LOG.error((Object)Messages.format((String)"conf.configurationError", (Object)sx));
        }
        if (this._parser == null) {
            this._parser = XMLParserUtils.instantiateXMLReader((String)"org.apache.xerces.parsers.SAXParser");
        }
    }

    public XMLNode read() throws IOException {
        Root node = null;
        try {
            InputSource source = new InputSource();
            source.setSystemId(this._location);
            source.setCharacterStream(new FileReader(this._file));
            XMLContentHandler builder = new XMLContentHandler();
            this._parser.setContentHandler(builder);
            this._parser.parse(source);
            node = builder.getRoot();
        }
        catch (SAXException sx) {
            Exception nested = sx.getException();
            SAXParseException sxp = null;
            if (sx instanceof SAXParseException) {
                sxp = (SAXParseException)sx;
            } else if (nested != null && nested instanceof SAXParseException) {
                sxp = (SAXParseException)nested;
            } else {
                throw new NestedIOException((Exception)sx);
            }
            String err = sxp.toString() + "\n - " + sxp.getSystemId() + "; line: " + sxp.getLineNumber() + ", column: " + sxp.getColumnNumber();
            throw new NestedIOException(err, (Exception)sx);
        }
        Root root = node;
        return root;
    }

    private String getUrlFromFile() {
        try {
            return this._file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

