/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xmlctf.xmldiff.xml.nodes;

import java.util.Iterator;
import org.castor.xmlctf.xmldiff.xml.Location;
import org.castor.xmlctf.xmldiff.xml.nodes.Element;
import org.castor.xmlctf.xmldiff.xml.nodes.ParentNode;

public abstract class XMLNode {
    public static final int ROOT = 1;
    public static final int ELEMENT = 2;
    public static final int ATTRIBUTE = 3;
    public static final int TEXT = 4;
    public static final int PROCESSING_INSTRUCTION = 5;
    private final String _localName;
    private final int _nodeType;
    private ParentNode _parent = null;
    private String _namespace = null;

    XMLNode(String namespace, String localName, int nodeType) {
        this._namespace = namespace;
        this._localName = localName;
        this._nodeType = nodeType;
    }

    public final int getNodeType() {
        return this._nodeType;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespaceURI() {
        return this._namespace;
    }

    public ParentNode getParentNode() {
        return this._parent;
    }

    public XMLNode getRootNode() {
        return this._parent != null ? this._parent.getRootNode() : null;
    }

    public abstract String getStringValue();

    public String getNamespaceURI(String prefix) {
        return this._parent != null ? this._parent.getNamespaceURI(prefix) : null;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    void setParent(ParentNode node) {
        this._parent = node;
    }

    public String getNodeLocation() {
        Location loc;
        int column = -1;
        int line = -1;
        String xpath = "XPATH: " + this.getXPath();
        if (this instanceof Element && (loc = ((Element)this).getLocation()) != null) {
            line = loc.getLineNumber();
            column = loc.getColumnNumber();
        }
        String location = null;
        location = line >= 0 ? "[" + line + ", " + column + "] " + xpath : xpath;
        return location;
    }

    protected String getXPath() {
        StringBuffer xpath = new StringBuffer();
        switch (this.getNodeType()) {
            case 3: {
                xpath.append(this.getParentNode().getXPath() + "/@" + this.getLocalName());
                break;
            }
            case 2: {
                boolean usePosition;
                XMLNode sibling;
                String name = this.getLocalName();
                xpath.append(this.getParentNode().getXPath() + "/" + name);
                int position = 1;
                Iterator i = this.getParentNode().getChildIterator();
                while (i.hasNext() && (sibling = (XMLNode)i.next()) != this) {
                    if (!name.equals(sibling.getLocalName())) continue;
                    ++position;
                }
                boolean bl = usePosition = position > 1;
                if (!usePosition) {
                    while (i.hasNext()) {
                        XMLNode sibling2 = (XMLNode)i.next();
                        if (!name.equals(sibling2.getLocalName())) continue;
                        usePosition = true;
                        break;
                    }
                }
                if (!usePosition) break;
                xpath.append("[" + position + "]");
                break;
            }
            case 4: {
                xpath.append(this.getParentNode().getXPath() + "/text()");
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                xpath.append(this.getParentNode().getXPath() + "/pi()");
                break;
            }
        }
        return xpath.toString();
    }
}

