/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xmlctf.xmldiff.xml.nodes;

import java.util.Iterator;
import java.util.LinkedList;
import org.castor.xmlctf.xmldiff.xml.Location;
import org.castor.xmlctf.xmldiff.xml.nodes.Attribute;
import org.castor.xmlctf.xmldiff.xml.nodes.Namespace;
import org.castor.xmlctf.xmldiff.xml.nodes.ParentNode;

public class Element
extends ParentNode {
    private static final long serialVersionUID = 7995110660306473483L;
    private final LinkedList _attributes = new LinkedList();
    private final LinkedList _namespaces = new LinkedList();
    private Location _location = null;

    public Element(String namespace, String localName) {
        super(namespace, localName, 2);
    }

    public Iterator getAttributeIterator() {
        return this._attributes.iterator();
    }

    public String getAttribute(String uri, String localName) {
        for (Attribute attr : this._attributes) {
            if (!this.namespacesEqual(uri, attr.getNamespaceURI()) || !attr.getLocalName().equals(localName)) continue;
            return attr.getStringValue();
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        String desiredPrefix = prefix == null ? "" : prefix;
        for (Namespace ns : this._namespaces) {
            if (!desiredPrefix.equals(ns.getPrefix())) continue;
            return ns.getNamespaceUri();
        }
        return super.getNamespaceURI(desiredPrefix);
    }

    public String getNamespacePrefix(String uri) {
        String desiredUri = uri == null ? "" : uri;
        for (Namespace ns : this._namespaces) {
            if (!desiredUri.equals(ns.getNamespaceUri())) continue;
            return ns.getPrefix();
        }
        ParentNode parent = this.getParentNode();
        if (parent != null && parent instanceof Element) {
            return ((Element)parent).getNamespacePrefix(desiredUri);
        }
        return null;
    }

    public void addAttribute(Attribute attr) {
        if (attr == null) {
            return;
        }
        attr.setParent(this);
        this._attributes.add(attr);
    }

    public void addNamespace(Namespace namespace) {
        if (namespace == null) {
            return;
        }
        this._namespaces.add(namespace);
    }

    private boolean namespacesEqual(String ns1, String ns2) {
        String namespace1 = ns1 == null ? "" : ns1;
        String namespace2 = ns2 == null ? "" : ns2;
        return namespace1.equals(namespace2);
    }

    public void setLocation(Location location) {
        this._location = location;
    }

    public Location getLocation() {
        return this._location;
    }
}

