/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.castor.maven.xmlctf;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.castor.xmlctf.TestCaseAggregator;

public abstract class AbstractTestSuiteMojo
extends AbstractMojo {
    private static final String TEST_ROOT_PROPERTY = "castor.xmlctf.root";
    @Parameter(property="outputRoot", defaultValue="./target/xmlctf")
    private String outputRoot;
    @Parameter(property="testRoot", defaultValue="${basedir}/tests/MasterTestSuite/")
    private String testRoot;
    @Parameter(property="pathToTools")
    private String pathToTools;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpathEntries;
        boolean skipMavenTests = Boolean.getBoolean("maven.test.skip");
        skipMavenTests |= Boolean.getBoolean("skipTests");
        if (skipMavenTests |= Boolean.getBoolean("skipITs")) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping XML CTF tests as per configuration.");
            }
            return;
        }
        this.getLog().info((CharSequence)"Starting Castor Mastertestsuite");
        this.getLog().info((CharSequence)("testRoot = " + this.testRoot));
        String testRootToUse = System.getProperty(TEST_ROOT_PROPERTY);
        if (testRootToUse == null) {
            testRootToUse = this.testRoot;
        }
        if (testRootToUse == null) {
            throw new MojoExecutionException("No testroot found, please specify property -Dcastor.xmlctf.root");
        }
        if (testRootToUse.equals(".") || testRootToUse.equals("..")) {
            File tmp = new File(testRootToUse);
            try {
                testRootToUse = tmp.getCanonicalPath();
            }
            catch (IOException iOException) {}
        } else if (testRootToUse.startsWith("./") || testRootToUse.startsWith(".\\")) {
            this.testRoot = this.testRoot.substring(2);
        }
        File testRootFile = new File(testRootToUse);
        this.getLog().info((CharSequence)("using testRoot: " + testRootFile.getAbsolutePath()));
        if (!testRootFile.exists()) {
            throw new MojoExecutionException("Root not found:" + this.testRoot);
        }
        String dirSeparator = System.getProperty("file.separator");
        StringBuilder classpath = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        Iterator iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            classpath.append(((Artifact)iter.next()).getFile().getAbsolutePath());
            classpath.append(pathSeparator);
        }
        classpath.append(this.project.getBuild().getTestOutputDirectory());
        classpath.append(pathSeparator);
        if (this.pathToTools != null) {
            this.getLog().info((CharSequence)"Usage of -DpathToTools !");
            classpath.append(this.pathToTools + pathSeparator + "tools.jar");
        } else {
            String javaHome = System.getProperty("java.home");
            classpath.append(javaHome);
            classpath.append(dirSeparator);
            classpath.append("lib");
            classpath.append(dirSeparator);
            classpath.append("tools.jar");
            classpath.append(pathSeparator);
            classpath.append(javaHome.substring(0, javaHome.lastIndexOf("/jre")) + dirSeparator + "lib" + dirSeparator + "tools.jar");
            classpath.append(pathSeparator);
        }
        System.setProperty("xmlctf.classpath.override", classpath.toString());
        if (this.getLog().isDebugEnabled()) {
            System.setProperty("org.exolab.castor.tests.Verbose", "true");
            System.setProperty("org.exolab.castor.tests.printStack", "true");
        }
        this.getLog().info((CharSequence)("classpath for sourcegenerator is: " + classpath));
        for (String classpathEntry : classpathEntries = StringUtils.split((String)classpath.toString(), (char)';')) {
            this.getLog().info((CharSequence)classpathEntry);
        }
        TestCaseAggregator aggregator = new TestCaseAggregator(testRootFile, this.outputRoot);
        this.runJUnit(aggregator.suite());
    }

    public abstract void runJUnit(Test var1) throws MojoExecutionException;
}

