/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.exolab.javasource.AbstractJField;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstant;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInnerClass;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public abstract class AbstractJClass
extends JStructure {
    private final JSourceCode _staticInitializer = new JSourceCode();
    private final Map<String, JField> _fields = new LinkedHashMap<String, JField>();
    private final Map<String, JConstant> _constants = new LinkedHashMap<String, JConstant>();
    private final Vector<JConstructor> _constructors = new Vector();
    private final Vector<JMethod> _methods = new Vector();
    private Vector<JClass> _innerClasses = null;
    private final Vector<String> _sourceCodeEntries = new Vector();

    public String[] getSourceCodeEntries() {
        return this._sourceCodeEntries.toArray(new String[this._sourceCodeEntries.size()]);
    }

    protected AbstractJClass(String name) {
        this(name, false);
    }

    protected AbstractJClass(String name, boolean useOldFieldNaming) {
        super(name);
        if (useOldFieldNaming) {
            this.getJDocComment().appendComment("Class " + this.getLocalName() + ".");
        }
    }

    public final JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    @Override
    public final JField getField(String name) {
        return this._fields.get(name);
    }

    public final JConstant getConstant(String name) {
        return this._constants.get(name);
    }

    @Override
    public final JField[] getFields() {
        return this._fields.values().toArray(new JField[this._fields.size()]);
    }

    public final JConstant[] getConstants() {
        return this._constants.values().toArray(new JConstant[this._constants.size()]);
    }

    public final int getFieldCount() {
        return this._fields.size();
    }

    public final int getConstantCount() {
        return this._constants.size();
    }

    @Override
    public final void addField(JField jField) {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jField.getName();
        if (this._fields.get(name) != null) {
            String nameToCompare = name.startsWith("_") ? name.substring(1) : name;
            if (JNaming.isReservedByCastor(nameToCompare = nameToCompare.substring(0, 1).toUpperCase() + nameToCompare.substring(1))) {
                String warn = "'" + nameToCompare + "' might conflict with a field name used" + " by Castor.  If you get a complaint\nabout a duplicate name, you will" + " need to use a mapping file or change the name\nof the conflicting" + " schema element.";
                System.out.println(warn);
            }
            String err = "Duplicate name found as a class member: " + name;
            throw new IllegalArgumentException(err);
        }
        this._fields.put(name, jField);
    }

    public final void addConstant(JConstant jConstant) {
        if (jConstant == null) {
            throw new IllegalArgumentException("Class constants cannot be null");
        }
        String name = jConstant.getName();
        if (this._constants.get(name) != null) {
            String nameToCompare = name.startsWith("_") ? name.substring(1) : name;
            if (JNaming.isReservedByCastor(nameToCompare = nameToCompare.substring(0, 1).toUpperCase() + nameToCompare.substring(1))) {
                String warn = "'" + nameToCompare + "' might conflict with a constant name used" + " by Castor.  If you get a complaint\nabout a duplicate name, you will" + " need to use a mapping file or change the name\nof the conflicting" + " schema element.";
                System.out.println(warn);
            }
            String err = "Duplicate name found as a class member: " + name;
            throw new IllegalArgumentException(err);
        }
        this._constants.put(name, jConstant);
    }

    public final JField removeField(String name) {
        if (name == null) {
            return null;
        }
        JField field = this._fields.remove(name);
        return field;
    }

    public final JConstant removeConstant(String name) {
        if (name == null) {
            return null;
        }
        JConstant constant = this._constants.remove(name);
        return constant;
    }

    public final boolean removeField(JField jField) {
        if (jField == null) {
            return false;
        }
        JField field = this._fields.get(jField.getName());
        if (field == jField) {
            this._fields.remove(jField.getName());
            return true;
        }
        return false;
    }

    public final boolean removeConstant(JConstant jConstant) {
        if (jConstant == null) {
            return false;
        }
        JConstant constant = this._constants.get(jConstant.getName());
        if (constant == jConstant) {
            this._constants.remove(jConstant.getName());
            return true;
        }
        return false;
    }

    public final JConstructor createConstructor() {
        return this.createConstructor(null);
    }

    public final JConstructor createConstructor(JParameter[] params) {
        JConstructor cons = new JConstructor(this);
        if (params != null) {
            for (JParameter param : params) {
                cons.addParameter(param);
            }
        }
        this.addConstructor(cons);
        return cons;
    }

    public final JConstructor getConstructor(int index) {
        return this._constructors.elementAt(index);
    }

    public final JConstructor[] getConstructors() {
        int size = this._constructors.size();
        JConstructor[] jcArray = new JConstructor[size];
        for (int i = 0; i < this._constructors.size(); ++i) {
            jcArray[i] = this._constructors.elementAt(i);
        }
        return jcArray;
    }

    public final int getContructorsCount() {
        return this._constructors.size();
    }

    public void addConstructor(JConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (constructor.getDeclaringClass() == this) {
            if (!this._constructors.contains(constructor)) {
                this._constructors.add(constructor);
            }
        } else {
            String err = "The given JConstructor was not created by this JClass";
            throw new IllegalArgumentException(err);
        }
    }

    public final boolean removeConstructor(JConstructor constructor) {
        return this._constructors.remove(constructor);
    }

    public final JMethod[] getMethods() {
        return this._methods.toArray(new JMethod[this._methods.size()]);
    }

    public final JMethod getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this._methods.size(); ++i) {
            JMethod jMethod = this._methods.elementAt(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public final JMethod getMethod(int index) {
        return this._methods.elementAt(index);
    }

    public final int getMethodCount() {
        return this._methods.size();
    }

    public final void addMethod(JMethod jMethod, boolean importReturnType) {
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean added = false;
        JModifiers modifiers = jMethod.getModifiers();
        if (modifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod tmp = this._methods.elementAt(i);
            if (tmp.getModifiers().isPrivate() && !modifiers.isPrivate()) {
                this._methods.insertElementAt(jMethod, i);
                added = true;
                break;
            }
            if (jMethod.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.insertElementAt(jMethod, i);
            added = true;
            break;
        }
        if (!added) {
            this._methods.add(jMethod);
        }
    }

    public final void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public final void addMethods(JMethod[] jMethods) {
        for (JMethod jMethod : jMethods) {
            this.addMethod(jMethod);
        }
    }

    public final boolean removeMethod(JMethod method) {
        return this._methods.remove(method);
    }

    public final JClass createInnerClass(String localname) {
        if (localname == null) {
            String err = "argument 'localname' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (localname.indexOf(46) >= 0) {
            String err = "The name of an inner-class must not contain a package name.";
            throw new IllegalArgumentException(err);
        }
        String classname = this.getPackageName();
        classname = classname != null ? classname + '.' + localname : localname;
        JInnerClass innerClass = new JInnerClass(classname);
        if (this._innerClasses == null) {
            this._innerClasses = new Vector();
        }
        this._innerClasses.add(innerClass);
        return innerClass;
    }

    public final JClass[] getInnerClasses() {
        return null != this._innerClasses ? this._innerClasses.toArray(new JClass[this._innerClasses.size()]) : new JClass[]{};
    }

    public final int getInnerClassCount() {
        return null != this._innerClasses ? this._innerClasses.size() : 0;
    }

    public final boolean removeInnerClass(JClass jClass) {
        return null != this._innerClasses ? this._innerClasses.remove(jClass) : false;
    }

    @Override
    public final void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public abstract void print(JSourceWriter var1, boolean var2);

    protected final void printClassHeaders(JSourceWriter jsw) {
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        ArrayList<String> removeImports = null;
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            removeImports = new ArrayList<String>();
            for (JClass iClass : this._innerClasses) {
                Enumeration<String> enumeration = iClass.getImports();
                while (enumeration.hasMoreElements()) {
                    String classname = enumeration.nextElement();
                    int paramTypeIndex = classname.indexOf("<Object>");
                    if (paramTypeIndex != -1) {
                        classname = classname.substring(0, paramTypeIndex - 1);
                    }
                    if (this.hasImport(classname)) continue;
                    this.addImport(classname);
                    removeImports.add(classname);
                }
            }
        }
        this.printImportDeclarations(jsw);
        if (removeImports != null) {
            for (String imp : removeImports) {
                this.removeImport(imp);
            }
        }
    }

    protected final void printConstantDefinitions(JSourceWriter jsw) {
        for (JConstant constant : this._constants.values()) {
            this.printAbstractJField(jsw, constant);
        }
    }

    private void printAbstractJField(JSourceWriter jsw, AbstractJField field) {
        JDocComment comment = field.getComment();
        if (comment != null && comment.getLength() > 0) {
            comment.print(jsw);
        }
        field.printAnnotations(jsw);
        jsw.write(field.getModifiers().toString());
        jsw.write(32);
        JType type = field.getType();
        String typeName = type.toString();
        if (typeName.equals(this.toString())) {
            typeName = type.getLocalName();
        }
        jsw.write(typeName);
        jsw.write(32);
        jsw.write(field.getName());
        String init = field.getInitString();
        if (init != null && !field.isDateTime()) {
            jsw.write(" = ");
            jsw.write(init);
        }
        jsw.writeln(';');
        jsw.writeln();
    }

    protected final void printMemberVariables(JSourceWriter jsw) {
        for (JField field : this._fields.values()) {
            this.printAbstractJField(jsw, field);
        }
    }

    protected final void printStaticInitializers(JSourceWriter jsw) {
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static {");
            jsw.writeln(this._staticInitializer.toString());
            jsw.writeln("}");
            jsw.writeln();
        }
    }

    protected final void printConstructors(JSourceWriter jsw) {
        for (JConstructor jConstructor : this._constructors) {
            jConstructor.print(jsw);
            jsw.writeln();
        }
    }

    protected final void printMethods(JSourceWriter jsw) {
        for (JMethod jMethod : this._methods) {
            jMethod.print(jsw);
            jsw.writeln();
        }
    }

    protected final void printSourceCodeFragments(JSourceWriter sourceWriter) {
        for (String sourceCode : this._sourceCodeEntries) {
            sourceWriter.writeln(sourceCode);
            sourceWriter.writeln();
        }
    }

    protected final void printInnerClasses(JSourceWriter jsw) {
        if (this._innerClasses != null && !this._innerClasses.isEmpty()) {
            for (JClass jClass : this._innerClasses) {
                jClass.print(jsw, true);
                jsw.writeln();
            }
        }
    }

    public void addSourceCode(String sourceCode) {
        this._sourceCodeEntries.add(sourceCode);
    }

    public final int getSourceCodeEntryCount() {
        return this._sourceCodeEntries.size();
    }
}

