/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.conflictresolution;

import java.util.Enumeration;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.conflictresolution.BaseClassNameCRStrategy;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategy;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.javasource.JClass;

public final class WarningViaDialogClassNameCRStrategy
extends BaseClassNameCRStrategy
implements ClassNameCRStrategy {
    public static final String NAME = "warnViaConsoleDialog";
    private ConsoleDialog _dialog;

    @Override
    public SGStateInfo dealWithClassNameConflict(SGStateInfo state, ClassInfo newClassInfo, JClass conflict) {
        if (!state.getSuppressNonFatalWarnings()) {
            XMLInfoNature xmlNature;
            ClassInfo oldClassInfo = state.resolve(conflict);
            if (oldClassInfo == newClassInfo) {
                return state;
            }
            Annotated a1 = null;
            Annotated a2 = null;
            Enumeration<?> enumeration = state.keys();
            while (enumeration.hasMoreElements() && (a1 == null || a2 == null)) {
                Object key = enumeration.nextElement();
                if (!(key instanceof Annotated)) continue;
                ClassInfo cInfo = state.resolve(key);
                if (newClassInfo == cInfo) {
                    a1 = (Annotated)key;
                    continue;
                }
                if (oldClassInfo != cInfo) continue;
                a2 = (Annotated)key;
            }
            StringBuilder error = new StringBuilder(64);
            error.append("Warning: A class name generation conflict has occured between ");
            if (a1 != null) {
                error.append(SchemaNames.getStructureName(a1));
                error.append(" '");
                error.append(XPathHelper.getSchemaLocation((Structure)a1));
            } else if (newClassInfo.hasNature(XMLInfoNature.class.getName())) {
                xmlNature = new XMLInfoNature(newClassInfo);
                error.append(xmlNature.getNodeTypeName());
                error.append(" '");
                error.append(xmlNature.getNodeName());
            }
            error.append("' and ");
            if (a2 != null) {
                error.append(SchemaNames.getStructureName((Structure)a2));
                error.append(" '");
                error.append(XPathHelper.getSchemaLocation((Structure)a2));
            } else if (oldClassInfo.hasNature(XMLInfoNature.class.getName())) {
                xmlNature = new XMLInfoNature(oldClassInfo);
                error.append(xmlNature.getNodeTypeName());
                error.append(" '");
                error.append(xmlNature.getNodeName());
            }
            error.append("'. Please use a Binding file to solve this problem.");
            error.append("Continue anyway [not recommended] ");
            char ch = this._dialog.confirm(error.toString(), "yn", "y = yes, n = no");
            if (ch == 'n') {
                state.setStatusCode(1);
            }
        }
        return state;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setConsoleDialog(ConsoleDialog dialog) {
        this._dialog = dialog;
    }

    @Override
    public boolean dealWithFileOverwrite(String filename) {
        boolean allowPrinting = true;
        String message = filename + " already exists. overwrite";
        char ch = this._dialog.confirm(message, "yna", "y = yes, n = no, a = all");
        switch (ch) {
            case 'a': {
                this.getSingleClassGenerator().setPromptForOverwrite(false);
                allowPrinting = true;
                break;
            }
            case 'y': {
                allowPrinting = true;
                break;
            }
            default: {
                allowPrinting = false;
            }
        }
        return allowPrinting;
    }

    protected ConsoleDialog getConsoleDialog() {
        return this._dialog;
    }
}

