/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.printing;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JEnum;

public class TemplateHelper {
    public String removeLineBreaks(String string) {
        return string.replaceAll("\n", "");
    }

    public ArrayList<String> getLines(String comment) {
        comment = this.removeLineBreaks(comment);
        ArrayList<String> list = new ArrayList<String>();
        while ((comment = this.computeLine(comment, list)).length() > 0) {
        }
        return list;
    }

    private String computeLine(String comment, ArrayList<String> list) {
        if (comment == null) {
            return "";
        }
        if (comment.length() <= 70) {
            list.add(comment);
            return "";
        }
        int pos = comment.indexOf(32, 70);
        if (pos == -1) {
            list.add(comment);
            return "";
        }
        String line = comment.substring(0, pos);
        list.add(line);
        return comment.substring(pos + 1);
    }

    public boolean isEnum(JClass jClass) {
        return jClass instanceof JEnum;
    }

    public String printAnnotation(JAnnotation annotation, String shift) {
        StringBuilder stringBuffer = new StringBuilder(32);
        stringBuffer.append(shift);
        stringBuffer.append("@");
        stringBuffer.append(annotation.getAnnotationType().getLocalName());
        stringBuffer.append("(");
        String[] elementNames = annotation.getElementNames();
        if (elementNames.length == 1 && elementNames[0].equals("value")) {
            stringBuffer.append(this.printAnnotationValue(annotation.getElementValueObject("value"), shift));
        } else if (elementNames.length > 0) {
            int elementNameLength;
            int i;
            int maxLength = 0;
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                if (elementNameLength <= maxLength) continue;
                maxLength = elementNameLength;
            }
            stringBuffer.append("\n");
            stringBuffer.append(shift + "    ");
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                stringBuffer.append(elementNames[i]);
                for (int p = 0; p < maxLength - elementNameLength; ++p) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(" = ");
                stringBuffer.append(this.printAnnotationValue(annotation.getElementValueObject(elementNames[i]), shift));
                if (i >= elementNames.length - 1) continue;
                stringBuffer.append(",");
                stringBuffer.append("\n");
                stringBuffer.append(shift + "    ");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String printAnnotationValue(Object elementValue, String shift) {
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        if (elementValue instanceof JAnnotation) {
            JAnnotation annotation = (JAnnotation)elementValue;
            return this.printAnnotation(annotation, shift);
        }
        if (elementValue.getClass().isArray()) {
            int listLength = Array.getLength(elementValue);
            if (listLength == 1) {
                return this.printAnnotationValue(Array.get(elementValue, 0), shift);
            }
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append("\n");
            stringBuffer.append("{");
            stringBuffer.append("\n");
            stringBuffer.append(shift);
            for (int i = 0; i < listLength; ++i) {
                stringBuffer.append(shift);
                stringBuffer.append(this.printAnnotationValue(Array.get(elementValue, i), shift));
                if (i < listLength - 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        throw new IllegalArgumentException("'" + elementValue + "' was not expected.");
    }
}

