/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.castor.core.util.StringUtil;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.factory.BaseFactory;
import org.exolab.castor.builder.factory.EnumerationFactory;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.builder.factory.MemberFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.GroupInfo;
import org.exolab.castor.builder.info.nature.JDOClassInfoNature;
import org.exolab.castor.builder.info.nature.JDOFieldInfoNature;
import org.exolab.castor.builder.info.nature.SolrjFieldInfoNature;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.info.nature.relation.JDOOneToManyNature;
import org.exolab.castor.builder.info.nature.relation.JDOOneToOneNature;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AppInfo;
import org.exolab.castor.xml.schema.AppInfoJpaNature;
import org.exolab.castor.xml.schema.AppInfoSolrjNature;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.annotations.jdo.Column;
import org.exolab.castor.xml.schema.annotations.jdo.OneToMany;
import org.exolab.castor.xml.schema.annotations.jdo.OneToOne;
import org.exolab.castor.xml.schema.annotations.jdo.PrimaryKey;
import org.exolab.castor.xml.schema.annotations.jdo.Table;
import org.exolab.castor.xml.schema.annotations.solrj.Field;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JCollectionType;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JEnum;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class SourceFactory
extends BaseFactory {
    private static final String ENUM_ACCESS_INTERFACE = "org.exolab.castor.types.EnumeratedTypeAccess";
    private static final short BASE_TYPE_ENUMERATION = 0;
    private static final short OBJECT_TYPE_ENUMERATION = 1;
    private static final String CLASS_METHOD_SUFFIX = "Class";
    private static final String CLASS_KEYWORD = "class";
    private static final String ITEM_NAME = "Item";
    private ExtendedBinding _binding = null;
    private MemberFactory _memberFactory = null;
    private short _enumerationType = 1;
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;
    private boolean _sax1 = false;
    private TypeConversion _typeConversion = null;
    private final EnumerationFactory _enumerationFactory;

    public SourceFactory(BuilderConfiguration config, FieldInfoFactory infoFactory, GroupNaming groupNaming, SourceGenerator sourceGenerator) {
        super(config, infoFactory, groupNaming, sourceGenerator);
        infoFactory.setBoundProperties(config.boundPropertiesEnabled());
        this._memberFactory = new MemberFactory(config, infoFactory, this.getGroupNaming(), sourceGenerator);
        this._typeConversion = new TypeConversion(this.getConfig());
        this._enumerationFactory = new EnumerationFactory(this.getConfig(), this.getGroupNaming(), sourceGenerator);
    }

    public void setCreateMarshalMethods(boolean createMarshalMethods) {
        this._createMarshalMethods = createMarshalMethods;
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this.getInfoFactory().setCreateExtraMethods(extraMethods);
    }

    public void setReferenceMethodSuffix(String suffix) {
        this.getInfoFactory().setReferenceMethodSuffix(suffix);
    }

    public void setTestable(boolean testable) {
        this._testable = testable;
    }

    public void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._enumerationFactory.setCaseInsensitive(caseInsensitive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JClass[] createSourceCode(XMLBindingComponent component, SGStateInfo sgState) {
        JDOClassInfoNature jdoNature;
        String[] implemented;
        boolean createGroupItem;
        String className;
        String packageName;
        if (component == null) {
            throw new IllegalStateException("XMLBindingComponent may not be null.");
        }
        if (sgState == null) {
            throw new IllegalStateException("SGStateInfo may not be null.");
        }
        JClass[] classes = sgState.getSourceCode(component.getAnnotated());
        if (classes != null) {
            return classes;
        }
        this._binding = component.getBinding();
        if (sgState.verbose()) {
            String name = component.getXMLName();
            if (name == null) {
                name = component.getJavaClassName();
            }
            String msg = "Creating classes for: " + name;
            sgState.getDialog().notify(msg);
        }
        if ((packageName = component.getJavaPackage()) == null || packageName.length() == 0) {
            packageName = sgState.getPackageName();
        }
        if ((className = component.getQualifiedName()).indexOf(46) == -1) {
            className = this.getJavaNaming().toJavaClassName(className);
            className = this.resolveClassName(className, packageName);
        }
        if (createGroupItem = component.createGroupItem()) {
            className = String.valueOf(className) + ITEM_NAME;
            classes = new JClass[2];
        } else {
            classes = new JClass[1];
        }
        FactoryState state = new FactoryState(className, sgState, packageName, component);
        state.setCreateGroupItem(createGroupItem);
        if (sgState.getCurrentFactoryState() != null) {
            state.setParent(sgState.getCurrentFactoryState());
        }
        sgState.setCurrentFactoryState(state);
        if (state.processed(component.getAnnotated())) {
            return new JClass[0];
        }
        state.markAsProcessed(component.getAnnotated());
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        this.initialize(jClass);
        if (classInfo.hasNature(XMLInfoNature.class.getName())) {
            ElementDecl elementDeclaration;
            Enumeration possibleSubstitutes;
            XMLInfoNature xmlNature = new XMLInfoNature(classInfo);
            xmlNature.setNodeName(component.getXMLName());
            xmlNature.setNamespaceURI(component.getTargetNamespace());
            XMLType type = component.getXMLType();
            boolean createForSingleGroup = false;
            boolean creatingForAnElement = component.getAnnotated().getStructureType() == 8;
            xmlNature.setElementDefinition(creatingForAnElement);
            if (creatingForAnElement && (possibleSubstitutes = (elementDeclaration = (ElementDecl)component.getAnnotated()).getSubstitutionGroupMembers()).hasMoreElements()) {
                ArrayList<String> substitutionGroupMembers = new ArrayList<String>();
                while (possibleSubstitutes.hasMoreElements()) {
                    ElementDecl substitute = (ElementDecl)possibleSubstitutes.nextElement();
                    substitutionGroupMembers.add(substitute.getName());
                }
                xmlNature.setSubstitutionGroups(substitutionGroupMembers);
            }
            if (type != null) {
                if (type.isComplexType()) {
                    this.processComplexType(component, sgState, state);
                } else if (type.isSimpleType()) {
                    SimpleType simpleType = (SimpleType)type;
                    if (!simpleType.hasFacet("enumeration")) return new JClass[0];
                    this.processSimpleTypeEnumeration(component, sgState, classInfo, simpleType);
                } else if (type.isAnyType()) {
                    xmlNature.setSchemaType(new XSClass(SGTypes.OBJECT));
                    return new JClass[0];
                }
            } else {
                createForSingleGroup = this.processSchemaGroup(component, state, classInfo);
            }
            if (createGroupItem) {
                ComplexType complexType;
                if (component.hasBoundProperties()) {
                    this.createPropertyChangeMethods(jClass);
                }
                sgState.bindReference(jClass, classInfo);
                classes[1] = jClass;
                String fname = String.valueOf(component.getJavaClassName()) + ITEM_NAME;
                fname = this.getJavaNaming().toJavaMemberName(fname, false);
                FieldInfo fInfo = null;
                fInfo = createForSingleGroup ? this.getInfoFactory().createFieldInfo(new XSClass(jClass), fname) : this.getInfoFactory().createCollection(new XSClass(jClass), "_items", fname, this.getJavaNaming(), this.getConfig().useJava50());
                fInfo.setContainer(true);
                String newClassName = className.substring(0, className.length() - 4);
                state = new FactoryState(newClassName, sgState, packageName, component);
                classInfo = state.getClassInfo();
                jClass = state.getJClass();
                this.initialize(jClass);
                if (type != null && type.isComplexType() && (complexType = (ComplexType)type).isTopLevel() ^ creatingForAnElement) {
                    Annotated saved = component.getAnnotated();
                    this.processAttributes(component.getBinding(), complexType, state);
                    component.setView(saved);
                    if (complexType.getContentType() == ContentType.mixed) {
                        FieldInfo fieldInfo = this._memberFactory.createFieldInfoForContent(component, new XSString(), this.getConfig().useJava50());
                        this.handleField(fieldInfo, state, component);
                    } else if (complexType.getContentType().getType() == 4) {
                        SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                        SimpleType temp = simpleContent.getSimpleType();
                        XSType xsType = this._typeConversion.convertType(temp, packageName, this.getConfig().useJava50());
                        FieldInfo fieldInfo = this._memberFactory.createFieldInfoForContent(component, xsType, this.getConfig().useJava50());
                        this.handleField(fieldInfo, state, component);
                        temp = null;
                    } else {
                        xmlNature.setSchemaType(new XSClass(jClass));
                    }
                }
                classInfo.addFieldInfo(fInfo);
                fInfo.getMemberAndAccessorFactory().createJavaField(fInfo, jClass);
                fInfo.getMemberAndAccessorFactory().createAccessMethods(fInfo, jClass, this.getConfig().useJava50(), this.getConfig().getAnnotationBuilders());
                fInfo.getMemberAndAccessorFactory().generateInitializerCode(fInfo, jClass.getConstructor(0).getSourceCode());
                XMLInfoNature xmlInfoNature = new XMLInfoNature(classInfo);
                xmlInfoNature.setNodeName(component.getXMLName());
                xmlInfoNature.setContainer(true);
                String actSuperClass = classes[1].getSuperClassQualifiedName();
                jClass.setSuperClass(actSuperClass);
                classes[1].setSuperClass(null);
            }
        }
        classes[0] = jClass;
        String baseClass = component.getExtends();
        if (baseClass != null && baseClass.length() > 0 && jClass.getSuperClassQualifiedName() == null) {
            jClass.setSuperClass(baseClass);
        }
        if ((implemented = component.getImplements()) != null) {
            int i = 0;
            while (i < implemented.length) {
                String interfaceName = implemented[i];
                if (interfaceName != null && interfaceName.length() > 0) {
                    jClass.addInterface(interfaceName);
                }
                ++i;
            }
        }
        jClass.getModifiers().setFinal(component.isFinal());
        if (component.isAbstract()) {
            jClass.getModifiers().setAbstract(true);
            classInfo.setAbstract(true);
        }
        this.processAppInfo(component.getAnnotated(), classInfo);
        this.extractAnnotations(component.getAnnotated(), jClass);
        this.createContructorForDefaultValueForSimpleContent(component.getAnnotated(), classInfo, sgState);
        this.makeMethods(component, sgState, state, jClass, baseClass);
        if (classInfo.hasNature(JDOClassInfoNature.class.getName()) && (jdoNature = new JDOClassInfoNature(classInfo)).getDetachable()) {
            this.createJdoTimestampImplementations(jClass);
        }
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(component.getAnnotated(), classInfo);
        sgState.bindSourceCode(component.getAnnotated(), classes);
        AnnotationBuilder[] annotationBuilders = this.getConfig().getAnnotationBuilders();
        int i = 0;
        while (i < annotationBuilders.length) {
            AnnotationBuilder annotationBuilder = annotationBuilders[i];
            annotationBuilder.addClassAnnotations(classInfo, jClass);
            ++i;
        }
        return classes;
    }

    private void createContructorForDefaultValueForSimpleContent(Annotated annotated, ClassInfo classInfo, SGStateInfo sgStateInfo) {
        XSType textFieldType;
        FieldInfo textFieldInfo = classInfo.getTextField();
        boolean generate = false;
        boolean inherited = false;
        if (annotated instanceof ElementDecl) {
            XMLType type = ((ElementDecl)annotated).getType();
            ClassInfo typeInfo = sgStateInfo.resolve(type);
            if (typeInfo != null && typeInfo.getTextField() != null) {
                textFieldInfo = typeInfo.getTextField();
                inherited = true;
            }
            generate = type.isComplexType() && ((ComplexType)type).isSimpleContent();
        } else if (annotated instanceof ComplexType && ((ComplexType)annotated).isSimpleContent()) {
            generate = true;
        }
        if (textFieldInfo != null && (textFieldType = new XMLInfoNature(textFieldInfo).getSchemaType()) != null && textFieldType.getJType().isArray()) {
            generate = false;
        }
        if (!generate) {
            return;
        }
        XMLInfoNature xmlNature = new XMLInfoNature(textFieldInfo);
        JClass jClass = classInfo.getJClass();
        JParameter parameter = new JParameter(new JClass("java.lang.String"), "defaultValue");
        JConstructor constructor = jClass.createConstructor(new JParameter[]{parameter});
        JSourceCode sourceCode = new JSourceCode();
        if (inherited) {
            sourceCode.add("super(defaultValue);");
        } else {
            sourceCode.add("try {");
            String defaultValue = xmlNature.getSchemaType().createDefaultValueWithString("defaultValue");
            sourceCode.addIndented("setContent(" + defaultValue + ");");
            sourceCode.add(" } catch(Exception e) {");
            sourceCode.addIndented("throw new RuntimeException(\"Unable to cast default value for simple content!\");");
            sourceCode.add(" } ");
        }
        constructor.setSourceCode(sourceCode);
        jClass.addConstructor(constructor);
    }

    private void extractAnnotations(Annotated annotated, JClass jClass) {
        String comment = this.extractCommentsFromAnnotations(annotated);
        if (comment != null) {
            jClass.getJDocComment().setComment(comment);
            if (this.getConfig().generateExtraDocumentationMethods()) {
                this.generateExtraDocumentationMethods(annotated, jClass);
            }
        }
    }

    private void generateExtraDocumentationMethods(Annotated annotated, JClass jClass) {
        JField documentationsField = new JField(new JClass("java.util.Map"), "_xmlSchemaDocumentations");
        documentationsField.setComment("The content of the <xsd:documentation> elements");
        documentationsField.setInitString("new java.util.HashMap()");
        jClass.addMember(documentationsField);
        Enumeration annotations = annotated.getAnnotations();
        while (annotations.hasMoreElements()) {
            Annotation annotation = (Annotation)annotations.nextElement();
            Enumeration documentations = annotation.getDocumentation();
            while (documentations.hasMoreElements()) {
                Documentation documentation = (Documentation)documentations.nextElement();
                JConstructor defaultConstructor = jClass.getConstructor(0);
                String documentationContent = this.normalize(documentation.getContent());
                documentationContent = StringUtil.replaceAll((String)documentationContent, (String)"\n", (String)"\"\n+ \" ");
                defaultConstructor.getSourceCode().add("_xmlSchemaDocumentations.put(\"" + documentation.getSource() + "\", \"" + documentationContent + "\");");
            }
        }
        JMethod aMethod = new JMethod("getXmlSchemaDocumentations", new JClass("java.util.Map"), " A collection of documentation elements.");
        JSourceCode sourceCode = aMethod.getSourceCode();
        sourceCode.add("return _xmlSchemaDocumentations;");
        jClass.addMethod(aMethod);
        JMethod anotherMethod = new JMethod("getXmlSchemaDocumentation", new JClass("java.lang.String"), " A specific XML schema documentation element.");
        JParameter parameter = new JParameter(new JClass("java.lang.String"), "source");
        anotherMethod.addParameter(parameter);
        sourceCode = anotherMethod.getSourceCode();
        sourceCode.add("return (java.lang.String) _xmlSchemaDocumentations.get(source);");
        jClass.addMethod(anotherMethod);
    }

    private void makeMethods(XMLBindingComponent component, SGStateInfo sgState, FactoryState state, JClass jClass, String baseClass) {
        String superclassQualifiedName;
        if (this._createMarshalMethods) {
            this.createValidateMethods(jClass);
            if (!component.isAbstract()) {
                this.createMarshalMethods(jClass);
                this.createUnmarshalMethods(jClass, sgState);
            }
        }
        if (component.hasEquals()) {
            this.createEqualsMethod(jClass);
            this.createHashCodeMethod(jClass);
        }
        if (this._testable) {
            this.createTestableMethods(jClass, state);
        }
        if (((superclassQualifiedName = jClass.getSuperClassQualifiedName()) == null || superclassQualifiedName.equals(baseClass)) && component.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
    }

    private boolean processSchemaGroup(XMLBindingComponent component, FactoryState state, ClassInfo classInfo) {
        try {
            Group group = (Group)component.getAnnotated();
            this.processContentModel((ContentModelGroup)group, state);
            component.setView((Annotated)group);
            Order order = group.getOrder();
            GroupInfo groupInfo = new XMLInfoNature(classInfo).getGroupInfo();
            if (order == Order.choice) {
                groupInfo.setAsChoice();
            } else if (order == Order.sequence) {
                groupInfo.setAsSequence();
            } else {
                groupInfo.setAsAll();
            }
            return group.getMaxOccurs() == 1;
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("Illegal binding component: " + ce.getMessage());
        }
    }

    private void processSimpleTypeEnumeration(XMLBindingComponent component, SGStateInfo sgState, ClassInfo classInfo, SimpleType simpleType) {
        String tns = simpleType.getSchema().getTargetNamespace();
        boolean create = false;
        create = tns == null ? component.getTargetNamespace() == null : tns.equals(component.getTargetNamespace());
        if (create) {
            ClassInfo tmpInfo = sgState.resolve(simpleType);
            JClass tmpClass = null;
            tmpClass = tmpInfo != null ? tmpInfo.getJClass() : this.createSourceCode(component.getBinding(), simpleType, sgState);
            XMLInfoNature xmlNature = new XMLInfoNature(classInfo);
            xmlNature.setSchemaType(new XSClass(tmpClass));
        }
    }

    private void processComplexType(XMLBindingComponent component, SGStateInfo sgState, FactoryState state) {
        XMLType type = component.getXMLType();
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        boolean creatingForAnElement = component.getAnnotated().getStructureType() == 8;
        ComplexType complexType = (ComplexType)type;
        if (complexType.isTopLevel() && creatingForAnElement) {
            Annotated saved = component.getAnnotated();
            String previousPackage = component.getJavaPackage();
            XMLBindingComponent baseComponent = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
            baseComponent.setBinding(component.getBinding());
            baseComponent.setView((Annotated)complexType);
            this.createSourceCode(baseComponent, sgState);
            String baseClassName = null;
            String basePackage = baseComponent.getJavaPackage();
            if (basePackage != null && !basePackage.equals(previousPackage)) {
                baseClassName = baseComponent.getQualifiedName();
                if (baseClassName.indexOf(46) == -1) {
                    baseClassName = this.getJavaNaming().toJavaClassName(baseClassName);
                }
            } else {
                baseClassName = baseComponent.getJavaClassName();
            }
            jClass.setSuperClass(baseClassName);
            basePackage = null;
            baseClassName = null;
            component.setView(saved);
            saved = null;
        } else if (complexType.isTopLevel() || creatingForAnElement) {
            Group group;
            Particle particle;
            if (complexType.getParticleCount() == 1 && (particle = complexType.getParticle(0)).getStructureType() == 10 && (group = (Group)particle).getOrder() == Order.choice) {
                new XMLInfoNature(classInfo).getGroupInfo().setAsChoice();
            }
            Annotated saved = component.getAnnotated();
            this.processComplexType(complexType, state);
            component.setView(saved);
            saved = null;
        }
    }

    public JClass createSourceCode(ExtendedBinding binding, SimpleType simpleType, SGStateInfo sgState) {
        JDOClassInfoNature jdoNature;
        String boundClassName;
        if (SimpleTypesFactory.isBuiltInType((int)simpleType.getTypeCode())) {
            String err = "You cannot construct a ClassInfo for a built-in SimpleType.";
            throw new IllegalArgumentException(err);
        }
        if (sgState == null) {
            throw new IllegalArgumentException("SGStateInfo cannot be null.");
        }
        if (simpleType.getStructureType() == 22) {
            if (!sgState.getSuppressNonFatalWarnings()) {
                String message = "warning: support for unions is incomplete.";
                sgState.getDialog().notify(message);
            }
            return null;
        }
        ClassInfo cInfo = sgState.resolve(simpleType);
        if (cInfo != null) {
            return cInfo.getJClass();
        }
        boolean enumeration = false;
        String typeName = simpleType.getName();
        if (typeName == null) {
            Structure struct = simpleType.getParent();
            FactoryState fstate = null;
            switch (struct.getStructureType()) {
                case 3: {
                    typeName = ((AttributeDecl)struct).getName();
                    fstate = sgState.getCurrentFactoryState();
                    break;
                }
                case 8: {
                    typeName = ((ElementDecl)struct).getName();
                    break;
                }
            }
            if (fstate != null) {
                typeName = this.getJavaNaming().toJavaClassName(typeName);
                Structure attrDeclParent = ((AttributeDecl)struct).getParent();
                typeName = attrDeclParent != null && attrDeclParent.getStructureType() == 4 ? this.getJavaNaming().toJavaClassName(String.valueOf(((AttributeGroupDecl)attrDeclParent).getName()) + typeName) : String.valueOf(fstate.getJClass().getLocalName()) + typeName;
            }
            typeName = String.valueOf(typeName) + "Type";
        }
        String className = this.getJavaNaming().toJavaClassName(typeName);
        XMLBindingComponent comp = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (binding != null) {
            comp.setBinding(binding);
        }
        if (simpleType.getName() == null) {
            Annotated annotated = (Annotated)simpleType.getParent();
            comp.setView(annotated);
        } else {
            comp.setView((Annotated)simpleType);
        }
        String packageName = comp.getJavaPackage();
        if (packageName == null || packageName.length() == 0) {
            packageName = sgState.getPackageName();
        }
        if (simpleType.getName() == null) {
            comp.setView((Annotated)simpleType);
        }
        if (simpleType.hasFacet("enumeration")) {
            enumeration = true;
            packageName = packageName != null && packageName.length() > 0 ? String.valueOf(packageName) + "." + "types" : "types";
        }
        if ((boundClassName = comp.getJavaClassName()) != null && boundClassName.length() > 0) {
            className = boundClassName;
            typeName = boundClassName;
        }
        className = this.resolveClassName(className, packageName);
        FactoryState state = new FactoryState(className, sgState, packageName, comp, enumeration && this.getConfig().useJava5Enums());
        state.setParent(sgState.getCurrentFactoryState());
        ClassInfo classInfo = state.getClassInfo();
        JClass jClass = state.getJClass();
        this.initialize(jClass);
        Schema schema = simpleType.getSchema();
        XMLInfoNature xmlNature = new XMLInfoNature(classInfo);
        xmlNature.setNamespaceURI(schema.getTargetNamespace());
        xmlNature.setNodeName(typeName);
        this.extractAnnotations((Annotated)simpleType, jClass);
        XSClass xsClass = new XSClass(jClass, typeName);
        xmlNature.setSchemaType(xsClass);
        if (enumeration) {
            xsClass.setAsEnumerated(true);
            this.processEnumeration(binding, simpleType, state);
        }
        if (state.hasBoundProperties() && !enumeration) {
            this.createPropertyChangeMethods(jClass);
        }
        if (classInfo.hasNature(JDOClassInfoNature.class.getName()) && (jdoNature = new JDOClassInfoNature(classInfo)).getDetachable()) {
            this.createJdoTimestampImplementations(jClass);
        }
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(simpleType, classInfo);
        return jClass;
    }

    private void createJdoTimestampImplementations(JClass jClass) {
        jClass.addInterface("org.exolab.castor.jdo.TimeStampable");
        JField jdoTimestamp = new JField(JType.LONG, "_jdoTimeStamp");
        jClass.addField(jdoTimestamp);
        JMethod getTSMethod = new JMethod("jdoGetTimeStamp", JType.LONG, "returns the current time stamp");
        JSourceCode getSourceCode = getTSMethod.getSourceCode();
        getSourceCode.addIndented("return _jdoTimeStamp;");
        jClass.addMethod(getTSMethod);
        JMethod setTSMethod = new JMethod("jdoSetTimeStamp");
        JParameter parameter = new JParameter(JType.LONG, "jdoTimeStamp");
        setTSMethod.addParameter(parameter);
        JSourceCode setSourceCode = setTSMethod.getSourceCode();
        setSourceCode.addIndented("this._jdoTimeStamp = jdoTimeStamp;");
        jClass.addMethod(setTSMethod);
    }

    private void initialize(JClass jClass) {
        jClass.addInterface("java.io.Serializable");
        if (this.getConfig().useJava50()) {
            JAnnotation serial = new JAnnotation(new JAnnotationType("SuppressWarnings"));
            serial.setValue(new String[]{"\"serial\""});
            jClass.addAnnotation(serial);
        }
        JConstructor con = jClass.createConstructor();
        jClass.addConstructor(con);
        con.getSourceCode().add("super();");
    }

    private void createPropertyChangeMethods(JClass parent) {
        String vName = "propertyChangeSupport";
        JField field = new JField(SGTypes.PROPERTY_CHANGE_SUPPORT, vName);
        field.getModifiers().makePrivate();
        parent.addField(field);
        JMethod jMethod = new JMethod("notifyPropertyChangeListeners");
        jMethod.getModifiers().makeProtected();
        JDocComment jdc = jMethod.getJDocComment();
        JDocDescriptor jdDesc = null;
        String desc = null;
        desc = "Notifies all registered PropertyChangeListeners when a bound property's value changes.";
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(SGTypes.STRING, "fieldName"));
        jdDesc = jdc.getParamDescriptor("fieldName");
        jdDesc.setDescription("the name of the property that has changed.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "oldValue"));
        jdDesc = jdc.getParamDescriptor("oldValue");
        jdDesc.setDescription("the old value of the property.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "newValue"));
        jdDesc = jdc.getParamDescriptor("newValue");
        jdDesc.setDescription("the new value of the property.");
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return;");
        jsc.add(vName);
        jsc.append(".firePropertyChange(fieldName,oldValue,newValue);");
        JClass jType = new JClass("java.beans.PropertyChangeListener");
        jMethod = new JMethod("addPropertyChangeListener");
        desc = "Registers a PropertyChangeListener with this class.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to register.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) {");
        jsc.addIndented(String.valueOf(vName) + " = new java.beans.PropertyChangeSupport(this);");
        jsc.add("}");
        jsc.add(vName);
        jsc.append(".addPropertyChangeListener(pcl);");
        jMethod = new JMethod("removePropertyChangeListener", JType.BOOLEAN, "always returns true if pcl != null");
        desc = "Removes the given PropertyChangeListener from this classes list of ProperyChangeListeners.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to remove.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return false;");
        jsc.add(vName);
        jsc.append(".removePropertyChangeListener(pcl);");
        jsc.add("return true;");
    }

    private void createMarshalMethods(JClass parent) {
        this.createMarshalMethods(parent, false);
    }

    private void createMarshalMethods(JClass parent, boolean isAbstract) {
        JMethod jMethod = new JMethod("marshal");
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(SGTypes.WRITER, "out"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc.add("org.exolab.castor.xml.Marshaller.marshal(this, out);");
        }
        jMethod = new JMethod("marshal");
        JClass jc = null;
        if (this._sax1) {
            jc = new JClass("org.xml.sax.DocumentHandler");
        } else {
            jc = new JClass("org.xml.sax.ContentHandler");
            jMethod.addException(SGTypes.IO_EXCEPTION, "if an IOException occurs during marshaling");
        }
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(jc, "handler"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc.add("org.exolab.castor.xml.Marshaller.marshal(this, handler);");
        }
    }

    private void createUnmarshalMethods(JClass parent, SGStateInfo sgState) {
        String methodName = "unmarshal";
        if (sgState.getSourceGenerator().mappingSchemaType2Java()) {
            methodName = String.valueOf(methodName) + parent.getLocalName();
        }
        JClass returnType = !this.getConfig().useJava50() ? this.findBaseClass(parent, sgState) : parent;
        JMethod jMethod = new JMethod(methodName, returnType, "the unmarshaled " + returnType);
        jMethod.getModifiers().setStatic(true);
        jMethod.addException(SGTypes.MARSHAL_EXCEPTION, "if object is null or if any SAXException is thrown during marshaling");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jMethod.addParameter(new JParameter(SGTypes.READER, "reader"));
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("return (");
        jsc.append(returnType.getName());
        jsc.append(") org.exolab.castor.xml.Unmarshaller.unmarshal(");
        jsc.append(parent.getName());
        jsc.append(".class, reader);");
    }

    private JClass findBaseClass(JClass jClass, SGStateInfo sgState) {
        JClass returnType = jClass;
        LinkedList<JClass> classes = new LinkedList<JClass>();
        classes.add(returnType);
        while (returnType.getSuperClassQualifiedName() != null) {
            String pkgName;
            String superClassName = returnType.getSuperClassQualifiedName();
            JClass superClass = sgState.getSourceCode(superClassName);
            if (superClass == null) {
                superClass = sgState.getImportedSourceCode(superClassName);
            }
            if (superClass == null && superClassName.indexOf(46) < 0 && (pkgName = returnType.getPackageName()) != null && pkgName.length() > 0) {
                superClassName = String.valueOf(pkgName) + "." + superClassName;
                superClass = sgState.getSourceCode(superClassName);
            }
            if (superClass == null) break;
            if (classes.contains(superClass)) {
                StringBuilder buffer = new StringBuilder(64);
                buffer.append("Loop found in class hierarchy: ");
                for (JClass element : classes) {
                    buffer.append(element.getName());
                    buffer.append(" -> ");
                }
                buffer.append(superClass.getName());
                sgState.getDialog().notify(buffer.toString());
                break;
            }
            classes.add(superClass);
            returnType = superClass;
        }
        classes.clear();
        return returnType;
    }

    public void createHashCodeMethod(JClass jclass) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] fields = jclass.getFields();
        JMethod jMethod = new JMethod("hashCode", JType.INT, "a hash code value for the object.");
        jMethod.setComment("Overrides the java.lang.Object.hashCode method.\n<p>\nThe following steps came from <b>Effective Java Programming Language Guide</b> by Joshua Bloch, Chapter 3");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        if (jclass.getSuperClassQualifiedName() == null) {
            jsc.add("int resultHc = 17;");
        } else {
            jsc.add("int resultHc = super.hashCode();");
        }
        jsc.add("");
        jsc.add("long tmp;");
        int i = 0;
        while (i < fields.length) {
            JField temp = fields[i];
            JType type = temp.getType();
            String name = temp.getName();
            if (type.isPrimitive()) {
                if (type == JType.BOOLEAN) {
                    if (!name.startsWith("_has_") || jclass.getField(name.substring(5)) != null) {
                        jsc.add("resultHc = 37 * resultHc + (" + name + "?0:1);");
                    }
                } else if (type == JType.BYTE || type == JType.INT || type == JType.SHORT) {
                    jsc.add("resultHc = 37 * resultHc + " + name + ";");
                } else if (type == JType.LONG) {
                    jsc.add("resultHc = 37 * resultHc + (int)(" + name + "^(" + name + ">>>32));");
                } else if (type == JType.FLOAT) {
                    jsc.add("resultHc = 37 * resultHc + java.lang.Float.floatToIntBits(" + name + ");");
                } else if (type == JType.DOUBLE) {
                    jsc.add("tmp = java.lang.Double.doubleToLongBits(" + name + ");");
                    jsc.add("resultHc = 37 * resultHc + (int)(tmp^(tmp>>>32));");
                }
            } else {
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("if (" + name + " != null");
                    jsc.add("       && !org.castor.core.util.CycleBreaker.startingToCycle(" + name + ")) {");
                } else {
                    jsc.add("if (" + name + " != null) {");
                }
                jsc.add("   resultHc = 37 * resultHc + " + name + ".hashCode();");
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("   org.castor.core.util.CycleBreaker.releaseCycleHandle(" + name + ");");
                }
                jsc.add("}");
            }
            ++i;
        }
        jsc.add("");
        jsc.add("return resultHc;");
    }

    public void createEqualsMethod(JClass jclass) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] fields = jclass.getFields();
        JMethod jMethod = new JMethod("equals", JType.BOOLEAN, "true if the objects are equal.");
        jMethod.setComment("Overrides the java.lang.Object.equals method.");
        jMethod.addParameter(new JParameter(SGTypes.OBJECT, "obj"));
        if (this.getConfig().useJava50()) {
            jMethod.addAnnotation(new JAnnotation(new JAnnotationType("Override")));
        }
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if ( this == obj )");
        jsc.indent();
        jsc.add("return true;");
        jsc.unindent();
        if (jclass.getSuperClassQualifiedName() != null) {
            jsc.add("");
            jsc.add("if (super.equals(obj)==false)");
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
        }
        jsc.add("");
        jsc.add("if (obj instanceof ");
        jsc.append(jclass.getLocalName());
        jsc.append(") {");
        jsc.add("");
        if (fields.length > 0) {
            jsc.indent();
            jsc.add(jclass.getLocalName());
            jsc.append(" temp = (");
            jsc.append(jclass.getLocalName());
            jsc.append(")obj;");
            if (this.getConfig().useCycleBreaker()) {
                jsc.add("boolean thcycle;");
                jsc.add("boolean tmcycle;");
            }
        }
        int i = 0;
        while (i < fields.length) {
            JField temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive()) {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != temp.");
                jsc.append(name);
                jsc.append(")");
            } else {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != null) {");
                jsc.indent();
                jsc.add("if (temp.");
                jsc.append(name);
                jsc.append(" == null) ");
                jsc.indent();
                jsc.append("return false;");
                jsc.unindent();
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("if (this.");
                    jsc.append(name);
                    jsc.append(" != temp.");
                    jsc.append(name);
                    jsc.append(") {");
                    jsc.indent();
                    jsc.add("thcycle=org.castor.core.util.CycleBreaker.startingToCycle(this." + name + ");");
                    jsc.add("tmcycle=org.castor.core.util.CycleBreaker.startingToCycle(temp." + name + ");");
                    jsc.add("if (thcycle!=tmcycle) {");
                    jsc.indent();
                    jsc.add("if (!thcycle) { org.castor.core.util.CycleBreaker.releaseCycleHandle(this." + name + "); };");
                    jsc.add("if (!tmcycle) { org.castor.core.util.CycleBreaker.releaseCycleHandle(temp." + name + "); };");
                    jsc.add("return false;");
                    jsc.unindent();
                    jsc.add("}");
                    jsc.add("if (!thcycle) {");
                    jsc.indent();
                }
                jsc.add("if (!");
                if (temp.getType().isArray()) {
                    jsc.append("java.util.Arrays.equals(this.");
                    jsc.append(name);
                    jsc.append(", temp.");
                    jsc.append(name);
                    jsc.append(")");
                } else {
                    jsc.append("this.");
                    jsc.append(name);
                    jsc.append(".equals(temp.");
                    jsc.append(name);
                    jsc.append(")");
                }
                if (this.getConfig().useCycleBreaker()) {
                    jsc.append(") {");
                } else {
                    jsc.append(") ");
                }
                jsc.indent();
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("org.castor.core.util.CycleBreaker.releaseCycleHandle(this." + name + ");");
                    jsc.add("org.castor.core.util.CycleBreaker.releaseCycleHandle(temp." + name + ");");
                }
                jsc.add("return false;");
                jsc.unindent();
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("}");
                    jsc.add("org.castor.core.util.CycleBreaker.releaseCycleHandle(this." + name + ");");
                    jsc.add("org.castor.core.util.CycleBreaker.releaseCycleHandle(temp." + name + ");");
                }
                jsc.unindent();
                if (this.getConfig().useCycleBreaker()) {
                    jsc.add("}");
                    jsc.unindent();
                    jsc.add("}");
                    jsc.unindent();
                }
                jsc.add("} else if (temp.");
                jsc.append(name);
                jsc.append(" != null)");
            }
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
            ++i;
        }
        jsc.add("return true;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return false;");
    }

    public void createTestableMethods(JClass jclass, FactoryState state) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        jclass.addInterface("org.castor.xmlctf.CastorTestable");
        jclass.addImport("org.castor.xmlctf.CastorTestable");
        jclass.addImport("org.castor.xmlctf.RandomHelper");
        this.createRandomizeFields(jclass, state);
        this.createDumpFields(jclass);
    }

    private void createRandomizeFields(JClass jclass, FactoryState state) {
        JMethod jMethod = new JMethod("randomizeFields");
        jMethod.addException(new JClass("InstantiationException"), "if we try to instantiate an abstract class or interface");
        jMethod.addException(new JClass("IllegalAccessException"), "if we do not have access to the field, for example if it is private");
        jMethod.setComment("implementation of org.castor.xmlctf.CastorTestable");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        JField[] fields = jclass.getFields();
        int i = 0;
        while (i < fields.length) {
            block6: {
                block8: {
                    String setName;
                    JType type;
                    JField temp;
                    block7: {
                        temp = fields[i];
                        type = temp.getType();
                        String name = temp.getName();
                        if (state.getFieldInfoForChoice() != null && name.equals(state.getFieldInfoForChoice().getName()) || name.startsWith("enumConstants")) break block6;
                        name = name.startsWith("_") ? this.getJavaNaming().toJavaClassName(name.substring(1)) : this.getJavaNaming().toJavaClassName(name);
                        setName = "set" + name;
                        if (name.indexOf("Has") != -1) break block6;
                        if (!(type instanceof JCollectionType)) break block7;
                        int listLocat = name.lastIndexOf("List");
                        String tempName = name;
                        if (listLocat != -1) {
                            tempName = tempName.substring(0, listLocat);
                        }
                        String methodName = this.getJavaNaming().toJavaClassName(tempName);
                        JMethod method = jclass.getMethod(methodName = "get" + methodName, 0);
                        if (method == null) break block6;
                        String componentName = method.getReturnType().getName();
                        jsc.add(temp.getName());
                        jsc.append(" = RandomHelper.getRandom(");
                        jsc.append(temp.getName());
                        jsc.append(", ");
                        jsc.append(componentName);
                        jsc.append(".class);");
                        break block8;
                    }
                    if (type.isPrimitive()) {
                        jsc.add(setName);
                        jsc.append("(RandomHelper.getRandom(");
                        jsc.append(temp.getName());
                        jsc.append("));");
                    } else if (type.isArray()) {
                        jsc.add(setName);
                        jsc.append("((");
                        jsc.append(type.toString());
                        jsc.append(")RandomHelper.getRandom(");
                        jsc.append(temp.getName());
                        jsc.append(", java.lang.reflect.Array.class));");
                    } else {
                        jsc.add(setName);
                        jsc.append("((");
                        jsc.append(type.getName());
                        jsc.append(")RandomHelper.getRandom(");
                        jsc.append(temp.getName());
                        jsc.append(", ");
                        jsc.append(type.getName());
                        jsc.append(".class));");
                    }
                }
                jsc.add("");
            }
            ++i;
        }
    }

    private void createDumpFields(JClass jclass) {
        JMethod jMethod = new JMethod("dumpFields", SGTypes.STRING, "a String representation of all of the fields for " + jclass.getName());
        jMethod.setComment("implementation of org.castor.xmlctf.CastorTestable");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("StringBuffer stringBuffer = new StringBuffer(\"DumpFields() for element: ");
        jsc.append(jclass.getName());
        jsc.append("\\n\");");
        JField[] fields = jclass.getFields();
        int i = 0;
        while (i < fields.length) {
            JField temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive() || temp.getType().getName().startsWith("java.lang.")) {
                jsc.add("stringBuffer.append(\"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\");");
            } else if (temp.getType().isArray()) {
                jsc.add("if (");
                jsc.append(name);
                jsc.append(" != null) {");
                jsc.indent();
                jsc.add("stringBuffer.append(\"[\");");
                jsc.add("for (int i = 0; i < ");
                jsc.append(name);
                jsc.append(".length; i++) {");
                jsc.indent();
                jsc.add("stringBuffer.append(");
                jsc.append(name);
                jsc.append("[i] + \" \");");
                jsc.unindent();
                jsc.add("}");
                jsc.add("stringBuffer.append(\"]\");");
                jsc.unindent();
                jsc.add("}");
            } else {
                jsc.add("if ( (");
                jsc.append(name);
                jsc.append(" != null) && (");
                jsc.append(name);
                jsc.append(".getClass().isAssignableFrom(CastorTestable.class)))");
                jsc.indent();
                jsc.add("stringBuffer.append(((CastorTestable)");
                jsc.append(name);
                jsc.append(").dumpFields());");
                jsc.unindent();
                jsc.add("else stringBuffer.append(\"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\");");
            }
            jsc.add("");
            ++i;
        }
        jsc.add("");
        jsc.add("return stringBuffer.toString();");
    }

    private void createValidateMethods(JClass jClass) {
        JMethod jMethod = null;
        JSourceCode jsc = null;
        jMethod = new JMethod("validate");
        jMethod.addException(SGTypes.VALIDATION_EXCEPTION, "if this object is an invalid instance according to the schema");
        jClass.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("org.exolab.castor.xml.Validator validator = new ");
        jsc.append("org.exolab.castor.xml.Validator();");
        jsc.add("validator.validate(this);");
        jMethod = new JMethod("isValid", JType.BOOLEAN, "true if this object is valid according to the schema");
        jsc = jMethod.getSourceCode();
        jsc.add("try {");
        jsc.indent();
        jsc.add("validate();");
        jsc.unindent();
        jsc.add("} catch (org.exolab.castor.xml.ValidationException vex) {");
        jsc.indent();
        jsc.add("return false;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return true;");
        jClass.addMethod(jMethod);
    }

    private String resolveClassName(String name, String packageName) {
        if (packageName != null && packageName.length() > 0) {
            return String.valueOf(packageName) + "." + name;
        }
        return name;
    }

    private void processAppInfo(Annotated annotated, ClassInfo cInfo) {
        Enumeration annotations = annotated.getAnnotations();
        while (annotations.hasMoreElements()) {
            Annotation ann = (Annotation)annotations.nextElement();
            Enumeration appInfos = ann.getAppInfo();
            while (appInfos.hasMoreElements()) {
                Iterator it;
                AppInfoJpaNature nature;
                List content;
                AppInfo appInfo = (AppInfo)appInfos.nextElement();
                if (!appInfo.hasNature(AppInfoJpaNature.class.getName()) || (content = (nature = new AppInfoJpaNature(appInfo)).getContent()) == null || content.isEmpty() || !(it = content.iterator()).hasNext()) continue;
                cInfo.addNature(JDOClassInfoNature.class.getName());
                JDOClassInfoNature cNature = new JDOClassInfoNature(cInfo);
                while (it.hasNext()) {
                    Object tmpObject = it.next();
                    if (!(tmpObject instanceof Table)) continue;
                    Table table = (Table)tmpObject;
                    cNature.setTableName(table.getName());
                    cNature.setAccessMode(AccessMode.valueOf((String)"shared"));
                    cNature.setDetachable(table.isDetachable());
                    PrimaryKey pk = table.getPrimaryKey();
                    Iterator pIt = pk.iterateKey();
                    while (pIt.hasNext()) {
                        cNature.addPrimaryKey((String)pIt.next());
                    }
                }
            }
        }
    }

    private void processAppInfo(Annotated annotated, FieldInfo fInfo) {
        Enumeration annotations = annotated.getAnnotations();
        while (annotations.hasMoreElements()) {
            Annotation ann = (Annotation)annotations.nextElement();
            Enumeration appInfos = ann.getAppInfo();
            while (appInfos.hasMoreElements()) {
                Iterator it;
                List content;
                AppInfoSolrjNature nature;
                Object solrjRawContent;
                AppInfo appInfo = (AppInfo)appInfos.nextElement();
                if (appInfo.hasNature(AppInfoSolrjNature.class.getName()) && (solrjRawContent = (nature = new AppInfoSolrjNature(appInfo)).getContent()) != null) {
                    Field solrjField;
                    fInfo.addNature(SolrjFieldInfoNature.class.getName());
                    SolrjFieldInfoNature solrjNature = new SolrjFieldInfoNature(fInfo);
                    if (solrjRawContent instanceof Field && StringUtils.isNotBlank((String)(solrjField = (Field)solrjRawContent).getName())) {
                        solrjNature.setFieldName(solrjField.getName());
                    }
                }
                if (!appInfo.hasNature(AppInfoJpaNature.class.getName()) || (content = (nature = new AppInfoJpaNature(appInfo)).getContent()) == null || content.isEmpty() || !(it = content.iterator()).hasNext()) continue;
                while (it.hasNext()) {
                    OneToOne relation;
                    Object tmpObject = it.next();
                    if (tmpObject instanceof Column) {
                        fInfo.addNature(JDOFieldInfoNature.class.getName());
                        JDOFieldInfoNature fNature = new JDOFieldInfoNature(fInfo);
                        Column column = (Column)tmpObject;
                        fNature.setColumnName(column.getName());
                        fNature.setColumnType(column.getType());
                        fNature.setReadOnly(column.isReadOnly());
                        fNature.setDirty(false);
                        fNature.setDirty(column.getDirty());
                        continue;
                    }
                    if (tmpObject instanceof OneToOne) {
                        relation = (OneToOne)tmpObject;
                        fInfo.addNature(JDOOneToOneNature.class.getName());
                        JDOOneToOneNature oneNature = new JDOOneToOneNature(fInfo);
                        oneNature.addForeignKey(relation.getName());
                        oneNature.setDirty(relation.isDirty());
                        oneNature.setReadOnly(relation.isReadOnly());
                        continue;
                    }
                    if (!(tmpObject instanceof OneToMany)) continue;
                    relation = (OneToMany)tmpObject;
                    fInfo.addNature(JDOOneToManyNature.class.getName());
                    JDOOneToManyNature manyNature = new JDOOneToManyNature(fInfo);
                    manyNature.addForeignKey(relation.getName());
                    manyNature.setDirty(relation.isDirty());
                    manyNature.setReadOnly(relation.isReadOnly());
                }
            }
        }
    }

    private void processAttributes(ExtendedBinding binding, ComplexType complexType, FactoryState state) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            AttributeDecl attr = (AttributeDecl)enumeration.nextElement();
            component.setView((Annotated)attr);
            SimpleType sType = attr.getSimpleType();
            XMLType baseXMLType = complexType.getBaseType();
            while (sType == null) {
                if (baseXMLType == null || !(baseXMLType instanceof ComplexType)) break;
                ComplexType baseComplexType = (ComplexType)baseXMLType;
                AttributeDecl baseAttribute = baseComplexType.getAttributeDecl(attr.getName());
                if (baseAttribute != null && (sType = baseAttribute.getSimpleType()) != null) {
                    attr.setSimpleType(sType);
                    break;
                }
                baseXMLType = baseXMLType.getBaseType();
            }
            if (sType == null && attr.getReference() != null) {
                SimpleType referencedSimpleType = attr.getReference().getSimpleType();
                attr.setSimpleType(referencedSimpleType);
                sType = referencedSimpleType;
            }
            if (sType != null && !SimpleTypesFactory.isBuiltInType((int)sType.getTypeCode()) && sType.getSchema() == component.getSchema() && state.resolve(sType) == null && sType.hasFacet("enumeration")) {
                this.createSourceCode(component.getBinding(), sType, state.getSGStateInfo());
            }
            FieldInfo fieldInfo = this._memberFactory.createFieldInfo(component, state, this.getConfig().useJava50());
            this.handleField(fieldInfo, state, component);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processComplexType(ComplexType complexType, FactoryState state) {
        block12: {
            component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
            if (this._binding != null) {
                component.setBinding(this._binding);
            }
            component.setView((Annotated)complexType);
            typeName = component.getXMLName();
            classInfo = state.getClassInfo();
            xmlNature = new XMLInfoNature(classInfo);
            xmlNature.setSchemaType(new XSClass(state.getJClass(), typeName));
            base = complexType.getBaseType();
            if (base == null) break block12;
            if (base.isComplexType()) {
                baseClassName = null;
                component.setView((Annotated)base);
                if (base.getSchema() == complexType.getSchema()) {
                    cInfo = state.resolve(base);
                    if (cInfo == null) {
                        classes = this.createSourceCode(component, state.getSGStateInfo());
                        cInfo = state.resolve(base);
                        baseClassName = classes[0].getName();
                    } else {
                        baseClassName = cInfo.getJClass().getName();
                    }
                    classInfo.setBaseClass(cInfo);
                } else {
                    baseClassName = component.getQualifiedName();
                }
                component.setView((Annotated)complexType);
                state.getJClass().setSuperClass(baseClassName);
            }
            if (complexType.getContentType().getType() != 4) break block12;
            simpleContent = (SimpleContent)complexType.getContentType();
            temp = simpleContent.getSimpleType();
            baseType = (SimpleType)temp.getBaseType();
            xsType = this._typeConversion.convertType(temp, state.getPackageName(), this.getConfig().useJava50());
            fieldInfo = null;
            if (baseType == null || !this.extendsSimpleType(state.getJClass(), baseType, state)) ** GOTO lbl53
            if (!xsType.isEnumerated()) break block12;
            fieldInfo = this._memberFactory.createFieldInfoForContent(component, xsType, this.getConfig().useJava50());
            fieldInfo.setBound(false);
            this.handleField(fieldInfo, state, component);
            mname = fieldInfo.getReadMethodName();
            jClass = state.getJClass();
            method = jClass.getMethod(mname, 0);
            jClass.removeMethod(method);
            mname = fieldInfo.getWriteMethodName();
            method = jClass.getMethod(mname, 0);
            jsc = method.getSourceCode();
            jsc.add("super.");
            jsc.append(mname);
            jsc.append("(this.");
            jsc.append(fieldInfo.getName());
            jsc.append(".toString());");
            break block12;
lbl-1000:
            // 1 sources

            {
                temp = (SimpleType)temp.getBaseType();
lbl53:
                // 2 sources

                ** while (temp.getBaseType() != null && !temp.isBuiltInType())
            }
lbl54:
            // 1 sources

            xsType = this._typeConversion.convertType(temp, state.getPackageName(), this.getConfig().useJava50());
            fieldInfo = this._memberFactory.createFieldInfoForContent(component, xsType, this.getConfig().useJava50());
            this.handleField(fieldInfo, state, component);
        }
        if (!state.isCreateGroupItem()) {
            this.processAttributes(component.getBinding(), complexType, state);
            component.setView((Annotated)complexType);
            if (complexType.getContentType() == ContentType.mixed) {
                fieldInfo = this._memberFactory.createFieldInfoForContent(component, new XSString(), this.getConfig().useJava50());
                this.handleField(fieldInfo, state, component);
            }
        }
        this.processContentModel((ContentModelGroup)complexType, state);
    }

    private void processContentModel(ContentModelGroup model, FactoryState state) {
        ContentModelGroup contentModel = model;
        Enumeration enumeration = contentModel.enumerate();
        if (new XMLInfoNature(state.getClassInfo()).isChoice() && state.getFieldInfoForChoice() == null) {
            state.setFieldInfoForChoice(this._memberFactory.createFieldInfoForChoiceValue());
            state.getFieldInfoForChoice().getMemberAndAccessorFactory().createJavaField(state.getFieldInfoForChoice(), state.getJClass());
            state.getFieldInfoForChoice().getMemberAndAccessorFactory().createAccessMethods(state.getFieldInfoForChoice(), state.getJClass(), this.getConfig().useJava50(), this.getConfig().getAnnotationBuilders());
        }
        FieldInfo fieldInfo = null;
        XMLBindingComponent component = new XMLBindingComponent(this.getConfig(), this.getGroupNaming());
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            Annotated annotated = (Annotated)enumeration.nextElement();
            component.setView(annotated);
            switch (annotated.getStructureType()) {
                case 8: {
                    fieldInfo = this._memberFactory.createFieldInfo(component, state, this.getConfig().useJava50());
                    if (contentModel.getMinOccurs() == 0) {
                        XMLInfoNature xmlNature = new XMLInfoNature(fieldInfo);
                        xmlNature.setRequired(false);
                    }
                    this.handleField(fieldInfo, state, component);
                    break;
                }
                case 10: {
                    Group group = (Group)annotated;
                    if (contentModel instanceof ComplexType || contentModel instanceof ModelGroup) {
                        if (group.getOrder() == Order.choice) {
                            new XMLInfoNature(state.getClassInfo()).getGroupInfo().setAsChoice();
                        } else if (group.getOrder() == Order.all) {
                            new XMLInfoNature(state.getClassInfo()).getGroupInfo().setAsAll();
                        } else if (group.getOrder() == Order.sequence) {
                            new XMLInfoNature(state.getClassInfo()).getGroupInfo().setAsSequence();
                        }
                    }
                    if (!(contentModel instanceof ComplexType) && !(contentModel instanceof ModelGroup)) {
                        ModelGroup mg;
                        if (contentModel instanceof ModelGroup && (mg = (ModelGroup)contentModel).isReference()) {
                            contentModel = mg.getReference();
                        }
                        if (contentModel.getParticleCount() <= 0) break;
                        fieldInfo = this._memberFactory.createFieldInfo(component, state.getSGStateInfo(), this.getConfig().useJava50());
                        this.handleField(fieldInfo, state, component);
                        break;
                    }
                    this.processContentModel((ContentModelGroup)group, state);
                    break;
                }
                case 16: {
                    ModelGroup modelgroup = (ModelGroup)annotated;
                    if (modelgroup.getName() != null) {
                        if (modelgroup.isReference()) {
                            modelgroup = modelgroup.getReference();
                        }
                        if (modelgroup.getParticleCount() <= 0) break;
                        fieldInfo = this._memberFactory.createFieldInfo(component, state.getSGStateInfo(), this.getConfig().useJava50());
                        this.handleField(fieldInfo, state, component);
                        break;
                    }
                    this.processContentModel(modelgroup.getContentModelGroup(), state);
                    break;
                }
                case 24: {
                    Wildcard wildcard = (Wildcard)annotated;
                    FieldInfo fieldForAny = this._memberFactory.createFieldInfoForAny(wildcard, this.getConfig().useJava50());
                    this.handleField(fieldForAny, state, component);
                    break;
                }
            }
        }
    }

    private void processEnumeration(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        if (this.getConfig().useEnumeratedTypeInterface()) {
            state.getJClass().addInterface(ENUM_ACCESS_INTERFACE);
        }
        switch (this._enumerationType) {
            case 0: {
                this.processEnumerationAsBaseType(binding, simpleType, state);
                break;
            }
            default: {
                this.processEnumerationAsNewObject(binding, simpleType, state);
            }
        }
    }

    private void processEnumerationAsNewObject(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._enumerationFactory.processEnumerationAsNewObject(binding, simpleType, state);
        if (this._testable && state.getJClass() instanceof JEnum) {
            this.createTestableMethods(state.getJClass(), state);
        }
    }

    private void processEnumerationAsBaseType(ExtendedBinding binding, SimpleType simpleType, FactoryState state) {
        this._enumerationFactory.processEnumerationAsBaseType(binding, simpleType, state);
    }

    private void handleField(FieldInfo fieldInfo, FactoryState state, XMLBindingComponent component) {
        String warn;
        SGStateInfo sInfo;
        if (fieldInfo == null) {
            return;
        }
        XMLInfoNature xmlNature = new XMLInfoNature(fieldInfo);
        if (CLASS_METHOD_SUFFIX.equals(fieldInfo.getMethodSuffix())) {
            sInfo = state.getSGStateInfo();
            if (!sInfo.getSuppressNonFatalWarnings()) {
                warn = "warning a field name conflicts with \"class\", please use a binding file to specify a different name for the " + xmlNature.getNodeTypeName() + " '" + xmlNature.getNodeName() + "'.";
                sInfo.getDialog().notify(warn);
            }
        } else if (CLASS_KEYWORD.equals(xmlNature.getNodeName()) && !(sInfo = state.getSGStateInfo()).getSuppressNonFatalWarnings()) {
            warn = "warning a field name conflicts with \"class\" and is being replaced by \"clazz\". You may use a binding file to specify a different name for the " + xmlNature.getNodeTypeName() + " '" + xmlNature.getNodeName() + "'.";
            sInfo.getDialog().notify(warn);
        }
        this.processAppInfo(component.getAnnotated(), fieldInfo);
        JSourceCode scInitializer = state.getJClass().getConstructor(0).getSourceCode();
        ClassInfo base = state.getClassInfo().getBaseClass();
        boolean present = false;
        if (base != null) {
            switch (new XMLInfoNature(fieldInfo).getNodeType()) {
                case ATTRIBUTE: {
                    present = base.getAttributeField(xmlNature.getNodeName()) != null;
                    break;
                }
                case ELEMENT: {
                    String namespaceURI;
                    FieldInfo inheritedFieldInfo;
                    String baseNodeName = xmlNature.getNodeName();
                    if (baseNodeName == null || baseNodeName.equals("-error-if-this-is-used-") || (inheritedFieldInfo = base.getElementField(baseNodeName)) == null || (namespaceURI = xmlNature.getNamespaceURI()) == null || !namespaceURI.equals(new XMLInfoNature(inheritedFieldInfo).getNamespaceURI())) break;
                    present = true;
                    break;
                }
            }
        }
        state.getClassInfo().addFieldInfo(fieldInfo);
        boolean bl = present = present && !xmlNature.isMultivalued();
        if (!present) {
            if (state.getFieldInfoForChoice() != null && fieldInfo != state.getFieldInfoForChoice()) {
                fieldInfo.setFieldInfoReference(state.getFieldInfoForChoice());
            }
            fieldInfo.getMemberAndAccessorFactory().createJavaField(fieldInfo, state.getJClass());
            if (!fieldInfo.isTransient()) {
                fieldInfo.getMemberAndAccessorFactory().createAccessMethods(fieldInfo, state.getJClass(), this.getConfig().useJava50(), this.getConfig().getAnnotationBuilders());
                if (fieldInfo.isBound()) {
                    state.setBoundProperties(true);
                }
            }
        }
        fieldInfo.getMemberAndAccessorFactory().generateInitializerCode(fieldInfo, scInitializer);
    }

    private boolean extendsSimpleType(JClass jClass, SimpleType type, FactoryState state) {
        ClassInfo cInfo;
        String superClassName = jClass.getSuperClassQualifiedName();
        if (superClassName != null && (cInfo = state.resolve(type)) != null) {
            return superClassName.equals(cInfo.getJClass().getName());
        }
        return false;
    }
}

