/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public final class JDocDescriptor {
    public static final String DEFAULT_VERSION = "$Revision$ $Date$";
    public static final short PARAM = 0;
    public static final short EXCEPTION = 1;
    public static final short RETURN = 2;
    public static final short AUTHOR = 3;
    public static final short VERSION = 4;
    public static final short REFERENCE = 5;
    private String _description = null;
    private String _name = null;
    private short _type = (short)-1;

    private JDocDescriptor(short type) {
        this._type = type;
    }

    private JDocDescriptor(short type, String name, String desc) {
        this._type = type;
        this._name = name;
        this._description = desc;
    }

    protected short compareTo(JDocDescriptor jdd) {
        short jddType = jdd.getType();
        if (jddType == this._type) {
            return 0;
        }
        return (short)(jddType < this._type ? 1 : -1);
    }

    public static JDocDescriptor createAuthorDesc() {
        return new JDocDescriptor(3);
    }

    public static JDocDescriptor createAuthorDesc(String name) {
        return new JDocDescriptor(3, name, null);
    }

    public static JDocDescriptor createExceptionDesc() {
        return new JDocDescriptor(1);
    }

    public static JDocDescriptor createExceptionDesc(String name, String desc) {
        return new JDocDescriptor(1, name, desc);
    }

    public static JDocDescriptor createParamDesc() {
        return new JDocDescriptor(0);
    }

    public static JDocDescriptor createParamDesc(String name, String desc) {
        return new JDocDescriptor(0, name, desc);
    }

    public static JDocDescriptor createReferenceDesc() {
        return new JDocDescriptor(5);
    }

    public static JDocDescriptor createReferenceDesc(String name) {
        return new JDocDescriptor(5, name, null);
    }

    public static JDocDescriptor createReturnDesc() {
        return new JDocDescriptor(2);
    }

    public static JDocDescriptor createReturnDesc(String desc) {
        return new JDocDescriptor(2, null, desc);
    }

    public static JDocDescriptor createVersionDesc() {
        return new JDocDescriptor(4);
    }

    public static JDocDescriptor createVersionDesc(String version) {
        return new JDocDescriptor(4, null, version);
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public short getType() {
        return this._type;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean allowName = true;
        switch (this._type) {
            case 3: {
                sb.append("@author");
                break;
            }
            case 1: {
                sb.append("@throws");
                break;
            }
            case 0: {
                sb.append("@param");
                break;
            }
            case 5: {
                sb.append("@see");
                break;
            }
            case 2: {
                sb.append("@return");
                break;
            }
            case 4: {
                allowName = false;
                sb.append("@version");
                break;
            }
        }
        if (this._name != null && allowName) {
            sb.append(' ');
            sb.append(this._name);
        }
        if (this._description != null) {
            sb.append(' ');
            sb.append(this._description);
        }
        return sb.toString();
    }
}

