/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.printing;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.printing.JClassPrinterFactory;

public class JClassPrinterFactoryRegistry {
    private final Log _log = LogFactory.getLog(JClassPrinterFactoryRegistry.class);
    private Map _factories = new HashMap();

    public JClassPrinterFactoryRegistry(BuilderConfiguration config) {
        String jClassPrinterFactories = config.getJClassPrinterFactories();
        String[] factoryClassNames = jClassPrinterFactories.split(",");
        for (int i = 0; i < factoryClassNames.length; ++i) {
            JClassPrinterFactory factory;
            try {
                factory = (JClassPrinterFactory)Class.forName(factoryClassNames[i]).newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Property entry '" + factoryClassNames[i] + "' does" + " not represent a valid class name.");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Property entry '" + factoryClassNames[i] + "' does" + " not represent a valid class name.");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Property entry '" + factoryClassNames[i] + "' does" + " not represent a valid class name.");
            }
            this._factories.put(factory.getName(), factory);
        }
    }

    public String[] getJClassPrinterFactoryNames() {
        String[] names = new String[this._factories.size()];
        return this._factories.keySet().toArray(names);
    }

    public JClassPrinterFactory getJClassPrinterFactory(String name) {
        Object factory = this._factories.get(name);
        if (factory == null) {
            String msg = "The JClassPrinterFactory '" + name + "' " + "does not exist in the Castor XML code generator properties file " + "and is therefore not supported.";
            this._log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        return (JClassPrinterFactory)factory;
    }
}

