/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.info;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.castor.core.nature.PropertyHolder;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.GroupInfo;
import org.exolab.castor.builder.info.NodeType;
import org.exolab.castor.builder.info.XMLInfo;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.javasource.JClass;

public final class ClassInfo
implements XMLInfo,
PropertyHolder {
    private ClassInfo _baseClass = null;
    private JClass _class = null;
    private boolean _abstract = false;
    private Vector _atts = new Vector();
    private Vector _elements = new Vector();
    private FieldInfo _textField = null;
    private Map _properties = new HashMap();
    private Set _natures = new HashSet();

    public ClassInfo(JClass jClass) {
        this.addNature(XMLInfoNature.class.getName());
        XMLInfoNature xmlNature = new XMLInfoNature(this);
        xmlNature.setNodeType(NodeType.ELEMENT);
        if (jClass == null) {
            String err = "JClass passed to constructor of ClassInfo must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._class = jClass;
        xmlNature.setGroupInfo(new GroupInfo());
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        fieldInfo.setDeclaringClassInfo(this);
        switch (new XMLInfoNature(fieldInfo).getNodeType()) {
            case ATTRIBUTE: {
                if (this._atts.contains(fieldInfo)) break;
                this._atts.addElement(fieldInfo);
                break;
            }
            case TEXT: {
                this._textField = fieldInfo;
                break;
            }
            default: {
                if (this._elements.contains(fieldInfo)) break;
                this._elements.addElement(fieldInfo);
            }
        }
    }

    public void addFieldInfo(FieldInfo[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.addFieldInfo(fields[i]);
        }
    }

    public boolean allowContent() {
        return this._textField != null;
    }

    public boolean contains(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return false;
        }
        switch (new XMLInfoNature(fieldInfo).getNodeType()) {
            case ATTRIBUTE: {
                if (this._atts == null) break;
                return this._atts.contains(fieldInfo);
            }
            case TEXT: {
                return fieldInfo == this._textField;
            }
            default: {
                if (this._elements == null) break;
                return this._elements.contains(fieldInfo);
            }
        }
        return false;
    }

    public FieldInfo[] getAttributeFields() {
        Object[] fields = null;
        if (this._atts != null) {
            fields = new FieldInfo[this._atts.size()];
            this._atts.copyInto(fields);
        } else {
            fields = new FieldInfo[]{};
        }
        return fields;
    }

    public FieldInfo getAttributeField(String nodeName) {
        if (this._atts == null) {
            return null;
        }
        for (int i = 0; i < this._atts.size(); ++i) {
            FieldInfo temp = (FieldInfo)this._atts.get(i);
            if (!new XMLInfoNature(temp).getNodeName().equals(nodeName)) continue;
            return temp;
        }
        return null;
    }

    public ClassInfo getBaseClass() {
        return this._baseClass;
    }

    public FieldInfo[] getElementFields() {
        Object[] members = null;
        if (this._elements != null) {
            members = new FieldInfo[this._elements.size()];
            this._elements.copyInto(members);
        } else {
            members = new FieldInfo[]{};
        }
        return members;
    }

    public FieldInfo getElementField(String nodeName) {
        if (this._elements != null) {
            for (int i = 0; i < this._elements.size(); ++i) {
                FieldInfo temp = (FieldInfo)this._elements.get(i);
                String elementNodeName = new XMLInfoNature(temp).getNodeName();
                if (elementNodeName == null || !elementNodeName.equals(nodeName)) continue;
                return temp;
            }
        }
        return null;
    }

    public int getFieldCount() {
        int count = 0;
        if (this._atts != null) {
            count += this._atts.size();
        }
        if (this._elements != null) {
            count += this._elements.size();
        }
        if (this._textField != null) {
            ++count;
        }
        return count;
    }

    public JClass getJClass() {
        return this._class;
    }

    public FieldInfo getTextField() {
        return this._textField;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean abstractClass) {
        this._abstract = abstractClass;
    }

    public void setBaseClass(ClassInfo base) {
        this._baseClass = base;
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public void addNature(String nature) {
        this._natures.add(nature);
    }

    public boolean hasNature(String nature) {
        return this._natures.contains(nature);
    }

    public Collection getAttributeFieldsAsCollection() {
        return this._atts;
    }

    public Collection getElementFieldsAsCollection() {
        return this._elements;
    }
}

