/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JStructure
extends JType
implements JAnnotatedElement {
    private static final String DEFAULT_HEADER = "$Id$";
    private static final String DEFAULT_VERSION = "$Revision$ $Date$";
    private static final String JSW_SHOULD_NOT_BE_NULL = "argument 'jsw' should not be null.";
    private JComment _header;
    private String _packageName;
    private Vector<String> _imports;
    private JDocComment _jdc;
    private JAnnotatedElementHelper _annotatedElement;
    private JModifiers _modifiers;
    private Vector<String> _interfaces;

    protected JStructure(String name) {
        super(name);
        if (!this.isValidClassName(name)) {
            String lname = this.getLocalName();
            String err = "'" + lname + "' is ";
            err = JNaming.isKeyword(lname) ? err + "a reserved word and may not be used as  a class name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this._header = null;
        this._packageName = JNaming.getPackageFromClassName(name);
        this._imports = new Vector();
        this._jdc = new JDocComment(JDocDescriptor.createVersionDesc(DEFAULT_VERSION));
        this._annotatedElement = new JAnnotatedElementHelper();
        this._modifiers = new JModifiers();
        this._interfaces = new Vector();
    }

    private boolean isValidClassName(String classname) {
        if (classname == null) {
            return false;
        }
        String name = classname;
        int beforeTypeName = name.indexOf("<");
        if (beforeTypeName > 0) {
            name = name.substring(0, beforeTypeName);
        }
        name = JNaming.getLocalNameFromClassName(name);
        return JNaming.isValidJavaIdentifier(name);
    }

    public final JComment getHeader() {
        return this._header;
    }

    public final void setHeader(JComment comment) {
        this._header = comment;
    }

    public final String getPackageName() {
        return this._packageName;
    }

    public final Enumeration<String> getImports() {
        return this._imports.elements();
    }

    public final int getImportCount() {
        return this._imports.size();
    }

    public final boolean hasImport(String classname) {
        return this._imports.contains(classname);
    }

    public abstract void addImport(String var1);

    protected final void addImportInternal(String className) {
        String pkgName = JNaming.getPackageFromClassName(className);
        if (pkgName != null) {
            if (pkgName.equals(this._packageName) || pkgName.equals("java.lang")) {
                return;
            }
            for (int i = 0; i < this._imports.size(); ++i) {
                String imp = this._imports.elementAt(i);
                if (imp.equals(className)) {
                    return;
                }
                if (imp.compareTo(className) <= 0) continue;
                this._imports.insertElementAt(className, i);
                return;
            }
            this._imports.addElement(className);
        }
    }

    protected final void addImport(JAnnotation annotation) {
        this.addImport(annotation.getAnnotationType().getName());
    }

    protected final void addImport(JAnnotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            this.addImport(annotations[i].getAnnotationType().getName());
        }
    }

    public final boolean removeImport(String className) {
        boolean result = false;
        if (className == null) {
            return result;
        }
        if (className.length() == 0) {
            return result;
        }
        result = this._imports.removeElement(className);
        return result;
    }

    public final JDocComment getJDocComment() {
        return this._jdc;
    }

    protected final JAnnotatedElementHelper getAnnotatedElementHelper() {
        return this._annotatedElement;
    }

    @Override
    public final boolean hasAnnotations() {
        return this._annotatedElement.hasAnnotations();
    }

    @Override
    public final JAnnotation[] getAnnotations() {
        return this._annotatedElement.getAnnotations();
    }

    @Override
    public final JAnnotation getAnnotation(JAnnotationType annotationType) {
        return this._annotatedElement.getAnnotation(annotationType);
    }

    @Override
    public final boolean isAnnotationPresent(JAnnotationType annotationType) {
        return this._annotatedElement.isAnnotationPresent(annotationType);
    }

    @Override
    public final void addAnnotation(JAnnotation annotation) {
        this._annotatedElement.addAnnotation(annotation);
        this.addImport(annotation);
    }

    @Override
    public final JAnnotation removeAnnotation(JAnnotationType annotationType) {
        return this._annotatedElement.removeAnnotation(annotationType);
    }

    public final JModifiers getModifiers() {
        return this._modifiers;
    }

    public final Enumeration<String> getInterfaces() {
        return this._interfaces.elements();
    }

    public final int getInterfaceCount() {
        return this._interfaces.size();
    }

    public final void addInterface(String interfaceName) {
        if (!this._interfaces.contains(interfaceName)) {
            this._interfaces.addElement(interfaceName);
        }
    }

    public abstract JField getField(String var1);

    public abstract JField[] getFields();

    public abstract void addField(JField var1);

    public abstract void addMember(JMember var1);

    public final String getFilename(String destDir) {
        File pathFile;
        String filename = this.getLocalName() + ".java";
        String javaPackagePath = "";
        if (this._packageName != null && this._packageName.length() > 0) {
            javaPackagePath = this._packageName.replace('.', File.separatorChar);
        }
        if (!(pathFile = destDir == null ? new File(javaPackagePath) : new File(destDir, javaPackagePath)).exists()) {
            pathFile.mkdirs();
        }
        if (pathFile.toString().length() > 0) {
            filename = pathFile.toString() + File.separator + filename;
        }
        return filename;
    }

    public final void print(String destDir, String lineSeparator) {
        String filename = this.getFilename(destDir);
        File file = new File(filename);
        JSourceWriter jsw = null;
        try {
            jsw = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException ioe) {
            System.out.println("unable to create class file: " + filename);
            return;
        }
        if (lineSeparator == null) {
            jsw.setLineSeparator(System.getProperty("line.separator"));
        } else {
            jsw.setLineSeparator(lineSeparator);
        }
        this.print(jsw);
        jsw.close();
    }

    public abstract void print(JSourceWriter var1);

    public final void printHeader(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        if (this._header != null) {
            this._header.print(jsw);
        } else {
            jsw.writeln("/*");
            jsw.writeln(" * $Id$");
            jsw.writeln(" */");
        }
        jsw.writeln();
        jsw.flush();
    }

    public final void printPackageDeclaration(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        if (this._packageName != null && this._packageName.length() > 0) {
            jsw.write("package ");
            jsw.write(this._packageName);
            jsw.writeln(';');
            jsw.writeln();
        }
        jsw.flush();
    }

    protected final void printImportDeclarations(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        if (this._imports.size() > 0) {
            jsw.writeln("  //---------------------------------/");
            jsw.writeln(" //- Imported classes and packages -/");
            jsw.writeln("//---------------------------------/");
            jsw.writeln();
            Enumeration<String> enumeration = this._imports.elements();
            while (enumeration.hasMoreElements()) {
                jsw.write("import ");
                jsw.write(enumeration.nextElement());
                jsw.writeln(';');
            }
            jsw.writeln();
            jsw.flush();
        }
    }

    public final String toString() {
        return this.getName();
    }
}

