/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.apache.commons.lang.StringUtils;
import org.castor.xml.JavaNaming;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.nature.SolrjFieldInfoNature;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class FieldMemberAndAccessorFactory {
    private JavaNaming javaNaming;
    private boolean useOldFieldNaming;

    public FieldMemberAndAccessorFactory(JavaNaming javaNaming) {
        this(javaNaming, false);
    }

    public FieldMemberAndAccessorFactory(JavaNaming javaNaming, boolean useOldFieldNaming) {
        this.javaNaming = javaNaming;
        this.useOldFieldNaming = useOldFieldNaming;
    }

    public void generateInitializerCode(FieldInfo fieldInfo, JSourceCode jsc) {
        XMLInfoNature xmlNature = new XMLInfoNature(fieldInfo);
        if (!xmlNature.getSchemaType().isPrimitive()) {
            String value = fieldInfo.getDefaultValue();
            boolean dateTime = xmlNature.getSchemaType().isDateTime();
            if (value == null) {
                value = fieldInfo.getFixedValue();
            }
            if (value != null) {
                StringBuilder buffer = new StringBuilder(50);
                if (dateTime) {
                    jsc.add("try {");
                    jsc.indent();
                }
                buffer.append(fieldInfo.getWriteMethodName());
                buffer.append('(');
                buffer.append(value);
                buffer.append(");");
                jsc.add(buffer.toString());
                if (dateTime) {
                    jsc.unindent();
                    jsc.add("} catch (java.text.ParseException pe) {");
                    jsc.indent();
                    jsc.add("throw new IllegalStateException(pe.getMessage());");
                    jsc.unindent();
                    jsc.add("}");
                }
            }
        }
    }

    public final void createJavaField(FieldInfo fieldInfo, JClass jClass) {
        JModifiers modifiers;
        XMLInfoNature xmlNature = new XMLInfoNature(fieldInfo);
        XSType type = xmlNature.getSchemaType();
        JType jType = type.getJType();
        JField field = null;
        field = this.useOldFieldNaming() ? new JField(type.getJType(), fieldInfo.getName()) : new JField(type.getJType(), fieldInfo.getName(), null);
        if (xmlNature.getSchemaType().isDateTime()) {
            field.setDateTime(true);
        }
        if (fieldInfo.isStatic() || fieldInfo.isFinal()) {
            modifiers = field.getModifiers();
            modifiers.setFinal(fieldInfo.isFinal());
            modifiers.setStatic(fieldInfo.isStatic());
        }
        if (!fieldInfo.getVisibility().equals("private")) {
            modifiers = field.getModifiers();
            if (fieldInfo.getVisibility().equals("protected")) {
                modifiers.makeProtected();
            } else if (fieldInfo.getVisibility().equals("public")) {
                modifiers.makePublic();
            }
        }
        if (fieldInfo.getDefaultValue() != null && !xmlNature.isMultivalued()) {
            field.setInitString(fieldInfo.getDefaultValue());
        }
        if (fieldInfo.getFixedValue() != null && !xmlNature.getSchemaType().isDateTime()) {
            field.setInitString(fieldInfo.getFixedValue());
        }
        if (fieldInfo.getComment() != null) {
            field.setComment(fieldInfo.getComment());
        }
        if (fieldInfo.hasNature(SolrjFieldInfoNature.class.getName())) {
            SolrjFieldInfoNature solrjNature = new SolrjFieldInfoNature(fieldInfo);
            JAnnotationType annotationType = null;
            if (solrjNature.isIdDefinition()) {
                annotationType = new JAnnotationType("org.apache.solr.client.solrj.beans.Id");
                jClass.addImport("org.apache.solr.client.solrj.beans.Id");
            } else {
                annotationType = new JAnnotationType("org.apache.solr.client.solrj.beans.Field");
                jClass.addImport("org.apache.solr.client.solrj.beans.Field");
            }
            JAnnotation annotation = new JAnnotation(annotationType);
            field.addAnnotation(annotation);
            String fieldName = solrjNature.getFieldName();
            if (StringUtils.isNotBlank((String)fieldName)) {
                annotation.setValue("\"" + fieldName + "\"");
            }
        }
        jClass.addField(field);
        if (!type.isEnumerated() && jType.isPrimitive()) {
            field = this.useOldFieldNaming() ? new JField(JType.BOOLEAN, "_has" + fieldInfo.getName()) : new JField(JType.BOOLEAN, "has" + fieldInfo.getName());
            field.setComment("Keeps track of whether primitive field " + fieldInfo.getName() + " has been set already.");
            jClass.addField(field);
        }
    }

    public void createAccessMethods(FieldInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        if ((fieldInfo.getMethods() & 1) > 0) {
            this.createGetterMethod(fieldInfo, jClass, useJava50, annotationBuilders);
        }
        if ((fieldInfo.getMethods() & 2) > 0) {
            this.createSetterMethod(fieldInfo, jClass, useJava50);
        }
        if (fieldInfo.requiresHasAndDeleteMethods()) {
            this.createHasAndDeleteMethods(fieldInfo, jClass);
        }
    }

    private void createGetterComment(FieldInfo fieldInfo, JDocComment jDocComment) {
        String fieldName = fieldInfo.getName();
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String mComment = "Returns the value of field '" + fieldName + "'.";
        if (fieldInfo.getComment() != null && fieldInfo.getComment().length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (fieldInfo.getComment().startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + fieldInfo.getComment();
        }
        jDocComment.setComment(mComment);
    }

    private void createGetterMethod(FieldInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = new XMLInfoNature(fieldInfo).getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(fieldInfo.getReadMethodName(), jType, "the value of field '" + mname + "'.");
        for (int i = 0; i < annotationBuilders.length; ++i) {
            AnnotationBuilder annotationBuilder = annotationBuilders[i];
            annotationBuilder.addFieldGetterAnnotations(fieldInfo, method);
        }
        jClass.addMethod(method);
        this.createGetterComment(fieldInfo, method.getJDocComment());
        jsc = method.getSourceCode();
        jsc.add("return this.");
        jsc.append(fieldInfo.getName());
        jsc.append(";");
        if (xsType.getType() == 11) {
            method = new JMethod(fieldInfo.getIsMethodName(), jType, "the value of field '" + mname + "'.");
            jClass.addMethod(method);
            this.createGetterComment(fieldInfo, method.getJDocComment());
            jsc = method.getSourceCode();
            jsc.add("return this.");
            jsc.append(fieldInfo.getName());
            jsc.append(";");
        }
    }

    private void createHasAndDeleteMethods(FieldInfo fieldInfo, JClass jClass) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = new XMLInfoNature(fieldInfo).getSchemaType();
        xsType.getJType();
        method = new JMethod(fieldInfo.getHasMethodName(), JType.BOOLEAN, "true if at least one " + mname + " has been added");
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("return this.");
        if (this.useOldFieldNaming()) {
            jsc.append("_");
        }
        jsc.append("has");
        String fieldName = fieldInfo.getName();
        jsc.append(fieldName);
        jsc.append(";");
        method = new JMethod(fieldInfo.getDeleteMethodName());
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("this.");
        if (this.useOldFieldNaming()) {
            jsc.append("_");
        }
        jsc.append("has");
        jsc.append(fieldName);
        jsc.append("= false;");
        if (fieldInfo.isBound()) {
            jsc.add("notifyPropertyChangeListeners(\"");
            if (fieldName.startsWith("_")) {
                jsc.append(fieldName.substring(1));
            } else {
                jsc.append(fieldName);
            }
            jsc.append("\", ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(", null");
            jsc.append(");");
        }
    }

    private void createSetterComment(FieldInfo fieldInfo, JDocComment jDocComment) {
        String fieldName = fieldInfo.getName();
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String atParam = "the value of field '" + fieldName + "'.";
        String mComment = "Sets " + atParam;
        if (fieldInfo.getComment() != null && fieldInfo.getComment().length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (fieldInfo.getComment().startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + fieldInfo.getComment();
        }
        jDocComment.setComment(mComment);
        JDocDescriptor paramDesc = jDocComment.getParamDescriptor(fieldName);
        if (paramDesc == null) {
            paramDesc = JDocDescriptor.createParamDesc(fieldName, null);
            jDocComment.addDescriptor(paramDesc);
        }
        paramDesc.setDescription(atParam);
    }

    private void createSetterMethod(FieldInfo fieldInfo, JClass jClass, boolean useJava50) {
        String tempName;
        JMethod method = null;
        JSourceCode jsc = null;
        XMLInfoNature xmlNature = new XMLInfoNature(fieldInfo);
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = xmlNature.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(fieldInfo.getWriteMethodName());
        jClass.addMethod(method);
        String paramName = fieldInfo.getName();
        if (paramName.indexOf(95) == 0 && this.javaNaming.isValidJavaIdentifier(tempName = paramName.substring(1))) {
            paramName = tempName;
        }
        method.addParameter(new JParameter(jType, paramName));
        this.createSetterComment(fieldInfo, method.getJDocComment());
        jsc = method.getSourceCode();
        String fieldName = fieldInfo.getName();
        if (fieldInfo.isBound()) {
            jsc.add("java.lang.Object old");
            jsc.append(mname);
            jsc.append(" = ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(";");
        }
        jsc.add("this.");
        jsc.append(fieldName);
        jsc.append(" = ");
        jsc.append(paramName);
        jsc.append(";");
        if (fieldInfo.getFieldInfoReference() != null) {
            jsc.add("this.");
            jsc.append(fieldInfo.getFieldInfoReference().getName());
            jsc.append(" = ");
            JType referencedJType = new XMLInfoNature(fieldInfo.getFieldInfoReference()).getSchemaType().getJType();
            if (referencedJType.isPrimitive()) {
                jsc.append(paramName);
            } else if (jType.isPrimitive()) {
                JPrimitiveType primitive = (JPrimitiveType)jType;
                jsc.append("new ");
                jsc.append(primitive.getWrapperName());
                jsc.append("(");
                jsc.append(paramName);
                jsc.append(")");
            } else {
                jsc.append(paramName);
            }
            jsc.append(";");
        }
        if (fieldInfo.requiresHasAndDeleteMethods()) {
            jsc.add("this.");
            if (this.useOldFieldNaming()) {
                jsc.append("_");
            }
            jsc.append("has");
            jsc.append(fieldName);
            jsc.append(" = true;");
        }
        if (fieldInfo.isBound()) {
            jsc.add("notifyPropertyChangeListeners(\"");
            if (fieldName.startsWith("_")) {
                jsc.append(fieldName.substring(1));
            } else {
                jsc.append(fieldName);
            }
            jsc.append("\", old");
            jsc.append(mname);
            jsc.append(", ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(");");
        }
    }

    public JavaNaming getJavaNaming() {
        return this.javaNaming;
    }

    public void setUseOldFieldNaming(boolean useOldFieldNaming) {
        this.useOldFieldNaming = useOldFieldNaming;
    }

    private boolean useOldFieldNaming() {
        return this.useOldFieldNaming;
    }
}

