/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.printing;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.exolab.castor.builder.printing.JClassPrinter;
import org.exolab.castor.builder.printing.TemplateHelper;
import org.exolab.javasource.JClass;

public class TemplateJClassPrinter
implements JClassPrinter {
    public static final String TEMPLATE_PACKAGE = "/org/exolab/castor/builder/printing/templates/";
    private static final Log _log = LogFactory.getLog(TemplateJClassPrinter.class);
    private boolean _initialized = false;

    private void initializeVelocity() {
        Velocity.setProperty((String)"velocimacro.permissions.allowInline", (Object)"true");
        Velocity.setProperty((String)"velocimacro.library", (Object)"/org/exolab/castor/builder/printing/templates/library.vm");
        Velocity.setProperty((String)"resource.loader", (Object)"classPathResource");
        Velocity.setProperty((String)"classPathResource.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            Velocity.init();
        }
        catch (Exception e) {
            System.out.println("init fails!");
            e.printStackTrace();
        }
    }

    public void printClass(JClass jClass, String outputDir, String lineSeparator, String header) {
        if (!this._initialized) {
            this.initializeVelocity();
            this._initialized = true;
        }
        _log.info((Object)("Printing JClass " + jClass.getName() + " using Velocity templates."));
        try {
            VelocityContext context = new VelocityContext();
            context.put("jClass", (Object)jClass);
            context.put("helper", (Object)new TemplateHelper());
            context.put("version", (Object)"1.3.3-RC1");
            Template template = Velocity.getTemplate((String)"/org/exolab/castor/builder/printing/templates/main.vm");
            FileWriter fileWriter = new FileWriter(new File(jClass.getFilename(outputDir)));
            template.merge((Context)context, (Writer)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

