/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCompUnit {
    private static final int INITIAL_STRING_BUILDER_SIZE = 32;
    private static final String DEFAULT_HEADER = "$Id$";
    private static final String[] PUBLIC_HEADER = new String[]{"  //-----------------------------/", " //-  Public Class / Interface -/", "//-----------------------------/"};
    private static final String[] NON_PUBLIC_HEADER = new String[]{"  //-------------------------------------/", " //-  Non-Public Classes / Interfaces  -/", "//-------------------------------------/"};
    private JComment _header = null;
    private String _packageName = null;
    private String _fileName = null;
    private Vector<JClass> _classes = new Vector();
    private Vector<JInterface> _interfaces = new Vector();

    public JCompUnit(String packageName, String fileName) {
        this._packageName = packageName;
        this._fileName = fileName;
    }

    public JCompUnit(JClass jClass) {
        this._packageName = jClass.getPackageName();
        String filePrefix = jClass.getLocalName();
        this._fileName = filePrefix + ".java";
        this._classes.add(jClass);
    }

    public JCompUnit(JInterface jInterface) {
        this._packageName = jInterface.getPackageName();
        this._fileName = jInterface.getLocalName() + ".java";
        this._interfaces.add(jInterface);
    }

    public void setHeader(JComment comment) {
        this._header = comment;
    }

    public void addStructure(JStructure jStructure) {
        if (jStructure instanceof JInterface) {
            this.addInterface((JInterface)jStructure);
        } else if (jStructure instanceof JClass) {
            this.addClass((JClass)jStructure);
        } else {
            String err = "Unknown JStructure subclass '" + jStructure.getClass().getName() + "'.";
            throw new IllegalArgumentException(err);
        }
    }

    public void addClass(JClass jClass) {
        this._classes.add(jClass);
    }

    public void addInterface(JInterface jInterface) {
        this._interfaces.add(jInterface);
    }

    public SortedSet<String> getImports() {
        Enumeration<String> enumeration;
        int i;
        TreeSet<String> allImports = new TreeSet<String>();
        for (i = 0; i < this._classes.size(); ++i) {
            JClass jClass = this._classes.get(i);
            enumeration = jClass.getImports();
            while (enumeration.hasMoreElements()) {
                allImports.add(enumeration.nextElement());
            }
        }
        for (i = 0; i < this._interfaces.size(); ++i) {
            JInterface jInterface = this._interfaces.get(i);
            enumeration = jInterface.getImports();
            while (enumeration.hasMoreElements()) {
                allImports.add(enumeration.nextElement());
            }
        }
        return allImports;
    }

    public String getFilename(String destDir) {
        File pathFile;
        String filename = new String(this._fileName);
        String javaPackagePath = "";
        if (this._packageName != null && this._packageName.length() > 0) {
            javaPackagePath = this._packageName.replace('.', File.separatorChar);
        }
        if (!(pathFile = destDir == null ? new File(javaPackagePath) : new File(destDir, javaPackagePath)).exists()) {
            pathFile.mkdirs();
        }
        if (pathFile.toString().length() > 0) {
            filename = pathFile.toString() + File.separator + filename;
        }
        return filename;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String destDir) {
        this.print(destDir, null);
    }

    public void print(String destDir, String lineSeparator) {
        String filename = this.getFilename(destDir);
        File file = new File(filename);
        JSourceWriter jsw = null;
        try {
            jsw = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException ioe) {
            System.out.println("unable to create compilation unit file: " + filename);
            return;
        }
        if (lineSeparator == null) {
            jsw.setLineSeparator(System.getProperty("line.separator"));
        } else {
            jsw.setLineSeparator(lineSeparator);
        }
        this.print(jsw);
        jsw.flush();
        jsw.close();
    }

    public void print(JSourceWriter jsw) {
        StringBuilder buffer = new StringBuilder(32);
        if (this._header != null) {
            this._header.print(jsw);
        } else {
            jsw.writeln("/*");
            jsw.writeln(" * $Id$");
            jsw.writeln("*/");
        }
        jsw.writeln();
        jsw.flush();
        if (this._packageName != null && this._packageName.length() > 0) {
            buffer.setLength(0);
            buffer.append("package ");
            buffer.append(this._packageName);
            buffer.append(';');
            jsw.writeln(buffer.toString());
            jsw.writeln();
        }
        jsw.writeln("  //---------------------------------------------/");
        jsw.writeln(" //- Imported classes, interfaces and packages -/");
        jsw.writeln("//---------------------------------------------/");
        jsw.writeln();
        SortedSet<String> allImports = this.getImports();
        String compUnitPackage = this.getPackageName();
        for (String importName : allImports) {
            String importsPackage = JNaming.getPackageFromClassName(importName);
            if (importsPackage == null || importsPackage.equals(compUnitPackage)) continue;
            jsw.write("import ");
            jsw.write(importName);
            jsw.writeln(';');
        }
        jsw.writeln();
        this.printStructures(jsw, true);
        this.printStructures(jsw, false);
        jsw.flush();
    }

    public void printStructures(JSourceWriter jsw, boolean printPublic) {
        int j;
        String[] header;
        boolean isFirst = true;
        for (JInterface jInterface : this._interfaces) {
            if (jInterface.getModifiers().isPublic() != printPublic) continue;
            if (isFirst) {
                header = printPublic ? PUBLIC_HEADER : NON_PUBLIC_HEADER;
                for (j = 0; j < header.length; ++j) {
                    jsw.writeln(header[j]);
                }
                jsw.writeln();
                isFirst = false;
            }
            jInterface.print(jsw, true);
            jsw.writeln();
        }
        for (JClass jClass : this._classes) {
            if (jClass.getModifiers().isPublic() != printPublic) continue;
            if (isFirst) {
                header = printPublic ? PUBLIC_HEADER : NON_PUBLIC_HEADER;
                for (j = 0; j < header.length; ++j) {
                    jsw.writeln(header[j]);
                }
                jsw.writeln();
                isFirst = false;
            }
            jClass.print(jsw, true);
            jsw.writeln();
        }
    }
}

