/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JEnumConstant;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JSourceWriter;

public final class JEnum
extends JClass {
    private Map<String, JEnumConstant> _enumConstants = new LinkedHashMap<String, JEnumConstant>();

    public JEnum(String name) {
        super(name);
        this.getJDocComment().setComment("Enumeration " + this.getLocalName() + ".");
    }

    public void addConstructor(JConstructor constructor) {
        if (constructor.getModifiers().isPrivate()) {
            super.addConstructor(constructor);
        }
    }

    public void addMember(JMember jMember) {
        if (jMember instanceof JEnumConstant) {
            this.addEnumConstant((JEnumConstant)jMember);
        } else {
            super.addMember(jMember);
        }
    }

    public void addEnumConstant(JEnumConstant jEnumConstant) {
        if (jEnumConstant == null) {
            throw new IllegalArgumentException("Enum fields cannot be null");
        }
        String name = jEnumConstant.getName();
        if (this._enumConstants.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._enumConstants.put(name, jEnumConstant);
    }

    public JEnumConstant getEnumConstant(String name) {
        return this._enumConstants.get(name);
    }

    public JEnumConstant[] getEnumConstants() {
        return this._enumConstants.values().toArray(new JEnumConstant[this._enumConstants.size()]);
    }

    public int getEnumConstantCount() {
        return this._enumConstants.size();
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (!classOnly) {
            this.printClassHeaders(jsw);
        }
        this.getJDocComment().print(jsw);
        this.printEnumDefinitionLine(jsw);
        jsw.writeln();
        jsw.indent();
        this.printEnumConstants(jsw);
        this.printMemberVariables(jsw);
        this.printStaticInitializers(jsw);
        this.printConstructors(jsw);
        this.printMethods(jsw);
        this.printInnerClasses(jsw);
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    private void printEnumDefinitionLine(JSourceWriter jsw) {
        StringBuilder buffer = new StringBuilder();
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("enum ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            boolean endl = false;
            if (this.getInterfaceCount() > 1) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("implements ");
            Enumeration<String> enumeration = this.getInterfaces();
            while (enumeration.hasMoreElements()) {
                buffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
    }

    private void printEnumConstants(JSourceWriter jsw) {
        if (!this._enumConstants.isEmpty()) {
            jsw.writeln();
            jsw.writeln("  //------------------/");
            jsw.writeln(" //- Enum Constants -/");
            jsw.writeln("//------------------/");
            jsw.writeln();
        }
        int i = 0;
        for (JEnumConstant jConstant : this._enumConstants.values()) {
            jConstant.print(jsw);
            if (++i < this._enumConstants.size()) {
                jsw.write(",");
            } else {
                jsw.write(";");
            }
            jsw.writeln();
        }
    }
}

