/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.castor.xml.JavaNaming;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;
import org.exolab.javasource.Java5HacksHelper;

public class FieldMemberAndAccessorFactory {
    private JavaNaming _javaNaming;

    public FieldMemberAndAccessorFactory(JavaNaming naming) {
        this._javaNaming = naming;
    }

    public void generateInitializerCode(FieldInfo fieldInfo, JSourceCode jsc) {
        if (!fieldInfo.getSchemaType().isPrimitive()) {
            String value = fieldInfo.getDefaultValue();
            boolean dateTime = fieldInfo.getSchemaType().isDateTime();
            if (value == null) {
                value = fieldInfo.getFixedValue();
            }
            if (value != null) {
                StringBuffer buffer = new StringBuffer(50);
                if (dateTime) {
                    jsc.add("try {");
                    jsc.indent();
                }
                buffer.append("set");
                buffer.append(fieldInfo.getMethodSuffix());
                buffer.append('(');
                buffer.append(value);
                buffer.append(");");
                jsc.add(buffer.toString());
                if (dateTime) {
                    jsc.unindent();
                    jsc.add("} catch (java.text.ParseException pe) {");
                    jsc.indent();
                    jsc.add("throw new IllegalStateException(pe.getMessage());");
                    jsc.unindent();
                    jsc.add("}");
                }
            }
        }
    }

    public final void createJavaField(FieldInfo fieldInfo, JClass jClass) {
        JModifiers modifiers;
        XSType type = fieldInfo.getSchemaType();
        JType jType = type.getJType();
        JField field = new JField(type.getJType(), fieldInfo.getName());
        if (fieldInfo.getSchemaType().isDateTime()) {
            field.setDateTime(true);
        }
        if (fieldInfo.isStatic() || fieldInfo.isFinal()) {
            modifiers = field.getModifiers();
            modifiers.setFinal(fieldInfo.isFinal());
            modifiers.setStatic(fieldInfo.isStatic());
        }
        if (!fieldInfo.getVisibility().equals("private")) {
            modifiers = field.getModifiers();
            if (fieldInfo.getVisibility().equals("protected")) {
                modifiers.makeProtected();
            } else if (fieldInfo.getVisibility().equals("public")) {
                modifiers.makePublic();
            }
        }
        if (fieldInfo.getDefaultValue() != null) {
            field.setInitString(fieldInfo.getDefaultValue());
        }
        if (fieldInfo.getFixedValue() != null && !fieldInfo.getSchemaType().isDateTime()) {
            field.setInitString(fieldInfo.getFixedValue());
        }
        if (fieldInfo.getComment() != null) {
            field.setComment(fieldInfo.getComment());
        }
        jClass.addField(field);
        if (!type.isEnumerated() && jType.isPrimitive()) {
            field = new JField(JType.BOOLEAN, "_has" + fieldInfo.getName());
            field.setComment("keeps track of state for field: " + fieldInfo.getName());
            jClass.addField(field);
        }
    }

    public void createAccessMethods(FieldInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        if ((fieldInfo.getMethods() & 1) > 0) {
            this.createGetterMethod(fieldInfo, jClass, useJava50, annotationBuilders);
        }
        if ((fieldInfo.getMethods() & 2) > 0) {
            this.createSetterMethod(fieldInfo, jClass, useJava50);
        }
        if (fieldInfo.isHasAndDeleteMethods()) {
            this.createHasAndDeleteMethods(fieldInfo, jClass);
        }
    }

    private void createGetterComment(FieldInfo fieldInfo, JDocComment jDocComment) {
        String fieldName = fieldInfo.getName();
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String mComment = "Returns the value of field '" + fieldName + "'.";
        if (fieldInfo.getComment() != null && fieldInfo.getComment().length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (fieldInfo.getComment().startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + fieldInfo.getComment();
        }
        jDocComment.setComment(mComment);
    }

    private void createGetterMethod(FieldInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = fieldInfo.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod("get" + mname, jType, "the value of field '" + mname + "'.");
        if (useJava50) {
            Java5HacksHelper.addOverrideAnnotations(method.getSignature());
        }
        for (int i = 0; i < annotationBuilders.length; ++i) {
            AnnotationBuilder annotationBuilder = annotationBuilders[i];
            annotationBuilder.addFieldGetterAnnotations(fieldInfo, method);
        }
        jClass.addMethod(method);
        this.createGetterComment(fieldInfo, method.getJDocComment());
        jsc = method.getSourceCode();
        jsc.add("return this.");
        jsc.append(fieldInfo.getName());
        jsc.append(";");
        if (xsType.getType() == 11) {
            method = new JMethod("is" + mname, jType, "the value of field '" + mname + "'.");
            if (useJava50) {
                Java5HacksHelper.addOverrideAnnotations(method.getSignature());
            }
            jClass.addMethod(method);
            this.createGetterComment(fieldInfo, method.getJDocComment());
            jsc = method.getSourceCode();
            jsc.add("return this.");
            jsc.append(fieldInfo.getName());
            jsc.append(";");
        }
    }

    private void createHasAndDeleteMethods(FieldInfo fieldInfo, JClass jClass) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = fieldInfo.getSchemaType();
        xsType.getJType();
        method = new JMethod("has" + mname, JType.BOOLEAN, "true if at least one " + mname + " has been added");
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("return this._has");
        String fieldName = fieldInfo.getName();
        jsc.append(fieldName);
        jsc.append(";");
        method = new JMethod("delete" + mname);
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("this._has");
        jsc.append(fieldName);
        jsc.append("= false;");
        if (fieldInfo.isBound()) {
            jsc.add("notifyPropertyChangeListeners(\"");
            if (fieldName.startsWith("_")) {
                jsc.append(fieldName.substring(1));
            } else {
                jsc.append(fieldName);
            }
            jsc.append("\", ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(", null");
            jsc.append(");");
        }
    }

    private void createSetterComment(FieldInfo fieldInfo, JDocComment jDocComment) {
        String fieldName = fieldInfo.getName();
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String atParam = "the value of field '" + fieldName + "'.";
        String mComment = "Sets " + atParam;
        if (fieldInfo.getComment() != null && fieldInfo.getComment().length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (fieldInfo.getComment().startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + fieldInfo.getComment();
        }
        jDocComment.setComment(mComment);
        JDocDescriptor paramDesc = jDocComment.getParamDescriptor(fieldName);
        if (paramDesc == null) {
            paramDesc = JDocDescriptor.createParamDesc(fieldName, null);
            jDocComment.addDescriptor(paramDesc);
        }
        paramDesc.setDescription(atParam);
    }

    private void createSetterMethod(FieldInfo fieldInfo, JClass jClass, boolean useJava50) {
        String tempName;
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = fieldInfo.getMethodSuffix();
        XSType xsType = fieldInfo.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod("set" + mname);
        jClass.addMethod(method);
        String paramName = fieldInfo.getName();
        if (paramName.indexOf(95) == 0 && this._javaNaming.isValidJavaIdentifier(tempName = paramName.substring(1))) {
            paramName = tempName;
        }
        method.addParameter(new JParameter(jType, paramName));
        if (useJava50) {
            Java5HacksHelper.addOverrideAnnotations(method.getSignature());
        }
        this.createSetterComment(fieldInfo, method.getJDocComment());
        jsc = method.getSourceCode();
        String fieldName = fieldInfo.getName();
        if (fieldInfo.isBound()) {
            jsc.add("java.lang.Object old");
            jsc.append(mname);
            jsc.append(" = ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(";");
        }
        jsc.add("this.");
        jsc.append(fieldName);
        jsc.append(" = ");
        jsc.append(paramName);
        jsc.append(";");
        if (fieldInfo.getFieldInfoReference() != null) {
            jsc.add("this.");
            jsc.append(fieldInfo.getFieldInfoReference().getName());
            jsc.append(" = ");
            JType referencedJType = fieldInfo.getFieldInfoReference().getSchemaType().getJType();
            if (referencedJType.isPrimitive()) {
                jsc.append(paramName);
            } else if (jType.isPrimitive()) {
                JPrimitiveType primitive = (JPrimitiveType)jType;
                jsc.append("new ");
                jsc.append(primitive.getWrapperName());
                jsc.append("(");
                jsc.append(paramName);
                jsc.append(")");
            } else {
                jsc.append(paramName);
            }
            jsc.append(";");
        }
        if (fieldInfo.isHasAndDeleteMethods()) {
            jsc.add("this._has");
            jsc.append(fieldName);
            jsc.append(" = true;");
        }
        if (fieldInfo.isBound()) {
            jsc.add("notifyPropertyChangeListeners(\"");
            if (fieldName.startsWith("_")) {
                jsc.append(fieldName.substring(1));
            } else {
                jsc.append(fieldName);
            }
            jsc.append("\", old");
            jsc.append(mname);
            jsc.append(", ");
            jsc.append(xsType.createToJavaObjectCode("this." + fieldName));
            jsc.append(");");
        }
    }

    public JavaNaming getJavaNaming() {
        return this._javaNaming;
    }
}

