/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import java.security.InvalidParameterException;
import org.castor.xml.JavaNaming;
import org.castor.xml.JavaNamingImpl;
import org.exolab.castor.builder.factory.CollectionJ2MemberAndAccessorFactory;
import org.exolab.castor.builder.factory.CollectionJ2NoIndexMemberAndAccessorFactory;
import org.exolab.castor.builder.factory.CollectionMemberAndAccessorFactory;
import org.exolab.castor.builder.factory.CollectionODMG30MemberAndAccessorFactory;
import org.exolab.castor.builder.factory.FieldMemberAndAccessorFactory;
import org.exolab.castor.builder.factory.IdentityMemberAndAccessorFactory;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.CollectionInfoJ2;
import org.exolab.castor.builder.info.CollectionInfoJ2Collection;
import org.exolab.castor.builder.info.CollectionInfoJ2Set;
import org.exolab.castor.builder.info.CollectionInfoJ2SortedSet;
import org.exolab.castor.builder.info.CollectionInfoODMG30;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.IdentityInfo;
import org.exolab.castor.builder.types.XSType;

public class FieldInfoFactory {
    private String _default = null;
    private boolean _extraMethods = false;
    private String _referenceSuffix = null;
    private boolean _bound = false;
    private FieldMemberAndAccessorFactory fieldMemberAndAccessorFactory;
    private CollectionMemberAndAccessorFactory collectionMemberAndAccessorFactory;
    private CollectionJ2MemberAndAccessorFactory collectionJ2MemberAndAccessorFactory;
    private CollectionJ2NoIndexMemberAndAccessorFactory collectionJ2NoIndexMemberAndAccessorFactory;
    private CollectionODMG30MemberAndAccessorFactory collectionODMG30MemberAndAccessorFactory;
    private IdentityMemberAndAccessorFactory identityMemberAndAccessorFactory;
    private JavaNaming _javaNaming;

    public FieldInfoFactory() {
        this("vector");
    }

    public FieldInfoFactory(String collectionName) {
        if (!(collectionName.equals("vector") || collectionName.equals("arraylist") || collectionName.equals("odmg"))) {
            throw new IllegalArgumentException(collectionName + " is currently not a supported Java collection.");
        }
        this._default = collectionName;
        this._javaNaming = new JavaNamingImpl();
        this.fieldMemberAndAccessorFactory = new FieldMemberAndAccessorFactory(this._javaNaming);
        this.collectionMemberAndAccessorFactory = new CollectionMemberAndAccessorFactory(this._javaNaming);
        this.collectionJ2MemberAndAccessorFactory = new CollectionJ2MemberAndAccessorFactory(this._javaNaming);
        this.collectionJ2NoIndexMemberAndAccessorFactory = new CollectionJ2NoIndexMemberAndAccessorFactory(this._javaNaming);
        this.collectionODMG30MemberAndAccessorFactory = new CollectionODMG30MemberAndAccessorFactory(this._javaNaming);
        this.identityMemberAndAccessorFactory = new IdentityMemberAndAccessorFactory(this._javaNaming);
    }

    public IdentityInfo createIdentity(String name) {
        IdentityInfo idInfo = new IdentityInfo(name, this.identityMemberAndAccessorFactory);
        if (this._bound) {
            idInfo.setBound(this._bound);
        }
        return idInfo;
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName, JavaNaming javaNaming, boolean usejava50) {
        return this.createCollection(contentType, name, elementName, this._default, javaNaming, usejava50);
    }

    /*
     * WARNING - void declaration
     */
    public CollectionInfo createCollection(XSType contentType, String name, String elementName, String collectionName, JavaNaming javaNaming, boolean useJava50) {
        void var8_8;
        CollectionInfo cInfo;
        String temp = collectionName;
        if (temp == null || temp.length() == 0) {
            temp = this._default;
        }
        if (temp.equalsIgnoreCase("vector")) {
            cInfo = new CollectionInfo(contentType, name, elementName, useJava50, this.collectionMemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else if (temp.equalsIgnoreCase("arraylist")) {
            cInfo = new CollectionInfoJ2(contentType, name, elementName, "arraylist", useJava50, this.collectionJ2MemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else if (temp.equalsIgnoreCase("odmg")) {
            cInfo = new CollectionInfoODMG30(contentType, name, elementName, useJava50, this.collectionODMG30MemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else if (temp.equalsIgnoreCase("collection")) {
            cInfo = new CollectionInfoJ2Collection(contentType, name, elementName, useJava50, this.collectionJ2NoIndexMemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else if (temp.equalsIgnoreCase("set")) {
            cInfo = new CollectionInfoJ2Set(contentType, name, elementName, useJava50, this.collectionJ2NoIndexMemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else if (temp.equalsIgnoreCase("sortedset")) {
            cInfo = new CollectionInfoJ2SortedSet(contentType, name, elementName, useJava50, this.collectionJ2NoIndexMemberAndAccessorFactory, this.fieldMemberAndAccessorFactory);
        } else {
            throw new InvalidParameterException("Unrecognized collection type: " + temp);
        }
        var8_8.setCreateExtraMethods(this._extraMethods);
        if (this._referenceSuffix != null) {
            var8_8.setReferenceMethodSuffix(this._referenceSuffix);
        }
        if (this._bound) {
            var8_8.setBound(true);
        }
        return var8_8;
    }

    public FieldInfo createFieldInfo(XSType type, String name) {
        FieldInfo fieldInfo = new FieldInfo(type, name, this.fieldMemberAndAccessorFactory);
        if (this._bound) {
            fieldInfo.setBound(true);
        }
        return fieldInfo;
    }

    public final void setBoundProperties(boolean bound) {
        this._bound = bound;
    }

    public final void setCreateExtraMethods(boolean extraMethods) {
        this._extraMethods = extraMethods;
    }

    public final void setReferenceMethodSuffix(String suffix) {
        this._referenceSuffix = suffix;
    }
}

