/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.util.ClassInfoResolverImpl;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.util.dialog.Dialog;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.javasource.JClass;

public final class SGStateInfo
extends ClassInfoResolverImpl {
    private static final Enumeration EMPTY_ENUMERATION = new Vector(0).elements();
    public static final int NORMAL_STATUS = 0;
    public static final int STOP_STATUS = 1;
    private Hashtable _mappings = null;
    private Hashtable _packageListings = null;
    private String _packageName;
    private Vector _processed = null;
    private boolean _promptForOverwrite = true;
    private Schema _schema = null;
    private boolean _suppressNonFatalWarnings = false;
    private boolean _verbose = false;
    private FactoryState _currentFactoryState = null;
    private Dialog _dialog = null;
    private SourceGenerator _sgen = null;
    private int _status = 0;
    private Map _sourcesByComponent = new HashMap();
    private Map _sourcesByName = new HashMap();
    private Map _importedSourcesByName = new HashMap();

    protected SGStateInfo(Schema schema, SourceGenerator sgen) {
        this._schema = schema;
        this._packageName = "";
        this._processed = new Vector();
        this._dialog = new ConsoleDialog();
        this._sgen = sgen;
    }

    protected String getPackageName() {
        return this._packageName;
    }

    protected void setPackageName(String packageName) {
        this._packageName = packageName;
    }

    public void bindSourceCode(Annotated annotated, JClass[] classes) {
        this._sourcesByComponent.put(annotated, classes);
        for (int i = 0; i < classes.length; ++i) {
            JClass jClass = classes[i];
            if (jClass == null) continue;
            this._sourcesByName.put(jClass.getName(), jClass);
        }
    }

    public void storeImportedSourcesByName(Map importedSourcesByName) {
        this._importedSourcesByName.putAll(importedSourcesByName);
    }

    JClass getProcessed(String className) {
        for (int i = 0; i < this._processed.size(); ++i) {
            JClass jClass = (JClass)this._processed.elementAt(i);
            if (!jClass.getName().equals(className)) continue;
            return jClass;
        }
        return null;
    }

    public JClass[] getSourceCode(Annotated annotated) {
        return (JClass[])this._sourcesByComponent.get(annotated);
    }

    public JClass getSourceCode(String className) {
        return (JClass)this._sourcesByName.get(className);
    }

    public JClass getImportedSourceCode(String className) {
        return (JClass)this._importedSourcesByName.get(className);
    }

    public MappingRoot getMapping(String filename) {
        if (this._mappings != null && filename != null) {
            return (MappingRoot)this._mappings.get(filename);
        }
        return null;
    }

    public Properties getCDRFile(String filename) {
        if (this._packageListings != null && filename != null) {
            return (Properties)this._packageListings.get(filename);
        }
        return null;
    }

    public Enumeration getCDRFilenames() {
        if (this._packageListings == null) {
            return EMPTY_ENUMERATION;
        }
        return this._packageListings.keys();
    }

    public Enumeration getMappingFilenames() {
        if (this._mappings == null) {
            return EMPTY_ENUMERATION;
        }
        return this._mappings.keys();
    }

    public int getStatusCode() {
        return this._status;
    }

    void markAsProcessed(JClass jClass) {
        if (!this._processed.contains(jClass)) {
            this._processed.addElement(jClass);
        }
    }

    boolean processed(JClass jClass) {
        return this._processed.contains(jClass);
    }

    boolean processed(String className) {
        for (int i = 0; i < this._processed.size(); ++i) {
            JClass jClass = (JClass)this._processed.elementAt(i);
            if (!jClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    boolean promptForOverwrite() {
        return this._promptForOverwrite;
    }

    void setPromptForOverwrite(boolean promptForOverwrite) {
        this._promptForOverwrite = promptForOverwrite;
    }

    Schema getSchema() {
        return this._schema;
    }

    SourceGenerator getSourceGenerator() {
        return this._sgen;
    }

    public boolean getSuppressNonFatalWarnings() {
        return this._suppressNonFatalWarnings;
    }

    void setSuppressNonFatalWarnings(boolean suppressNonFatalWarnings) {
        this._suppressNonFatalWarnings = suppressNonFatalWarnings;
    }

    public void setCDRFile(String filename, Properties props) {
        if (filename == null) {
            String err = "The argument 'filename' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (this._packageListings == null) {
            this._packageListings = new Hashtable();
        }
        if (props == null) {
            this._packageListings.remove(filename);
        } else {
            this._packageListings.put(filename, props);
        }
    }

    public void setMapping(String filename, MappingRoot mapping) {
        if (filename == null) {
            String err = "The argument 'filename' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (this._mappings == null) {
            this._mappings = new Hashtable();
        }
        if (mapping == null) {
            this._mappings.remove(filename);
        } else {
            this._mappings.put(filename, mapping);
        }
    }

    Dialog getDialog() {
        return this._dialog;
    }

    void setDialog(Dialog dialog) {
        this._dialog = dialog;
    }

    public void setStatusCode(int status) {
        this._status = status;
    }

    void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    boolean verbose() {
        return this._verbose;
    }

    FactoryState getCurrentFactoryState() {
        return this._currentFactoryState;
    }

    void setCurrentFactoryState(FactoryState state) {
        this._currentFactoryState = state;
    }

    public Map getImportedSourcesByName() {
        return this._importedSourcesByName;
    }

    public Map getSourcesByName() {
        return this._sourcesByName;
    }
}

