/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.security.InvalidParameterException;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.CollectionInfoJ2;
import org.exolab.castor.builder.info.CollectionInfoJ2Collection;
import org.exolab.castor.builder.info.CollectionInfoJ2Set;
import org.exolab.castor.builder.info.CollectionInfoJ2SortedSet;
import org.exolab.castor.builder.info.CollectionInfoODMG30;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.IdentityInfo;
import org.exolab.castor.builder.types.XSType;

public class FieldInfoFactory {
    private String _default = null;
    private boolean _extraMethods = false;
    private String _referenceSuffix = null;
    private boolean _bound = false;

    public FieldInfoFactory() {
        this("vector");
    }

    public FieldInfoFactory(String collectionName) {
        if (!(collectionName.equals("vector") || collectionName.equals("arraylist") || collectionName.equals("odmg"))) {
            throw new IllegalArgumentException(collectionName + " is currently not a supported Java collection.");
        }
        this._default = collectionName;
    }

    public IdentityInfo createIdentity(String name) {
        IdentityInfo idInfo = new IdentityInfo(name);
        if (this._bound) {
            idInfo.setBound(this._bound);
        }
        return idInfo;
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName, boolean usejava50) {
        return this.createCollection(contentType, name, elementName, this._default, usejava50);
    }

    /*
     * WARNING - void declaration
     */
    public CollectionInfo createCollection(XSType contentType, String name, String elementName, String collectionName, boolean useJava50) {
        void var7_7;
        CollectionInfo cInfo;
        String temp = collectionName;
        if (temp == null || temp.length() == 0) {
            temp = this._default;
        }
        if (temp.equalsIgnoreCase("vector")) {
            cInfo = new CollectionInfo(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase("arraylist")) {
            cInfo = new CollectionInfoJ2(contentType, name, elementName, "arraylist", useJava50);
        } else if (temp.equalsIgnoreCase("odmg")) {
            cInfo = new CollectionInfoODMG30(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase("collection")) {
            cInfo = new CollectionInfoJ2Collection(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase("set")) {
            cInfo = new CollectionInfoJ2Set(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase("sortedset")) {
            cInfo = new CollectionInfoJ2SortedSet(contentType, name, elementName, useJava50);
        } else {
            throw new InvalidParameterException("Unrecognized collection type: " + temp);
        }
        var7_7.setCreateExtraMethods(this._extraMethods);
        if (this._referenceSuffix != null) {
            var7_7.setReferenceMethodSuffix(this._referenceSuffix);
        }
        if (this._bound) {
            var7_7.setBound(true);
        }
        return var7_7;
    }

    public FieldInfo createFieldInfo(XSType type, String name) {
        FieldInfo fieldInfo = new FieldInfo(type, name);
        if (this._bound) {
            fieldInfo.setBound(true);
        }
        return fieldInfo;
    }

    public final void setBoundProperties(boolean bound) {
        this._bound = bound;
    }

    public final void setCreateExtraMethods(boolean extraMethods) {
        this._extraMethods = extraMethods;
    }

    public final void setReferenceMethodSuffix(String suffix) {
        this._referenceSuffix = suffix;
    }
}

