/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;

public class XPathHelper {
    private static final int INITIAL_XPATH_SIZE = 50;

    public static void getSchemaLocation(Structure structure, StringBuffer location) {
        XPathHelper.getSchemaLocation(structure, location, false);
    }

    public static void getSchemaLocation(Structure structure, StringBuffer location, boolean dealWithAnonTypes) {
        if (structure == null) {
            throw new IllegalArgumentException("Structure cannot be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        Structure parent = null;
        switch (structure.getStructureType()) {
            case 8: {
                parent = ((ElementDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    XPathHelper.getSchemaLocation(parent, location, dealWithAnonTypes);
                }
                location.append("/");
                location.append(((ElementDecl)structure).getName());
                break;
            }
            case 6: {
                ComplexType complexType = (ComplexType)structure;
                parent = complexType.getParent();
                if (parent.getStructureType() != 19) {
                    XPathHelper.getSchemaLocation(parent, location, dealWithAnonTypes);
                }
                if (complexType.getName() == null) break;
                location.append("/");
                location.append("complexType:");
                location.append(((ComplexType)structure).getName());
                break;
            }
            case 21: {
                SimpleType simpleType = (SimpleType)structure;
                parent = simpleType.getParent();
                if (parent != null && parent.getStructureType() != 19) {
                    XPathHelper.getSchemaLocation(parent, location, dealWithAnonTypes);
                }
                if (parent == null || simpleType.getName() == null) break;
                location.append("/");
                location.append("enumType:");
                location.append(((SimpleType)structure).getName());
                break;
            }
            case 16: {
                ModelGroup group = (ModelGroup)structure;
                parent = group.getParent();
                if (parent.getStructureType() != 19) {
                    XPathHelper.getSchemaLocation(parent, location, dealWithAnonTypes);
                }
                if (group.getName() == null) break;
                location.append("/");
                location.append("group:");
                location.append(group.getName());
                break;
            }
            case 3: {
                parent = ((AttributeDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    XPathHelper.getSchemaLocation(parent, location, dealWithAnonTypes);
                }
                location.append("/");
                location.append("@");
                location.append(((AttributeDecl)structure).getName());
                break;
            }
            case 10: {
                XPathHelper.getSchemaLocation(((Group)structure).getParent(), location, dealWithAnonTypes);
                break;
            }
        }
    }

    public static String getSchemaLocation(Structure structure, boolean dealWithAnonTypes) {
        if (structure == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(50);
        XPathHelper.getSchemaLocation(structure, buffer, dealWithAnonTypes);
        return buffer.toString();
    }

    public static String getSchemaLocation(Structure structure) {
        if (structure == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(50);
        XPathHelper.getSchemaLocation(structure, buffer, false);
        return buffer.toString();
    }
}

