/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractRangeFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSFloat
extends AbstractRangeFacet {
    public static final String NAME = "float";
    public static final short TYPE = 14;
    public static final String MIN_VALUE = Float.toString(-3.4028235E38f);
    public static final String MAX_VALUE = Float.toString(Float.MAX_VALUE);
    private final boolean _asWrapper;
    private final JType _jType;

    public XSFloat() {
        this(false);
    }

    public XSFloat(boolean asWrapper) {
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Float") : JType.FLOAT;
        this.setMinInclusive(MIN_VALUE);
        this.setMaxInclusive(MAX_VALUE);
    }

    public String getName() {
        return NAME;
    }

    public short getType() {
        return 14;
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isDateTime() {
        return false;
    }

    public JType getJType() {
        return this._jType;
    }

    public String newInstanceCode() {
        return "new java.lang.Float(0.0);";
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return variableName;
        }
        return "new java.lang.Float(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return "((java.lang.Float) " + variableName + ")";
        }
        return "((java.lang.Float) " + variableName + ").floatValue()";
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.FloatValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.FloatValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed((float) " + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("typeValidator.setMinExclusive((float) " + this.getMinExclusive() + ");");
        } else if (this.getMinInclusive() != null) {
            jsc.add("typeValidator.setMinInclusive((float) " + this.getMinInclusive() + ");");
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("typeValidator.setMaxExclusive((float) " + this.getMaxExclusive() + ");");
        } else if (this.getMaxInclusive() != null) {
            jsc.add("typeValidator.setMaxInclusive((float) " + this.getMaxInclusive() + ");");
        }
    }
}

