/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSQName
extends XSPatternBase {
    private static final JType JTYPE = new JClass("java.lang.String");
    private int _length = 0;
    private int _maxLength = -1;
    private int _minLength = 0;

    public XSQName() {
        super((short)18);
    }

    public String createFromJavaObjectCode(String variableName) {
        return "(java.lang.String) " + variableName;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getLength() {
        return this._length;
    }

    public boolean hasMaxLength() {
        return this._maxLength >= 0;
    }

    public boolean hasMinLength() {
        return this._minLength > 0;
    }

    public boolean hasLength() {
        return this._length > 0;
    }

    public void setLength(int length) {
        this._length = length;
        this.setMaxLength(length);
        this.setMinLength(length);
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSQName.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxLength".equals(name)) {
                this.setMaxLength(facet.toInt());
                continue;
            }
            if ("minLength".equals(name)) {
                this.setMinLength(facet.toInt());
                continue;
            }
            if ("length".equals(name)) {
                this.setLength(facet.toInt());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.addPattern(facet.getValue());
        }
    }

    public JType getJType() {
        return JTYPE;
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.NameValidator typeValidator = new org.exolab.castor.xml.validators.NameValidator(org.exolab.castor.xml.XMLConstants.NAME_TYPE_QNAME);");
        if (this.hasLength()) {
            jsc.add("typeValidator.setLength(");
            jsc.append(Integer.toString(this.getLength()));
            jsc.append(");");
        } else {
            if (this.hasMinLength()) {
                jsc.add("typeValidator.setMinLength(");
                jsc.append(Integer.toString(this.getMinLength()));
                jsc.append(");");
            }
            if (this.hasMaxLength()) {
                jsc.add("typeValidator.setMaxLength(");
                jsc.append(Integer.toString(this.getMaxLength()));
                jsc.append(");");
            }
        }
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

