/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSInteger
extends XSPatternBase {
    private Long _maxInclusive = null;
    private Long _maxExclusive = null;
    private Long _minInclusive = null;
    private Long _minExclusive = null;
    private int _totalDigits = -1;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSInteger() {
        this(false);
    }

    public XSInteger(boolean asWrapper) {
        super((short)32);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Long") : JType.LONG;
    }

    protected XSInteger(boolean asWrapper, short type) {
        super(type);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Long") : JType.LONG;
    }

    public JType getJType() {
        return this._jType;
    }

    public Long getMaxExclusive() {
        return this._maxExclusive;
    }

    public Long getMaxInclusive() {
        return this._maxInclusive;
    }

    public Long getMinExclusive() {
        return this._minExclusive;
    }

    public Long getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(long max) {
        this._maxExclusive = new Long(max);
        this._maxInclusive = null;
    }

    public void setMaxExclusive(Long max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(long max) {
        this._maxInclusive = new Long(max);
        this._maxExclusive = null;
    }

    public void setMaxInclusive(Long max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(long min) {
        this._minExclusive = new Long(min);
        this._minInclusive = null;
    }

    public void setMinExclusive(Long min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(long min) {
        this._minInclusive = new Long(min);
        this._minExclusive = null;
    }

    public void setMinInclusive(Long min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSInteger.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toLong());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toLong());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toLong());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toLong());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                if (facet.toInt() == 0) continue;
                throw new IllegalArgumentException("fractionDigits must be 0 for " + this.getName());
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for '" + this.getName() + "'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        return "new java.lang.Long(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Long) ");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".intValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.IntegerValidator typeValidator = new org.exolab.castor.xml.validators.IntegerValidator();");
        if (this._minExclusive != null) {
            jsc.add("typeValidator.setMinExclusive(" + this._minExclusive + ");");
        } else if (this._minInclusive != null) {
            jsc.add("typeValidator.setMinInclusive(" + this._minInclusive + ");");
        }
        if (this._maxExclusive != null) {
            jsc.add("typeValidator.setMaxExclusive(" + this._maxExclusive + ");");
        } else if (this._maxInclusive != null) {
            jsc.add("typeValidator.setMaxInclusive(" + this._maxInclusive + ");");
        }
        if (fixedValue != null) {
            if (this._jType == JType.LONG) {
                Long.parseLong(fixedValue);
            }
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

