/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSFloat
extends XSPatternBase {
    private Float _maxInclusive = null;
    private Float _maxExclusive = null;
    private Float _minInclusive = null;
    private Float _minExclusive = null;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSFloat() {
        this(false);
    }

    public XSFloat(boolean asWrapper) {
        super((short)14);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Float") : JType.FLOAT;
    }

    public JType getJType() {
        return this._jType;
    }

    public Float getMaxExclusive() {
        return this._maxExclusive;
    }

    public Float getMaxInclusive() {
        return this._maxInclusive;
    }

    public Float getMinExclusive() {
        return this._minExclusive;
    }

    public Float getMinInclusive() {
        return this._minInclusive;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(float max) {
        this._maxExclusive = new Float(max);
    }

    public void setMaxExclusive(Float max) {
        this._maxExclusive = max;
    }

    public void setMaxInclusive(float max) {
        this._maxInclusive = new Float(max);
    }

    public void setMaxInclusive(Float max) {
        this._maxInclusive = max;
    }

    public void setMinExclusive(float min) {
        this._minExclusive = new Float(min);
    }

    public void setMinExclusive(Float min) {
        this._minExclusive = min;
    }

    public void setMinInclusive(float min) {
        this._minInclusive = new Float(min);
    }

    public void setMinInclusive(Float min) {
        this._minInclusive = min;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSFloat.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toFloat());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toFloat());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toFloat());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toFloat());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for 'float'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Float(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Float) ");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".floatValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.FloatValidator typeValidator = new org.exolab.castor.xml.validators.FloatValidator();");
        if (this.hasMinimum()) {
            Float min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            if (min.equals(new Float(Float.NEGATIVE_INFINITY))) {
                jsc.append("Float.NEGATIVE_INFINITY");
            } else if (min.equals(new Float(Float.POSITIVE_INFINITY))) {
                jsc.append("Float.POSITIVE_INFINITY");
            } else {
                jsc.append(min.toString() + "f");
            }
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Float max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            if (max.equals(new Float(Float.NEGATIVE_INFINITY))) {
                jsc.append("Float.NEGATIVE_INFINITY");
            } else if (max.equals(new Float(Float.POSITIVE_INFINITY))) {
                jsc.append("Float.POSITIVE_INFINITY");
            } else {
                jsc.append(max.toString() + "f");
            }
            jsc.append(");");
        }
        if (fixedValue != null) {
            new Float(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append("f);");
        }
        this.codePatternFacet(jsc, "typeValidator");
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

