/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDouble
extends XSPatternBase {
    private Double _maxInclusive = null;
    private Double _maxExclusive = null;
    private Double _minInclusive = null;
    private Double _minExclusive = null;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSDouble() {
        this(false);
    }

    public XSDouble(boolean asWrapper) {
        super((short)15);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Double") : JType.DOUBLE;
    }

    public JType getJType() {
        return this._jType;
    }

    public Double getMaxExclusive() {
        return this._maxExclusive;
    }

    public Double getMaxInclusive() {
        return this._maxInclusive;
    }

    public Double getMinExclusive() {
        return this._minExclusive;
    }

    public Double getMinInclusive() {
        return this._minInclusive;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(double max) {
        this._maxExclusive = new Double(max);
    }

    public void setMaxExclusive(Double max) {
        this._maxExclusive = max;
    }

    public void setMaxInclusive(double max) {
        this._maxInclusive = new Double(max);
    }

    public void setMaxInclusive(Double max) {
        this._maxInclusive = max;
    }

    public void setMinExclusive(double min) {
        this._minExclusive = new Double(min);
    }

    public void setMinExclusive(Double min) {
        this._minExclusive = min;
    }

    public void setMinInclusive(double min) {
        this._minInclusive = new Double(min);
    }

    public void setMinInclusive(Double min) {
        this._minInclusive = min;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSDouble.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toDouble());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toDouble());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toDouble());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toDouble());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for 'double'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        return "new java.lang.Double(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Double) ");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".doubleValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.DoubleValidator typeValidator = new org.exolab.castor.xml.validators.DoubleValidator();");
        if (this._minExclusive != null) {
            jsc.add("typeValidator.setMinExclusive(" + this._minExclusive + ");");
        } else if (this._minInclusive != null) {
            jsc.add("typeValidator.setMinInclusive(" + this._minInclusive + ");");
        }
        if (this._maxExclusive != null) {
            jsc.add("typeValidator.setMaxExclusive(" + this._maxExclusive + ");");
        } else if (this._maxInclusive != null) {
            jsc.add("typeValidator.setMaxInclusive(" + this._maxInclusive + ");");
        }
        if (fixedValue != null) {
            new Double(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

