/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigDecimal;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSDecimal
extends XSPatternBase {
    private static final JType JTYPE = new JClass("java.math.BigDecimal");
    private BigDecimal _maxInclusive = null;
    private BigDecimal _maxExclusive = null;
    private BigDecimal _minInclusive = null;
    private BigDecimal _minExclusive = null;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;

    public XSDecimal() {
        super((short)16);
    }

    public String newInstanceCode() {
        String result = "new java.math.BigDecimal(0);";
        return result;
    }

    public String createFromJavaObjectCode(String variableName) {
        return "(java.math.BigDecimal) " + variableName;
    }

    public BigDecimal getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigDecimal getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigDecimal getMinExclusive() {
        return this._minExclusive;
    }

    public BigDecimal getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public int getFractionDigits() {
        return this._fractionDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(BigDecimal max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(BigDecimal max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(BigDecimal min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(BigDecimal min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFractionDigits(int fractionDig) {
        if (fractionDig < 0) {
            throw new IllegalArgumentException(this.getName() + ": the fractionDigits facet must be positive");
        }
        this._fractionDigits = fractionDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSDecimal.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(new BigDecimal(facet.getValue()));
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                this.setFractionDigits(facet.toInt());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for 'decimal'.");
        }
    }

    public JType getJType() {
        return JTYPE;
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        int fractionDigits;
        jsc.add("org.exolab.castor.xml.validators.DecimalValidator typeValidator = new org.exolab.castor.xml.validators.DecimalValidator();");
        if (this._minExclusive != null) {
            jsc.add("java.math.BigDecimal min = new java.math.BigDecimal(\"" + this._minExclusive + "\");");
            jsc.add("typeValidator.setMinExclusive(min);");
        } else if (this._minInclusive != null) {
            jsc.add("java.math.BigDecimal min = new java.math.BigDecimal(\"" + this._minInclusive + "\");");
            jsc.add("typeValidator.setMinInclusive(min);");
        }
        if (this._maxExclusive != null) {
            jsc.add("java.math.BigDecimal max = new java.math.BigDecimal(\"" + this._maxExclusive + "\");");
            jsc.add("typeValidator.setMaxExclusive(max);");
        } else if (this._maxInclusive != null) {
            jsc.add("java.math.BigDecimal max = new java.math.BigDecimal(\"" + this._maxInclusive + "\");");
            jsc.add("typeValidator.setMaxInclusive(max);");
        }
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        if ((fractionDigits = this.getFractionDigits()) != -1) {
            jsc.add("typeValidator.setFractionDigits(");
            jsc.append(Integer.toString(fractionDigits));
            jsc.append(");");
        }
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

