/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.info;

import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.XMLInfo;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;
import org.exolab.javasource.Java5HacksHelper;

public class FieldInfo
extends XMLInfo {
    public static final int READ_METHOD = 1;
    public static final int WRITE_METHOD = 2;
    public static final int READ_WRITE_METHODS = 3;
    private static final String METHOD_PREFIX_ADD = "add";
    private static final String METHOD_PREFIX_DELETE = "delete";
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_HAS = "has";
    private static final String METHOD_PREFIX_SET = "set";
    private static final String METHOD_PREFIX_IS = "is";
    private String _name = null;
    private ClassInfo _declaringClassInfo = null;
    private String _comment = null;
    private String _default = null;
    private String _fixed = null;
    private boolean _final = false;
    private int _methods = 3;
    private FieldInfo _fieldInfoReference = null;
    private boolean _static = false;
    private boolean _transient = false;
    private boolean _bound = false;
    private boolean _isContainer = false;
    private String _fieldHandler;
    private boolean _nillable = false;
    private String _validator;
    private String _visibility = "private";

    public FieldInfo(XSType type, String name) {
        this._name = name;
        this.setSchemaType(type);
    }

    public void createJavaField(JClass jClass) {
        JModifiers modifiers;
        XSType type = this.getSchemaType();
        JType jType = type.getJType();
        JField field = new JField(type.getJType(), this._name);
        if (this.getSchemaType().isDateTime()) {
            field.setDateTime(true);
        }
        if (this._static || this._final) {
            modifiers = field.getModifiers();
            modifiers.setFinal(this._final);
            modifiers.setStatic(this._static);
        }
        if (!this._visibility.equals("private")) {
            modifiers = field.getModifiers();
            if (this._visibility.equals("protected")) {
                modifiers.makeProtected();
            } else if (this._visibility.equals("public")) {
                modifiers.makePublic();
            }
        }
        if (this._default != null) {
            field.setInitString(this._default);
        }
        if (this.getFixedValue() != null && !this.getSchemaType().isDateTime()) {
            field.setInitString(this.getFixedValue());
        }
        if (this._comment != null) {
            field.setComment(this._comment);
        }
        jClass.addField(field);
        if (!type.isEnumerated() && jType.isPrimitive()) {
            field = new JField(JType.BOOLEAN, "_has" + this._name);
            field.setComment("keeps track of state for field: " + this._name);
            jClass.addField(field);
        }
    }

    public void createAccessMethods(JClass jClass, boolean useJava50) {
        if ((this._methods & 1) > 0) {
            this.createGetterMethod(jClass, useJava50);
        }
        if ((this._methods & 2) > 0) {
            this.createSetterMethod(jClass, useJava50);
        }
        if (this.isHasAndDeleteMethods()) {
            this.createHasAndDeleteMethods(jClass);
        }
    }

    public void createGetterComment(JDocComment jDocComment) {
        String fieldName = this._name;
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String mComment = "Returns the value of field '" + fieldName + "'.";
        if (this._comment != null && this._comment.length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (this._comment.startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + this._comment;
        }
        jDocComment.setComment(mComment);
    }

    public void createGetterMethod(JClass jClass, boolean useJava50) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.getMethodSuffix();
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(METHOD_PREFIX_GET + mname, jType, "the value of field '" + mname + "'.");
        if (useJava50) {
            Java5HacksHelper.addOverrideAnnotations(method.getSignature());
        }
        jClass.addMethod(method);
        this.createGetterComment(method.getJDocComment());
        jsc = method.getSourceCode();
        jsc.add("return this.");
        jsc.append(this._name);
        jsc.append(";");
        if (xsType.getType() == 11) {
            method = new JMethod(METHOD_PREFIX_IS + mname, jType, "the value of field '" + mname + "'.");
            if (useJava50) {
                Java5HacksHelper.addOverrideAnnotations(method.getSignature());
            }
            jClass.addMethod(method);
            this.createGetterComment(method.getJDocComment());
            jsc = method.getSourceCode();
            jsc.add("return this.");
            jsc.append(this._name);
            jsc.append(";");
        }
    }

    public void createHasAndDeleteMethods(JClass jClass) {
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.getMethodSuffix();
        XSType xsType = this.getSchemaType();
        xsType.getJType();
        method = new JMethod(METHOD_PREFIX_HAS + mname, JType.BOOLEAN, "true if at least one " + mname + " has been added");
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("return this._has");
        jsc.append(this.getName());
        jsc.append(";");
        method = new JMethod(METHOD_PREFIX_DELETE + mname);
        jClass.addMethod(method);
        jsc = method.getSourceCode();
        jsc.add("this._has");
        jsc.append(this.getName());
        jsc.append("= false;");
        if (this._bound) {
            jsc.add("notifyPropertyChangeListeners(\"");
            jsc.append(this.getName());
            jsc.append("\", ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(", null");
            jsc.append(");");
        }
    }

    public void createSetterComment(JDocComment jDocComment) {
        String fieldName = this._name;
        if (fieldName.indexOf(95) == 0) {
            fieldName = fieldName.substring(1);
        }
        String atParam = "the value of field '" + fieldName + "'.";
        String mComment = "Sets " + atParam;
        if (this._comment != null && this._comment.length() > 0) {
            mComment = mComment + " The field '" + fieldName + "' has the following description: ";
            if (this._comment.startsWith("@")) {
                mComment = mComment + "\n\n";
            }
            mComment = mComment + this._comment;
        }
        jDocComment.setComment(mComment);
        JDocDescriptor paramDesc = jDocComment.getParamDescriptor(fieldName);
        if (paramDesc == null) {
            paramDesc = JDocDescriptor.createParamDesc(fieldName, null);
            jDocComment.addDescriptor(paramDesc);
        }
        paramDesc.setDescription(atParam);
    }

    public void createSetterMethod(JClass jClass, boolean useJava50) {
        String tempName;
        JMethod method = null;
        JSourceCode jsc = null;
        String mname = this.getMethodSuffix();
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        method = new JMethod(METHOD_PREFIX_SET + mname);
        jClass.addMethod(method);
        String paramName = this._name;
        if (paramName.indexOf(95) == 0 && JavaNaming.isValidJavaIdentifier((String)(tempName = paramName.substring(1)))) {
            paramName = tempName;
        }
        method.addParameter(new JParameter(jType, paramName));
        if (useJava50) {
            Java5HacksHelper.addOverrideAnnotations(method.getSignature());
        }
        this.createSetterComment(method.getJDocComment());
        jsc = method.getSourceCode();
        if (this._bound) {
            jsc.add("java.lang.Object old");
            jsc.append(mname);
            jsc.append(" = ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(";");
        }
        jsc.add("this.");
        jsc.append(this.getName());
        jsc.append(" = ");
        jsc.append(paramName);
        jsc.append(";");
        if (this._fieldInfoReference != null) {
            jsc.add("this.");
            jsc.append(this._fieldInfoReference.getName());
            jsc.append(" = ");
            JType referencedJType = this._fieldInfoReference.getSchemaType().getJType();
            if (referencedJType.isPrimitive()) {
                jsc.append(paramName);
            } else {
                if (jType.getWrapperName() != null) {
                    jsc.append("new ");
                    jsc.append(jType.getWrapperName());
                    jsc.append("(");
                }
                jsc.append(paramName);
                if (jType.getWrapperName() != null) {
                    jsc.append(")");
                }
            }
            jsc.append(";");
        }
        if (this.isHasAndDeleteMethods()) {
            jsc.add("this._has");
            jsc.append(this.getName());
            jsc.append(" = true;");
        }
        if (this._bound) {
            jsc.add("notifyPropertyChangeListeners(\"");
            jsc.append(this.getName());
            jsc.append("\", old");
            jsc.append(mname);
            jsc.append(", ");
            jsc.append(xsType.createToJavaObjectCode("this." + this.getName()));
            jsc.append(");");
        }
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public String getDeleteMethodName() {
        return METHOD_PREFIX_DELETE + this.getMethodSuffix();
    }

    public String getHasMethodName() {
        return METHOD_PREFIX_HAS + this.getMethodSuffix();
    }

    public String getReadMethodName() {
        return METHOD_PREFIX_GET + this.getMethodSuffix();
    }

    public String getValidator() {
        return this._validator;
    }

    public String getWriteMethodName() {
        if (this.isMultivalued()) {
            return METHOD_PREFIX_ADD + this.getMethodSuffix();
        }
        return METHOD_PREFIX_SET + this.getMethodSuffix();
    }

    public String getXMLFieldHandler() {
        return this._fieldHandler;
    }

    public void generateInitializerCode(JSourceCode jsc) {
        if (!this.getSchemaType().isPrimitive()) {
            String value = this.getDefaultValue();
            boolean dateTime = this.getSchemaType().isDateTime();
            if (value == null) {
                value = this.getFixedValue();
            }
            if (value != null) {
                StringBuffer buffer = new StringBuffer(50);
                if (dateTime) {
                    jsc.add("try {");
                    jsc.indent();
                }
                buffer.append(METHOD_PREFIX_SET);
                buffer.append(this.getMethodSuffix());
                buffer.append('(');
                buffer.append(value);
                buffer.append(");");
                jsc.add(buffer.toString());
                if (dateTime) {
                    jsc.unindent();
                    jsc.add("} catch (java.text.ParseException pe) {");
                    jsc.indent();
                    jsc.add("throw new IllegalStateException(pe.getMessage());");
                    jsc.unindent();
                    jsc.add("}");
                }
            }
        }
    }

    public String getComment() {
        return this._comment;
    }

    public int getMethods() {
        return this._methods;
    }

    public String getName() {
        return this._name;
    }

    public boolean isBound() {
        return this._bound;
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public boolean isHasAndDeleteMethods() {
        XSType xsType = this.getSchemaType();
        JType jType = xsType.getJType();
        return !xsType.isEnumerated() && jType.isPrimitive();
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean isTransient() {
        return this._transient || this._final || this._static;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public ClassInfo getDeclaringClassInfo() {
        return this._declaringClassInfo;
    }

    public void setBound(boolean bound) {
        this._bound = bound;
    }

    public void setContainer(boolean isContainer) {
        this._isContainer = isContainer;
    }

    public void setDeclaringClassInfo(ClassInfo declaringClassInfo) {
        this._declaringClassInfo = declaringClassInfo;
    }

    public void setDefaultValue(String defaultValue) {
        this._default = defaultValue;
    }

    public void setFinal(boolean isFinal) {
        this._final = isFinal;
    }

    public void setFixedValue(String fixedValue) {
        this._fixed = fixedValue;
    }

    public void setMethods(int methods) {
        this._methods = methods;
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public void setFieldInfoReference(FieldInfo fieldInfo) {
        this._fieldInfoReference = fieldInfo;
    }

    public void setStatic(boolean isStatic) {
        this._static = isStatic;
    }

    public void setTransient(boolean isTransient) {
        this._transient = isTransient;
    }

    public void setValidator(String validator) {
        this._validator = validator;
    }

    public void setXMLFieldHandler(String handler) {
        this._fieldHandler = handler;
    }

    public String getMethodSuffix() {
        if (this._name.startsWith("_")) {
            return JavaNaming.toJavaClassName((String)this._name.substring(1));
        }
        return JavaNaming.toJavaClassName((String)this._name);
    }

    public void setVisibility(String visibility) {
        this._visibility = visibility;
    }
}

