/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.info;

import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JCollectionType;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfo
extends FieldInfo {
    public static final String DEFAULT_REFERENCE_SUFFIX = "AsReference";
    public static final String REFERENCE_SUFFIX_PROPERTY = "org.exolab.castor.builder.collections.reference.suffix";
    private boolean _extraMethods;
    private String _methodSuffix;
    private String _parameterPrefix;
    private String _referenceSuffix = "AsReference";
    private FieldInfo _content;
    private String _elementName;

    public CollectionInfo(XSType contentType, String name, String elementName, boolean useJava50) {
        super(new XSList(contentType, useJava50), name);
        this._elementName = elementName.charAt(0) == '_' ? elementName.substring(1) : elementName;
        this._methodSuffix = JavaNaming.toJavaClassName((String)this.getElementName());
        this._parameterPrefix = JavaNaming.toJavaMemberName((String)this.getElementName());
        this._content = new FieldInfo(contentType, "v" + this.getMethodSuffix());
    }

    public void createAccessMethods(JClass jClass, boolean useJava50) {
        this.createAddAndRemoveMethods(jClass);
        this.createGetAndSetMethods(jClass, useJava50);
        this.createGetCountMethod(jClass);
        this.createCollectionIterationMethods(jClass, useJava50);
    }

    public void generateInitializerCode(JSourceCode sourceCode) {
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(" = new ");
        JType jType = this.getXSList().getJType();
        sourceCode.append(((JCollectionType)jType).getInstanceName());
        sourceCode.append("();");
    }

    public FieldInfo getContent() {
        return this._content;
    }

    public String getContentName() {
        return this.getContent().getName();
    }

    public XSType getContentType() {
        return this.getContent().getSchemaType();
    }

    public String getElementName() {
        return this._elementName;
    }

    public XSList getXSList() {
        return (XSList)this.getSchemaType();
    }

    public boolean isMultivalued() {
        return true;
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this._extraMethods = extraMethods;
    }

    public void setReferenceMethodSuffix(String suffix) {
        this._referenceSuffix = suffix == null || suffix.length() == 0 ? DEFAULT_REFERENCE_SUFFIX : suffix;
    }

    private void addIndexCheck(JSourceCode sourceCode, String methodName) {
        sourceCode.add("// check bounds for index");
        sourceCode.add("if (index < 0 || index >= this.");
        sourceCode.append(this.getName());
        sourceCode.append(".size()) {");
        sourceCode.indent();
        sourceCode.add("throw new IndexOutOfBoundsException(\"");
        sourceCode.append(methodName);
        sourceCode.append(": Index value '\" + index + \"' not in range [0..\" + (this.");
        sourceCode.append(this.getName());
        sourceCode.append(".size() - 1) + \"]\");");
        sourceCode.unindent();
        sourceCode.add("}");
        sourceCode.add("");
    }

    protected void addMaxSizeCheck(String methodName, JSourceCode sourceCode) {
        if (this.getXSList().getMaximumSize() > 0) {
            String size = Integer.toString(this.getXSList().getMaximumSize());
            sourceCode.add("// check for the maximum size");
            sourceCode.add("if (this.");
            sourceCode.append(this.getName());
            sourceCode.append(".size() >= ");
            sourceCode.append(size);
            sourceCode.append(") {");
            sourceCode.indent();
            sourceCode.add("throw new IndexOutOfBoundsException(\"");
            sourceCode.append(methodName);
            sourceCode.append(" has a maximum of ");
            sourceCode.append(size);
            sourceCode.append("\");");
            sourceCode.unindent();
            sourceCode.add("}");
            sourceCode.add("");
        }
    }

    protected void createAddMethod(JClass jClass) {
        JMethod method = new JMethod(this.getWriteMethodName());
        method.addException(SGTypes.IndexOutOfBoundsException, "if the index given is outside the bounds of the collection");
        JParameter parameter = new JParameter(this.getContentType().getJType(), this.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        this.addMaxSizeCheck(method.getName(), sourceCode);
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".addElement(");
        sourceCode.append(this.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createBoundPropertyCode(JSourceCode sourceCode) {
        sourceCode.add("notifyPropertyChangeListeners(\"");
        sourceCode.append(this.getName());
        sourceCode.append("\", null, ");
        sourceCode.append(this.getName());
        sourceCode.append(");");
    }

    protected void createEnumerateMethod(JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("enumerate" + this.getMethodSuffix(), SGTypes.createEnumeration(this.getContentType().getJType(), useJava50), "an Enumeration over all " + this.getContentType().getJType() + " elements");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(this.getName());
        sourceCode.append(".elements();");
        jClass.addMethod(method);
    }

    protected final boolean createExtraMethods() {
        return this._extraMethods;
    }

    protected void createGetAsArrayMethod(JClass jClass, boolean useJava50) {
        JType baseType = this.getContentType().getJType();
        JArrayType arrayType = new JArrayType(baseType, useJava50);
        JMethod method = new JMethod(this.getReadMethodName(), arrayType, "this collection as an Array");
        JSourceCode sourceCode = method.getSourceCode();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns the contents of the collection in an Array.  ");
        if (!baseType.isPrimitive()) {
            comment.appendComment("<p>");
            comment.appendComment("Note:  Just in case the collection contents are changing in ");
            comment.appendComment("another thread, we pass a 0-length Array of the correct type ");
            comment.appendComment("into the API call.  This way we <i>know</i> that the Array ");
            comment.appendComment("returned is of exactly the correct length.");
            sourceCode.add(((JType)arrayType).toString() + " array = new " + baseType.toString() + "[0];");
            sourceCode.add("return (" + ((JType)arrayType).toString() + ") ");
            sourceCode.append("this." + this.getName() + ".toArray(array);");
        } else {
            sourceCode.add("int size = this.");
            sourceCode.append(this.getName());
            sourceCode.append(".size();");
            sourceCode.add(((JType)arrayType).toString());
            sourceCode.append(" array = new ");
            int brackets = ((JType)arrayType).toString().indexOf("[]");
            sourceCode.append(((JType)arrayType).toString().substring(0, brackets));
            sourceCode.append("[size]");
            sourceCode.append(";");
            sourceCode.add("java.util.Iterator iter = " + this.getName() + ".iterator();");
            String value = "iter.next()";
            sourceCode.add("for (int index = 0; index < size; index++)");
            sourceCode.append("{");
            sourceCode.indent();
            sourceCode.add("array[index] = ");
            if (this.getContentType().getType() == 0) {
                sourceCode.append("(");
                sourceCode.append(arrayType.getName());
                sourceCode.append(") ");
                sourceCode.append(value);
            } else {
                sourceCode.append(this.getContentType().createFromJavaObjectCode(value));
            }
            sourceCode.append(";");
            sourceCode.unindent();
            sourceCode.add("}");
            sourceCode.add("");
            sourceCode.add("return array;");
        }
        jClass.addMethod(method);
    }

    protected void createGetAsReferenceMethod(JClass jClass) {
        JMethod method = new JMethod(this.getReadMethodName() + this.getReferenceMethodSuffix(), this.getXSList().getJType(), "a reference to the Vector backing this class");
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns a reference to '");
        comment.appendComment(this.getName());
        comment.appendComment("'. No type checking is performed on any ");
        comment.appendComment("modifications to the Vector.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(this.getName());
        sourceCode.append(";");
        jClass.addMethod(method);
    }

    protected void createGetByIndexMethod(JClass jClass) {
        XSType contentType = this.getContentType();
        JMethod method = new JMethod(this.getReadMethodName(), contentType.getJType(), "the value of the " + contentType.getJType().toString() + " at the given index");
        method.addException(SGTypes.IndexOutOfBoundsException, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JSourceCode sourceCode = method.getSourceCode();
        this.addIndexCheck(sourceCode, method.getName());
        String value = this.getName() + ".get(index)";
        sourceCode.add("return ");
        if (contentType.getType() == 0) {
            sourceCode.append("(");
            sourceCode.append(method.getReturnType().toString());
            sourceCode.append(") ");
            sourceCode.append(value);
        } else {
            sourceCode.append(contentType.createFromJavaObjectCode(value));
        }
        sourceCode.append(";");
        jClass.addMethod(method);
    }

    protected void createAddAndRemoveMethods(JClass jClass) {
        this.createAddMethod(jClass);
        this.createAddByIndexMethod(jClass);
        this.createRemoveObjectMethod(jClass);
        this.createRemoveByIndexMethod(jClass);
        this.createRemoveAllMethod(jClass);
    }

    protected void createGetAndSetMethods(JClass jClass, boolean useJava50) {
        this.createGetByIndexMethod(jClass);
        this.createGetAsArrayMethod(jClass, useJava50);
        if (this.createExtraMethods()) {
            this.createGetAsReferenceMethod(jClass);
        }
        this.createSetByIndexMethod(jClass);
        this.createSetAsArrayMethod(jClass, useJava50);
        if (this.createExtraMethods()) {
            this.createSetAsCopyMethod(jClass);
            this.createSetAsReferenceMethod(jClass, useJava50);
        }
    }

    protected void createGetCountMethod(JClass jClass) {
        JMethod method = new JMethod(this.getReadMethodName() + "Count", JType.INT, "the size of this collection");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(this.getName());
        sourceCode.append(".size();");
        jClass.addMethod(method);
    }

    protected void createCollectionIterationMethods(JClass jClass, boolean useJava50) {
        this.createEnumerateMethod(jClass, useJava50);
    }

    protected void createAddByIndexMethod(JClass jClass) {
        JMethod method = new JMethod(this.getWriteMethodName());
        method.addException(SGTypes.IndexOutOfBoundsException, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JParameter parameter = new JParameter(this.getContentType().getJType(), this.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        this.addMaxSizeCheck(method.getName(), sourceCode);
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".add(index, ");
        sourceCode.append(this.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createIteratorMethod(JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("iterate" + this.getMethodSuffix(), SGTypes.createIterator(this.getContentType().getJType(), useJava50), "an Iterator over all possible elements in this collection");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(this.getName());
        sourceCode.append(".iterator();");
        jClass.addMethod(method);
    }

    protected void createRemoveAllMethod(JClass jClass) {
        JMethod method = new JMethod("removeAll" + this.getMethodSuffix());
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".clear();");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createRemoveByIndexMethod(JClass jClass) {
        JMethod method = new JMethod("remove" + this.getMethodSuffix() + "At", this.getContentType().getJType(), "the element removed from the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("Object obj = this.");
        sourceCode.append(this.getName());
        sourceCode.append(".remove(index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        sourceCode.add("return ");
        if (this.getContentType().getType() == 0) {
            sourceCode.append("(");
            sourceCode.append(method.getReturnType().getName());
            sourceCode.append(") obj;");
        } else {
            sourceCode.append(this.getContentType().createFromJavaObjectCode("obj"));
            sourceCode.append(";");
        }
        jClass.addMethod(method);
    }

    protected void createRemoveObjectMethod(JClass jClass) {
        JMethod method = new JMethod("remove" + this.getMethodSuffix(), JType.BOOLEAN, "true if the object was removed from the collection.");
        JParameter parameter = new JParameter(this.getContentType().getJType(), this.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("boolean removed = ");
        sourceCode.append(this.getName());
        sourceCode.append(".remove(");
        sourceCode.append(this.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        sourceCode.add("return removed;");
        jClass.addMethod(method);
    }

    protected void createSetAsArrayMethod(JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("set" + this.getMethodSuffix());
        JParameter parameter = new JParameter(new JArrayType(this.getContentType().getJType(), useJava50), this.getContentName() + "Array");
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        String index = "i";
        if (parameter.getName().equals(index)) {
            index = "j";
        }
        sourceCode.add("//-- copy array");
        sourceCode.add(this.getName());
        sourceCode.append(".clear();");
        sourceCode.add("");
        sourceCode.add("for (int ");
        sourceCode.append(index);
        sourceCode.append(" = 0; ");
        sourceCode.append(index);
        sourceCode.append(" < ");
        sourceCode.append(parameter.getName());
        sourceCode.append(".length; ");
        sourceCode.append(index);
        sourceCode.append("++) {");
        sourceCode.indent();
        sourceCode.addIndented("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".add(");
        sourceCode.append(this.getContentType().createToJavaObjectCode(parameter.getName() + "[" + index + "]"));
        sourceCode.append(");");
        sourceCode.unindent();
        sourceCode.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createSetAsCopyMethod(JClass jClass) {
        JMethod method = new JMethod("set" + this.getMethodSuffix());
        JParameter parameter = new JParameter(this.getXSList().getJType(), this.getContentName() + "List");
        method.addParameter(parameter);
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(this.getName());
        comment.appendComment("' by copying the given Vector. All elements will be checked for type safety.");
        JDocDescriptor jDesc = comment.getParamDescriptor(parameter.getName());
        jDesc.setDescription("the Vector to copy.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("// copy vector");
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".clear();");
        sourceCode.add("");
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".addAll(");
        sourceCode.append(parameter.getName());
        sourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createSetAsReferenceMethod(JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("set" + this.getMethodSuffix() + this._referenceSuffix);
        JType collectionJType = this.getSchemaType().getJType();
        JParameter parameter = new JParameter(collectionJType, this.getParameterPrefix() + collectionJType.getLocalName());
        method.addParameter(parameter);
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(this.getName());
        comment.appendComment("' by setting it to the given Vector.");
        comment.appendComment(" No type checking is performed.");
        comment.appendComment("\n@deprecated");
        JDocDescriptor jDesc = comment.getParamDescriptor(parameter.getName());
        jDesc.setDescription("the Vector to set.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(" = ");
        sourceCode.append(parameter.getName());
        sourceCode.append(";");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    private String getParameterPrefix() {
        return this._parameterPrefix;
    }

    protected void createSetByIndexMethod(JClass jClass) {
        JMethod method = new JMethod("set" + this.getMethodSuffix());
        method.addException(SGTypes.IndexOutOfBoundsException, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        method.addParameter(new JParameter(this.getContentType().getJType(), this.getContentName()));
        JSourceCode sourceCode = method.getSourceCode();
        this.addIndexCheck(sourceCode, method.getName());
        sourceCode.add("this.");
        sourceCode.append(this.getName());
        sourceCode.append(".set(index, ");
        sourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        sourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(sourceCode);
        }
        jClass.addMethod(method);
    }

    public String getMethodSuffix() {
        return this._methodSuffix;
    }

    protected final String getReferenceMethodSuffix() {
        return this._referenceSuffix;
    }
}

