/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.CollectionInfoJ2;
import org.exolab.castor.builder.info.CollectionInfoJ2Collection;
import org.exolab.castor.builder.info.CollectionInfoJ2Set;
import org.exolab.castor.builder.info.CollectionInfoJ2SortedSet;
import org.exolab.castor.builder.info.CollectionInfoODMG30;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.IdentityInfo;
import org.exolab.castor.builder.types.XSType;

public class FieldInfoFactory {
    public static final String VECTOR = "vector";
    public static final String ARRAY_LIST = "arraylist";
    public static final String ODMG = "odmg";
    public static final String COLLECTION = "collection";
    public static final String SET = "set";
    public static final String SORTED_SET = "sortedset";
    private String _default = null;
    private boolean _extraMethods = false;
    private String _referenceSuffix = null;
    private boolean _bound = false;

    public FieldInfoFactory() {
        this(VECTOR);
    }

    public FieldInfoFactory(String collectionName) {
        if (!(collectionName.equals(VECTOR) || collectionName.equals(ARRAY_LIST) || collectionName.equals(ODMG))) {
            throw new IllegalArgumentException(collectionName + " is currently not a supported Java collection.");
        }
        this._default = collectionName;
    }

    public IdentityInfo createIdentity(String name) {
        IdentityInfo idInfo = new IdentityInfo(name);
        if (this._bound) {
            idInfo.setBound(this._bound);
        }
        return idInfo;
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName, boolean usejava50) {
        return this.createCollection(contentType, name, elementName, this._default, usejava50);
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName, String collectionName, boolean useJava50) {
        String temp = collectionName;
        if (temp == null || temp.length() == 0) {
            temp = this._default;
        }
        CollectionInfo cInfo = null;
        if (temp.equals(VECTOR)) {
            cInfo = new CollectionInfo(contentType, name, elementName, useJava50);
        } else if (temp.equals(ARRAY_LIST)) {
            cInfo = new CollectionInfoJ2(contentType, name, elementName, ARRAY_LIST, useJava50);
        } else if (temp.equals(ODMG)) {
            cInfo = new CollectionInfoODMG30(contentType, name, elementName, useJava50);
        } else if (temp.equals(COLLECTION)) {
            cInfo = new CollectionInfoJ2Collection(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase(SET)) {
            cInfo = new CollectionInfoJ2Set(contentType, name, elementName, useJava50);
        } else if (temp.equalsIgnoreCase(SORTED_SET)) {
            cInfo = new CollectionInfoJ2SortedSet(contentType, name, elementName, useJava50);
        }
        cInfo.setCreateExtraMethods(this._extraMethods);
        if (this._referenceSuffix != null) {
            cInfo.setReferenceMethodSuffix(this._referenceSuffix);
        }
        if (this._bound) {
            cInfo.setBound(true);
        }
        return cInfo;
    }

    public FieldInfo createFieldInfo(XSType type, String name) {
        FieldInfo fieldInfo = new FieldInfo(type, name);
        if (this._bound) {
            fieldInfo.setBound(true);
        }
        return fieldInfo;
    }

    public void setBoundProperties(boolean bound) {
        this._bound = bound;
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this._extraMethods = extraMethods;
    }

    public void setReferenceMethodSuffix(String suffix) {
        this._referenceSuffix = suffix;
    }
}

