/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.factory.FieldInfoFactory;

public final class XSDCompiler
extends Task {
    private File _schema;
    private String _pkgName;
    private String _lineSep;
    private boolean _force;
    private String _typeFactory;
    private File _destDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this._schema == null || !this._schema.exists()) {
            throw new BuildException("Schema file is required");
        }
        if (this._lineSep != null) {
            if ("win".equals(this._lineSep) || "\r\n".equals(this._lineSep)) {
                this.project.log("Using Windows style line separation.", 3);
                this._lineSep = "\r\n";
            } else if ("unix".equals(this._lineSep) || "\n".equals(this._lineSep)) {
                this.project.log("Using UNIX style line separation.", 3);
                this._lineSep = "\n";
            } else {
                if (!"mac".equals(this._lineSep) && !"\r".equals(this._lineSep)) throw new BuildException("Invalid line-separator style.");
                this.project.log("Using Macintosh style line separation.", 3);
                this._lineSep = "\r";
            }
        } else {
            this._lineSep = "\n";
        }
        SourceGenerator sgen = null;
        if (this._typeFactory != null) {
            try {
                Object factory = Class.forName(this._typeFactory).newInstance();
                sgen = new SourceGenerator((FieldInfoFactory)factory);
            }
            catch (Exception ex) {
                this.project.log("Type factory " + this._typeFactory + " is invalid.", 2);
                throw new BuildException((Throwable)ex);
            }
        } else {
            sgen = new SourceGenerator();
        }
        sgen.setLineSeparator(this._lineSep);
        sgen.setSuppressNonFatalWarnings(this._force);
        sgen.setDestDir(this._destDir.toString());
        if (this._force) {
            this.project.log("Suppressing non fatal warnings.", 3);
        }
        try {
            sgen.generateSource(this._schema.getAbsolutePath(), this._pkgName);
            return;
        }
        catch (IOException ex) {
            this.project.log("Failed to compile " + this._schema, 2);
            throw new BuildException((Throwable)ex);
        }
    }

    public void setSchema(String schema) {
        this._schema = this.project.resolveFile(schema);
    }

    public void setPackage(String pkgName) {
        this._pkgName = pkgName;
    }

    public void setLineseperator(String lineSep) {
        this._lineSep = lineSep;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setTypefactory(String typeFactory) {
        this._typeFactory = typeFactory;
    }

    public void setDestdir(String dirName) {
        this._destDir = this.project.resolveFile(dirName);
    }
}

