/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependencyCalculator {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProject mavenProject;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactInstaller installer;
    private PlexusContainer container;

    public DependencyCalculator(ArtifactFactory artifactFactory, ArtifactResolver resolver, ArtifactRepository localRepository, List remoteRepositories, MavenProject mavenProject, MavenProjectBuilder mavenProjectBuilder, ArtifactInstaller installer, PlexusContainer container) {
        this.artifactFactory = artifactFactory;
        this.resolver = resolver;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.mavenProject = mavenProject;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.installer = installer;
        this.container = container;
    }

    public Set execute() throws ArtifactResolutionException, ArtifactNotFoundException, ProjectBuildingException, FileNotFoundException, IOException, XmlPullParserException, InvalidDependencyVersionException, ArtifactInstallationException {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        this.fixupProjectArtifact();
        Artifact art = this.mavenProject.getArtifact();
        Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId() + ".cargodeps", art.getArtifactId(), art.getVersion(), "pom", null);
        this.resolver.resolve(art2, this.remoteRepositories, this.localRepository);
        MavenProject mavenProject = this.mavenProjectBuilder.buildWithDependencies(art2.getFile(), this.localRepository, (ProfileManager)profileManager);
        HashSet<File> filesToAdd = new HashSet<File>();
        for (Artifact artdep : mavenProject.getArtifacts()) {
            if (!artdep.getType().equals("jar")) continue;
            this.resolver.resolve(artdep, this.remoteRepositories, this.localRepository);
            filesToAdd.add(artdep.getFile());
        }
        return filesToAdd;
    }

    void fixupProjectArtifact() throws FileNotFoundException, IOException, XmlPullParserException, ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException, ProjectBuildingException, ArtifactInstallationException {
        MavenProject mp2 = new MavenProject(this.mavenProject);
        for (Artifact art : mp2.createArtifacts(this.artifactFactory, null, null)) {
            if (!art.getType().equals("war")) continue;
            Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), "pom", null);
            this.fixupRepositoryArtifact(art2);
        }
        Model pomFile = mp2.getModel();
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        pomFile = pomReader.read((Reader)new FileReader(outFile));
        Artifact art = mp2.getArtifact();
        this.fixModelAndSaveInRepository(art, pomFile);
        outFile.delete();
    }

    void fixupRepositoryArtifact(Artifact artifact) throws InvalidDependencyVersionException, FileNotFoundException, IOException, XmlPullParserException, ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException, ArtifactInstallationException {
        this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        File artifactFile = artifact.getFile();
        MavenProject mavenProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        for (Artifact art : mavenProject.createArtifacts(this.artifactFactory, null, null)) {
            if (!art.getType().equals("war")) continue;
            Artifact art2 = this.artifactFactory.createArtifactWithClassifier(art.getGroupId(), art.getArtifactId(), art.getVersion(), "pom", null);
            this.fixupRepositoryArtifact(art2);
        }
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model pomFile = pomReader.read((Reader)new FileReader(artifactFile));
        this.fixModelAndSaveInRepository(artifact, pomFile);
    }

    void fixModelAndSaveInRepository(Artifact artifact, Model pomFile) throws IOException, ArtifactInstallationException {
        for (Dependency art : pomFile.getDependencies()) {
            if (!art.getType().equals("war")) continue;
            art.setGroupId(art.getGroupId() + ".cargodeps");
            art.setType("pom");
        }
        pomFile.setPackaging("pom");
        String version = pomFile.getVersion();
        if (version == null) {
            version = pomFile.getParent().getVersion();
        }
        File outFile = File.createTempFile("pom", ".xml");
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write((Writer)new FileWriter(outFile), pomFile);
        Artifact art2 = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId() + ".cargodeps", artifact.getArtifactId(), artifact.getVersion(), "pom", null);
        this.installer.install(outFile, art2, this.localRepository);
        outFile.delete();
    }
}

